/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport;

import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledFuture;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.CreateException;
import org.mule.api.transport.Connector;
import org.mule.config.i18n.CoreMessages;
import org.mule.transport.AbstractMessageReceiver;
import org.mule.transport.PollingReceiverWorker;
import org.mule.transport.PollingReceiverWorkerSchedule;
import org.mule.util.ObjectUtils;

public abstract class AbstractPollingMessageReceiver
extends AbstractMessageReceiver {
    public static final long DEFAULT_POLL_FREQUENCY = 1000L;
    public static final TimeUnit DEFAULT_POLL_TIMEUNIT = TimeUnit.MILLISECONDS;
    public static final long DEFAULT_STARTUP_DELAY = 1000L;
    private long frequency = 1000L;
    private TimeUnit timeUnit = DEFAULT_POLL_TIMEUNIT;
    protected final List<ScheduledFuture> schedules = new LinkedList<ScheduledFuture>();

    public AbstractPollingMessageReceiver(Connector connector, FlowConstruct flowConstruct, InboundEndpoint endpoint) throws CreateException {
        super(connector, flowConstruct, endpoint);
    }

    protected void doStart() throws MuleException {
        try {
            this.schedule();
        }
        catch (Exception ex) {
            this.stop();
            throw new CreateException(CoreMessages.failedToScheduleWork(), ex, this);
        }
    }

    protected void doStop() throws MuleException {
        this.unschedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() throws RejectedExecutionException, NullPointerException, IllegalArgumentException {
        List<ScheduledFuture> list = this.schedules;
        synchronized (list) {
            ScheduledFuture schedule = this.connector.getScheduler().scheduleWithFixedDelay((Runnable)new PollingReceiverWorkerSchedule(this.createWork()), 1000L, this.getFrequency(), this.getTimeUnit());
            this.schedules.add(schedule);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)(ObjectUtils.identityToShortString(this) + " scheduled " + ObjectUtils.identityToShortString(schedule) + " with " + this.frequency + " " + this.getTimeUnit() + " polling frequency"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unschedule() {
        List<ScheduledFuture> list = this.schedules;
        synchronized (list) {
            Iterator<ScheduledFuture> i = this.schedules.iterator();
            while (i.hasNext()) {
                ScheduledFuture schedule = i.next();
                schedule.cancel(false);
                i.remove();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)(ObjectUtils.identityToShortString(this) + " cancelled polling schedule: " + ObjectUtils.identityToShortString(schedule)));
            }
        }
    }

    protected PollingReceiverWorker createWork() {
        return new PollingReceiverWorker(this);
    }

    public long getFrequency() {
        return this.frequency;
    }

    public void setFrequency(long value) {
        this.frequency = value <= 0L ? 1000L : value;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public abstract void poll() throws Exception;
}

