/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi;

import java.io.InputStream;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.MimeTypeParseException;
import org.ibeans.api.DataType;
import org.ibeans.api.Response;
import org.ibeans.api.channel.MimeTypes;
import org.ibeans.impl.support.datatype.DataTypeFactory;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.transformer.TransformerException;
import org.mule.module.ibeans.spi.support.DataTypeConverter;
import org.mule.transport.NullPayload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleResponseMessage
implements Response {
    private MuleMessage message;
    private DataType dataType;
    private String status;

    public MuleResponseMessage(MuleMessage message) throws MimeTypeParseException {
        this.message = message;
        if (message.getDataType() == null) {
            String mime = (String)message.findPropertyInAnyScope("Content-Type", null);
            if (mime == null) {
                mime = (String)message.findPropertyInAnyScope("ContentType", null);
            }
            if (mime == null) {
                mime = MimeTypes.ANY.getBaseType();
            }
            this.dataType = DataTypeFactory.create(message.getPayload().getClass(), (String)mime);
        } else {
            this.dataType = DataTypeConverter.convertMuleToIBeans(message.getDataType());
        }
        this.status = (String)message.getInboundProperty("http.status");
    }

    public String getStatusCode() {
        return this.status;
    }

    public void setStatusCode(String code) {
        this.status = code;
    }

    public String getMimeType() {
        return this.dataType.getMimeType();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public InputStream getPayloadAsStream() {
        if (this.message.getPayload() instanceof NullPayload) {
            return null;
        }
        try {
            return (InputStream)this.message.getPayload(InputStream.class);
        }
        catch (TransformerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public Object getPayload() {
        if (this.message.getPayload() instanceof NullPayload) {
            return null;
        }
        return this.message.getPayload();
    }

    public Object getHeader(String name) {
        return this.message.getInboundProperty(name);
    }

    public Set<String> getHeaderNames() {
        return this.message.getInboundPropertyNames();
    }

    public DataHandler getAttachment(String name) {
        return this.message.getInboundAttachment(name);
    }

    public Set<String> getAttachmentNames() {
        return this.message.getInboundAttachmentNames();
    }

    public MuleMessage getMessage() {
        return this.message;
    }

    public Throwable getException() {
        if (this.message.getExceptionPayload() != null) {
            return this.message.getExceptionPayload().getRootException();
        }
        return null;
    }
}

