/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.ibeans.spi.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.MalformedEndpointException;
import org.mule.api.transformer.Transformer;
import org.mule.config.endpoint.AnnotatedEndpointData;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.ibeans.spi.support.DynamicRequestEndpoint;
import org.mule.transport.AbstractConnector;
import org.mule.util.UriParamFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallRequestEndpoint
extends DynamicRequestEndpoint {
    protected final transient Log logger = LogFactory.getLog(CallRequestEndpoint.class);
    private static final long serialVersionUID = 1861985949279708458L;
    private static List<Transformer> transformers = new ArrayList<Transformer>();
    private static List<Transformer> responseTransformers = new ArrayList<Transformer>();
    private UriParamFilter filter = new UriParamFilter();

    public CallRequestEndpoint(MuleContext context, AnnotatedEndpointData epData) throws MalformedEndpointException {
        super(context, CallRequestEndpoint.createInboundBuilder(context, epData), epData.getAddress());
    }

    @Override
    protected void validateUriTemplate(String uri) throws MalformedEndpointException {
        if (uri.indexOf(":") > uri.indexOf(this.parser.getStyle().getPrefix())) {
            throw new MalformedEndpointException(CoreMessages.dynamicEndpointsMustSpecifyAScheme(), uri);
        }
    }

    private static EndpointBuilder createInboundBuilder(MuleContext context, AnnotatedEndpointData epData) {
        try {
            EndpointBuilder builder = context.getRegistry().lookupEndpointFactory().getEndpointBuilder("dynamic://null");
            builder.setExchangePattern(epData.getMep());
            builder.setConnector(epData.getConnector());
            builder.setName(epData.getName());
            builder.setProperties(epData.getProperties() == null ? new HashMap() : epData.getProperties());
            return builder;
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String parseURIString(String uri, MuleMessage message) {
        Map<String, Object> props = this.getPropertiesForTemplate(message);
        String newUriString = this.parser.parse(props, uri);
        newUriString = this.filter.filterParamsByValue(newUriString, "null.param");
        return super.parseURIString(newUriString, message);
    }

    @Override
    protected Map<String, Object> getPropertiesForTemplate(MuleMessage message) {
        Map props = (Map)message.findPropertyInAnyScope("ibeans.uri.params", null);
        if (props == null) {
            throw new IllegalStateException("ibeans.uri.params not set on message");
        }
        return props;
    }

    public List getTransformers() {
        if (transformers.size() == 0) {
            try {
                transformers.addAll(((AbstractConnector)this.getConnector()).getDefaultInboundTransformers((ImmutableEndpoint)this));
                for (Transformer tran : transformers) {
                    tran.setEndpoint((ImmutableEndpoint)this);
                    tran.setMuleContext(this.getMuleContext());
                    tran.initialise();
                }
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
        }
        return transformers;
    }

    public List getResponseTransformers() {
        if (responseTransformers.size() == 0) {
            try {
                responseTransformers.addAll(((AbstractConnector)this.getConnector()).getDefaultResponseTransformers((ImmutableEndpoint)this));
                for (Transformer tran : responseTransformers) {
                    tran.setEndpoint((ImmutableEndpoint)this);
                    tran.setMuleContext(this.getMuleContext());
                    tran.initialise();
                }
            }
            catch (MuleException e) {
                throw new RuntimeException(e);
            }
        }
        return transformers;
    }
}

