/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.ibean;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.service.Service;
import org.mule.api.transport.Connector;
import org.mule.transport.AbstractPollingMessageReceiver;
import org.mule.transport.NullPayload;
import org.mule.transport.ibean.IBeansConnector;

public class IBeansMessageReceiver
extends AbstractPollingMessageReceiver {
    private Object ibean;
    private Method ibeanMethod;
    private Object[] callParams;
    private String methodName;

    public IBeansMessageReceiver(Connector connector, Service service, InboundEndpoint endpoint) throws MuleException {
        super(connector, (FlowConstruct)service, endpoint);
        this.setFrequency(60L);
        this.setTimeUnit(TimeUnit.SECONDS);
        List state = (List)endpoint.getProperty((Object)"ibean.state.params");
        if (state == null) {
            state = Collections.emptyList();
        }
        this.ibean = ((IBeansConnector)connector).createIbean(endpoint.getEndpointURI(), state);
        String address = endpoint.getEndpointURI().getAddress();
        this.methodName = address.substring(address.indexOf(".") + 1);
        List params = (List)endpoint.getProperty((Object)"ibean.call.params");
        if (params == null) {
            params = Collections.emptyList();
        }
        ExpressionManager em = connector.getMuleContext().getExpressionManager();
        DefaultMuleMessage defaultMessage = new DefaultMuleMessage((Object)NullPayload.getInstance(), endpoint.getProperties(), connector.getMuleContext());
        this.callParams = new Object[params.size()];
        int i = 0;
        for (Object param : params) {
            if (param instanceof String && em.isExpression(param.toString())) {
                param = em.parse(param.toString(), (MuleMessage)defaultMessage);
            }
            this.callParams[i++] = param;
        }
    }

    public void poll() throws Exception {
        if (this.ibeanMethod == null) {
            this.ibeanMethod = this.getMethod();
        }
        this.ibeanMethod.invoke(this.ibean, this.callParams);
    }

    protected Method getMethod() throws NoSuchMethodException {
        Class[] paramTypes = new Class[this.callParams.length];
        int i = 0;
        for (Object param : this.callParams) {
            paramTypes[i++] = param.getClass();
        }
        return this.ibean.getClass().getMethod(this.methodName, paramTypes);
    }
}

