/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.ArrayList;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.DocumentWrapper;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceIterator;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Node node;
    private int namecode = -1;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;
    protected int span = 1;

    protected NodeWrapper(Node node, NodeWrapper nodeWrapper, int n) {
        this.node = node;
        this.parent = nodeWrapper;
        this.index = n;
    }

    protected NodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper) {
        if (node == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: Node must not be null");
        }
        if (documentWrapper == null) {
            throw new NullPointerException("NodeWrapper#makeWrapper: DocumentWrapper must not be null");
        }
        return this.makeWrapper(node, documentWrapper, null, -1);
    }

    protected NodeWrapper makeWrapper(Node node, DocumentWrapper documentWrapper, NodeWrapper nodeWrapper, int n) {
        NodeWrapper nodeWrapper2;
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                return documentWrapper;
            }
            case 1: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = 1;
                break;
            }
            case 2: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)2;
                break;
            }
            case 3: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)3;
                break;
            }
            case 4: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)3;
                break;
            }
            case 8: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)8;
                break;
            }
            case 7: {
                nodeWrapper2 = new NodeWrapper(node, nodeWrapper, n);
                nodeWrapper2.nodeKind = (short)7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported node type in DOM! " + node.getNodeType() + " instance " + node.toString());
            }
        }
        nodeWrapper2.docWrapper = documentWrapper;
        return nodeWrapper2;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((Item)((AtomicValue)this.atomize()));
    }

    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 631;
        }
        return 630;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NodeWrapper)) {
            return false;
        }
        return this.node.isSameNode(((NodeWrapper)nodeInfo).node);
    }

    public boolean equals(Object object) {
        if (object instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)object);
        }
        return false;
    }

    public int hashCode() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(20);
        this.generateId(fastStringBuffer);
        return fastStringBuffer.toString().hashCode();
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String string) {
        this.docWrapper.baseURI = string;
    }

    public String getBaseURI() {
        NodeWrapper nodeWrapper = this;
        if (this.getNodeKind() != 1) {
            nodeWrapper = this.getParent();
        }
        while (nodeWrapper != null) {
            String string = nodeWrapper.getAttributeValue(385);
            if (string != null) {
                return string;
            }
            nodeWrapper = nodeWrapper.getParent();
        }
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (nodeInfo instanceof NodeWrapper) {
            if (this.isSameNodeInfo(nodeInfo)) {
                return 0;
            }
            try {
                short s = this.node.compareDocumentPosition(((NodeWrapper)nodeInfo).node);
                if ((s & 0xA) != 0) {
                    return 1;
                }
                if ((s & 0x14) != 0) {
                    return -1;
                }
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        if (nodeInfo instanceof SiblingCountingNode) {
            return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)nodeInfo));
        }
        return -nodeInfo.compareOrder((NodeInfo)this);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        switch (this.nodeKind) {
            case 1: 
            case 9: {
                NodeList nodeList = this.node.getChildNodes();
                StringBuffer stringBuffer = new StringBuffer(16);
                NodeWrapper.expandStringValue(nodeList, stringBuffer);
                return stringBuffer;
            }
            case 2: {
                return ((Attr)this.node).getValue();
            }
            case 3: {
                if (this.span == 1) {
                    return this.node.getNodeValue();
                }
                FastStringBuffer fastStringBuffer = new FastStringBuffer(100);
                Node node = this.node;
                for (int i = 0; i < this.span; ++i) {
                    fastStringBuffer.append(node.getNodeValue());
                    node = node.getNextSibling();
                }
                return fastStringBuffer.condense();
            }
            case 7: 
            case 8: {
                return this.node.getNodeValue();
            }
        }
        return "";
    }

    private static CharSequence getStringValue(Node node, int n) {
        switch (n) {
            case 1: 
            case 9: {
                NodeList nodeList = node.getChildNodes();
                StringBuffer stringBuffer = new StringBuffer(16);
                NodeWrapper.expandStringValue(nodeList, stringBuffer);
                return stringBuffer;
            }
            case 2: {
                return ((Attr)node).getValue();
            }
            case 3: 
            case 4: {
                return node.getNodeValue();
            }
            case 7: 
            case 8: {
                return node.getNodeValue();
            }
        }
        return "";
    }

    private static void expandStringValue(NodeList nodeList, StringBuffer stringBuffer) {
        int n = nodeList.getLength();
        block4: for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 1: {
                    NodeWrapper.expandStringValue(node.getChildNodes(), stringBuffer);
                    continue block4;
                }
                case 7: 
                case 8: {
                    continue block4;
                }
                default: {
                    stringBuffer.append(node.getNodeValue());
                }
            }
        }
    }

    public int getNameCode() {
        if (this.namecode != -1) {
            return this.namecode;
        }
        int n = this.getNodeKind();
        if (n == 1 || n == 2) {
            String string = this.node.getPrefix();
            if (string == null) {
                string = "";
            }
            this.namecode = this.docWrapper.getNamePool().allocate(string, this.getURI(), this.getLocalPart());
            return this.namecode;
        }
        if (n == 7) {
            this.namecode = this.docWrapper.getNamePool().allocate("", "", this.getLocalPart());
            return this.namecode;
        }
        return -1;
    }

    public int getFingerprint() {
        int n = this.getNameCode();
        if (n == -1) {
            return -1;
        }
        return n & 0xFFFFF;
    }

    public String getLocalPart() {
        String string = this.node.getLocalName();
        if (string == null) {
            String string2 = this.getDisplayName();
            int n = string2.indexOf(58);
            if (n >= 0) {
                return string2.substring(n + 1);
            }
            return string2;
        }
        return string;
    }

    public String getURI() {
        String[] stringArray;
        NodeWrapper nodeWrapper;
        if (this.nodeKind == 1) {
            nodeWrapper = this;
        } else if (this.nodeKind == 2) {
            nodeWrapper = this.parent;
        } else {
            return "";
        }
        String string = this.node.getNamespaceURI();
        if (string != null) {
            return string;
        }
        if (this.node.getNodeName().startsWith("xml:")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        try {
            stringArray = Name11Checker.getInstance().getQNameParts((CharSequence)this.node.getNodeName());
        }
        catch (QNameException qNameException) {
            throw new IllegalStateException("Invalid QName in DOM node. " + (Object)((Object)qNameException));
        }
        if (this.nodeKind == 2 && stringArray[0].equals("")) {
            string = "";
        } else {
            NodeInfo nodeInfo;
            AxisIterator axisIterator = nodeWrapper.iterateAxis((byte)8);
            while ((nodeInfo = (NodeInfo)axisIterator.next()) != null) {
                if (!nodeInfo.getLocalPart().equals(stringArray[0])) continue;
                string = nodeInfo.getStringValue();
                break;
            }
            if (string == null) {
                if (stringArray[0].equals("")) {
                    string = "";
                } else {
                    throw new IllegalStateException("Undeclared namespace prefix in DOM input: " + stringArray[0]);
                }
            }
        }
        return string;
    }

    public String getPrefix() {
        return this.node.getPrefix();
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: {
                return this.node.getNodeName();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            switch (this.getNodeKind()) {
                case 2: {
                    this.parent = this.makeWrapper(((Attr)this.node).getOwnerElement(), this.docWrapper);
                    break;
                }
                default: {
                    Node node = this.node.getParentNode();
                    if (node == null) {
                        return null;
                    }
                    this.parent = this.makeWrapper(node, this.docWrapper);
                }
            }
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        if (this.index == -1) {
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    int n = 0;
                    Node node = this.node;
                    while (true) {
                        if ((node = node.getPreviousSibling()) == null) {
                            this.index = n;
                            return n;
                        }
                        ++n;
                    }
                }
                case 2: {
                    int n = 0;
                    int n2 = this.getFingerprint();
                    AxisIterator axisIterator = this.parent.iterateAxis((byte)2);
                    while (true) {
                        NodeInfo nodeInfo;
                        if ((nodeInfo = (NodeInfo)axisIterator.next()) == null || nodeInfo.getFingerprint() == n2) {
                            this.index = n;
                            return n;
                        }
                        ++n;
                    }
                }
                case 13: {
                    int n = 0;
                    int n3 = this.getFingerprint();
                    AxisIterator axisIterator = this.parent.iterateAxis((byte)8);
                    while (true) {
                        NodeInfo nodeInfo;
                        if ((nodeInfo = (NodeInfo)axisIterator.next()) == null || nodeInfo.getFingerprint() == n3) {
                            this.index = n;
                            return n;
                        }
                        ++n;
                    }
                }
            }
            this.index = 0;
            return this.index;
        }
        return this.index;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AncestorEnumeration((NodeInfo)this, false);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return SingleNodeIterator.makeIterator((NodeInfo)this);
                }
                return new Navigator.AncestorEnumeration((NodeInfo)this, true);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new AttributeEnumeration(this);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new ChildEnumeration(this, true, true);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.DescendantEnumeration((NodeInfo)this, false, true);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.DescendantEnumeration((NodeInfo)this, true, true);
            }
            case 6: {
                return new Navigator.FollowingEnumeration((NodeInfo)this);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new ChildEnumeration(this, false, true);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return NamespaceIterator.makeIterator((NodeInfo)this, null);
            }
            case 9: {
                this.getParent();
                return SingleNodeIterator.makeIterator((NodeInfo)this.parent);
            }
            case 10: {
                return new Navigator.PrecedingEnumeration((NodeInfo)this, false);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new ChildEnumeration(this, false, false);
            }
            case 12: {
                return SingleNodeIterator.makeIterator((NodeInfo)this);
            }
            case 13: {
                return new Navigator.PrecedingEnumeration((NodeInfo)this, true);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        return new Navigator.AxisFilter(this.iterateAxis(by), nodeTest);
    }

    public String getAttributeValue(int n) {
        NameTest nameTest = new NameTest(2, n, this.getNamePool());
        AxisIterator axisIterator = this.iterateAxis((byte)2, (NodeTest)nameTest);
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (nodeInfo == null) {
            return null;
        }
        return nodeInfo.getStringValue();
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        if (this.node.getNodeType() == 2) {
            return false;
        }
        return this.node.hasChildNodes();
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (FastStringBuffer)fastStringBuffer, (boolean)true);
    }

    public int getDocumentNumber() {
        return this.getDocumentRoot().getDocumentNumber();
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)receiver, (NamePool)this.docWrapper.getNamePool(), (int)n, (boolean)bl, (int)n2);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) throws XPathException {
        Navigator.sendNamespaceDeclarations((NodeInfo)this, (Receiver)receiver, (boolean)bl);
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        if (this.node.getNodeType() == 1) {
            Attr attr;
            Element element = (Element)this.node;
            NamedNodeMap namedNodeMap = element.getAttributes();
            if (namedNodeMap == null) {
                return EMPTY_NAMESPACE_LIST;
            }
            int n = 0;
            int n2 = namedNodeMap.getLength();
            for (int i = 0; i < n2; ++i) {
                attr = (Attr)namedNodeMap.item(i);
                String string = attr.getName();
                if (string.equals("xmlns")) {
                    ++n;
                    continue;
                }
                if (!string.startsWith("xmlns:")) continue;
                ++n;
            }
            if (n == 0) {
                return EMPTY_NAMESPACE_LIST;
            }
            int[] nArray2 = n > nArray.length ? new int[n] : nArray;
            attr = this.getNamePool();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                String string;
                String string2;
                Attr attr2 = (Attr)namedNodeMap.item(i);
                String string3 = attr2.getName();
                if (string3.equals("xmlns")) {
                    string2 = "";
                    string = attr2.getValue();
                    nArray2[n3++] = attr.allocateNamespaceCode(string2, string);
                    continue;
                }
                if (!string3.startsWith("xmlns:")) continue;
                string2 = string3.substring(6);
                string = attr2.getValue();
                nArray2[n3++] = attr.allocateNamespaceCode(string2, string);
            }
            if (n < nArray2.length) {
                nArray2[n] = -1;
            }
            return nArray2;
        }
        return null;
    }

    private final class ChildEnumeration
    extends AxisIteratorImpl
    implements LookaheadIterator {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ArrayList items = new ArrayList(20);
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper nodeWrapper2, boolean bl, boolean bl2) {
            this.start = nodeWrapper2;
            this.downwards = bl;
            this.forwards = bl2;
            this.position = 0;
            this.commonParent = bl ? nodeWrapper2 : (NodeWrapper)nodeWrapper2.getParent();
            NodeList nodeList = this.commonParent.node.getChildNodes();
            if (bl) {
                if (!bl2) {
                    this.ix = nodeList.getLength() - 1;
                }
            } else {
                this.ix = nodeWrapper2.getSiblingPosition() + (bl2 ? NodeWrapper.this.span : -1);
            }
            if (bl2) {
                boolean bl3 = false;
                int n = nodeList.getLength();
                block8: for (int i = this.ix; i < n; ++i) {
                    boolean bl4 = false;
                    Node node = nodeList.item(i);
                    switch (node.getNodeType()) {
                        case 10: {
                            continue block8;
                        }
                        case 3: 
                        case 4: {
                            bl4 = true;
                            if (bl3) {
                                NodeWrapper nodeWrapper3 = (NodeWrapper)this.items.get(this.items.size() - 1);
                                ++nodeWrapper3.span;
                                continue block8;
                            }
                        }
                        default: {
                            bl3 = bl4;
                            this.items.add(NodeWrapper.this.makeWrapper(node, NodeWrapper.this.docWrapper, this.commonParent, i));
                        }
                    }
                }
            } else {
                boolean bl5 = false;
                block9: for (int i = this.ix; i >= 0; --i) {
                    boolean bl6 = false;
                    Node node = nodeList.item(i);
                    switch (node.getNodeType()) {
                        case 10: {
                            continue block9;
                        }
                        case 3: 
                        case 4: {
                            bl6 = true;
                            if (bl5) {
                                NodeWrapper nodeWrapper4 = (NodeWrapper)this.items.get(this.items.size() - 1);
                                nodeWrapper4.node = node;
                                ++nodeWrapper4.span;
                                continue block9;
                            }
                        }
                        default: {
                            bl5 = bl6;
                            this.items.add(NodeWrapper.this.makeWrapper(node, NodeWrapper.this.docWrapper, this.commonParent, i));
                        }
                    }
                }
            }
        }

        public boolean hasNext() {
            return this.position < this.items.size();
        }

        public Item next() {
            if (this.position < this.items.size()) {
                this.current = (NodeInfo)this.items.get(this.position++);
                return this.current;
            }
            return null;
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }

        public int getProperties() {
            return 4;
        }
    }

    private final class AttributeEnumeration
    implements AxisIterator,
    LookaheadIterator {
        private ArrayList attList = new ArrayList(10);
        private int ix = 0;
        private NodeWrapper start;
        private NodeWrapper current;

        public AttributeEnumeration(NodeWrapper nodeWrapper2) {
            this.start = nodeWrapper2;
            NamedNodeMap namedNodeMap = nodeWrapper2.node.getAttributes();
            if (namedNodeMap != null) {
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    String string = namedNodeMap.item(i).getNodeName();
                    if (string.startsWith("xmlns") && (string.length() == 5 || string.charAt(5) == ':')) continue;
                    this.attList.add(namedNodeMap.item(i));
                }
            }
            this.ix = 0;
        }

        public boolean hasNext() {
            return this.ix < this.attList.size();
        }

        public boolean moveNext() {
            return this.next() != null;
        }

        public Item next() {
            if (this.ix >= this.attList.size()) {
                return null;
            }
            this.current = this.start.makeWrapper((Attr)this.attList.get(this.ix), NodeWrapper.this.docWrapper, this.start, this.ix);
            ++this.ix;
            return this.current;
        }

        public Item current() {
            return this.current;
        }

        public int position() {
            return this.ix + 1;
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            return this.current.iterateAxis(by, nodeTest);
        }

        public Value atomize() throws XPathException {
            return this.current.atomize();
        }

        public CharSequence getStringValue() {
            return this.current.getStringValueCS();
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }

        public int getProperties() {
            return 4;
        }
    }
}

