/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.cxf.support;

import java.util.List;
import javanet.staxutils.ContentHandlerToXMLStreamWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.sax.SAXResult;
import org.apache.cxf.databinding.stax.XMLStreamWriterCallback;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.staxutils.StaxUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.TransformerException;
import org.mule.module.xml.transformer.DelayedResult;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class OutputPayloadInterceptor
extends AbstractOutDatabindingInterceptor {
    public OutputPayloadInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        MessageContentsList objs = MessageContentsList.getContentsList((Message)message);
        if (objs == null || objs.size() == 0) {
            return;
        }
        List originalParts = (List)objs.clone();
        objs.clear();
        for (Object o : originalParts) {
            if (o instanceof MuleMessage) {
                try {
                    MuleMessage muleMsg = (MuleMessage)o;
                    final Object payload = muleMsg.getPayload();
                    if (payload instanceof DelayedResult) {
                        o = this.getDelayedResultCallback((DelayedResult)payload);
                    } else if (payload instanceof XMLStreamReader) {
                        o = new XMLStreamWriterCallback(){

                            public void write(XMLStreamWriter writer) throws Fault, XMLStreamException {
                                XMLStreamReader xsr = (XMLStreamReader)payload;
                                StaxUtils.copy((XMLStreamReader)xsr, (XMLStreamWriter)writer);
                                writer.flush();
                                xsr.close();
                            }
                        };
                    } else {
                        if (payload instanceof NullPayload) break;
                        o = muleMsg.getPayload(DataTypeFactory.create(XMLStreamReader.class));
                    }
                    objs.add(o);
                    continue;
                }
                catch (TransformerException e) {
                    throw new Fault((Throwable)e);
                }
            }
            objs.add(o);
        }
    }

    protected Object getDelayedResultCallback(final DelayedResult r) {
        return new XMLStreamWriterCallback(){

            public void write(XMLStreamWriter writer) throws Fault, XMLStreamException {
                ContentHandlerToXMLStreamWriter handler = new ContentHandlerToXMLStreamWriter(writer){

                    public void endDocument() throws SAXException {
                    }

                    public void processingInstruction(String target, String data) throws SAXException {
                    }

                    public void startDocument() throws SAXException {
                    }

                    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                    }
                };
                try {
                    r.write((Result)new SAXResult((ContentHandler)handler));
                }
                catch (Exception e) {
                    throw new Fault((Throwable)e);
                }
            }
        };
    }
}

