/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jbpm;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jbpm.api.Configuration;
import org.jbpm.api.Execution;
import org.jbpm.api.ProcessEngine;
import org.jbpm.api.ProcessInstance;
import org.jbpm.api.task.Task;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.transport.bpm.BPMS;
import org.mule.transport.bpm.MessageService;
import org.mule.transport.jbpm.EndedProcess;
import org.mule.transport.jbpm.MuleMessageService;
import org.mule.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jbpm
implements BPMS,
Initialisable,
Disposable {
    protected static final Logger log = LoggerFactory.getLogger(Jbpm.class);
    public static final String PROCESS_ENDED = "Process has ended";
    protected ProcessEngine processEngine = null;
    private String configurationResource;
    private Properties processDefinitions;
    protected boolean containerManaged = true;

    public Jbpm() {
    }

    public Jbpm(String configurationResource, Properties processDefinitions) {
        this.configurationResource = configurationResource;
        this.processDefinitions = processDefinitions;
    }

    public Jbpm(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public void initialise() {
        if (this.processEngine == null) {
            Configuration config = new Configuration();
            if (this.configurationResource != null) {
                config.setResource(this.configurationResource);
            }
            this.setProcessEngine(config.buildProcessEngine());
            this.containerManaged = false;
        }
        if (this.processDefinitions != null) {
            for (Object def : this.processDefinitions.values()) {
                try {
                    this.deployProcess((String)def);
                }
                catch (IOException e) {
                    log.error("Unable to deploy process definition: " + e.getMessage());
                }
            }
        }
    }

    public void dispose() {
        if (!this.containerManaged && this.processEngine != null) {
            this.processEngine.close();
            this.processEngine = null;
        }
    }

    public void setMessageService(MessageService msgService) {
        MuleMessageService serviceProxy = (MuleMessageService)this.processEngine.get(MuleMessageService.class);
        serviceProxy.setMessageService(msgService);
    }

    public Object startProcess(Object processDefinitionKey) throws Exception {
        return this.startProcess(processDefinitionKey, null, null);
    }

    public Object startProcess(Object processDefinitionKey, Object signalName, Map variables) throws Exception {
        ProcessInstance processInstance = this.processEngine.getExecutionService().startProcessInstanceByKey((String)processDefinitionKey, variables);
        if (processInstance == null) {
            throw new IllegalArgumentException("No process definition found for process " + processDefinitionKey);
        }
        return processInstance;
    }

    public Object advanceProcess(Object executionId) throws Exception {
        return this.advanceProcess(executionId, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object advanceProcess(Object executionId, Object signalName, Map variables) throws Exception {
        Execution execution = this.processEngine.getExecutionService().findExecutionById((String)executionId);
        if (execution == null) {
            throw new IllegalArgumentException("No process execution found with id = " + executionId + " (it may have already terminated)");
        }
        String processId = execution.getProcessInstance() != null ? execution.getProcessInstance().getId() : execution.getId();
        if (variables != null && !variables.isEmpty()) {
            this.processEngine.getExecutionService().setVariables((String)executionId, variables);
        }
        Jbpm jbpm = this;
        synchronized (jbpm) {
            this.processEngine.getExecutionService().signalExecutionById((String)executionId, (String)signalName, variables);
        }
        ProcessInstance process = this.processEngine.getExecutionService().findProcessInstanceById(processId);
        if (process == null) {
            process = new EndedProcess(processId);
        }
        return process;
    }

    public Object updateProcess(Object executionId, Map variables) throws Exception {
        ProcessInstance process;
        Execution execution = this.processEngine.getExecutionService().findExecutionById((String)executionId);
        if (execution == null) {
            throw new IllegalArgumentException("No process execution found with id = " + executionId + " (it may have already terminated)");
        }
        String processId = execution.getProcessInstance() != null ? execution.getProcessInstance().getId() : execution.getId();
        if (variables != null && !variables.isEmpty()) {
            this.processEngine.getExecutionService().setVariables((String)executionId, variables);
        }
        if ((process = this.processEngine.getExecutionService().findProcessInstanceById(processId)) == null) {
            process = new EndedProcess(processId);
        }
        return process;
    }

    public void abortProcess(Object processInstanceId) throws Exception {
        this.processEngine.getExecutionService().endProcessInstance((String)processInstanceId, "ended");
    }

    public boolean isProcess(Object obj) throws Exception {
        return obj instanceof ProcessInstance;
    }

    public Object getId(Object process) throws Exception {
        return ((ProcessInstance)process).getId();
    }

    public Object getState(Object process) throws Exception {
        return Jbpm.getState((ProcessInstance)process);
    }

    public static String getState(ProcessInstance processInstance) throws Exception {
        if (processInstance == null || processInstance.isEnded()) {
            return "ended";
        }
        Set activities = processInstance.findActiveActivityNames();
        String state = null;
        for (Object activityName : activities) {
            if (state == null) {
                state = (String)activityName;
                continue;
            }
            state = state + " / " + activityName;
        }
        return state;
    }

    public boolean hasEnded(Object process) throws Exception {
        return process == null ? true : ((ProcessInstance)process).isEnded();
    }

    public Object lookupProcess(Object processId) throws Exception {
        return this.processEngine.getExecutionService().findProcessInstanceById((String)processId);
    }

    public void deployProcess(String processDefinitionFile) throws IOException {
        this.deployProcessFromStream(processDefinitionFile, IOUtils.getResourceAsStream(processDefinitionFile, this.getClass()));
    }

    public void deployProcessFromStream(String resourceName, InputStream processDefinition) throws IOException {
        this.processEngine.getRepositoryService().createDeployment().addResourceFromInputStream(resourceName, processDefinition).deploy();
    }

    public void completeTask(Task task) {
        this.completeTask(task, null, null);
    }

    public void completeTask(Task task, String outcome, Map variables) {
        this.processEngine.getTaskService().completeTask(task.getId(), outcome, variables);
    }

    public ProcessEngine getProcessEngine() {
        return this.processEngine;
    }

    public void setProcessEngine(ProcessEngine processEngine) {
        this.processEngine = processEngine;
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public Properties getProcessDefinitions() {
        return this.processDefinitions;
    }

    public void setProcessDefinitions(Properties processDefinitions) {
        this.processDefinitions = processDefinitions;
    }
}

