/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.model.streaming.CallbackOutputStream;
import org.mule.transport.AbstractConnector;
import org.mule.transport.ConfigurableKeyedObjectPool;
import org.mule.transport.tcp.AbstractTcpSocketFactory;
import org.mule.transport.tcp.SimpleServerSocketFactory;
import org.mule.transport.tcp.TcpProtocol;
import org.mule.transport.tcp.TcpServerSocketFactory;
import org.mule.transport.tcp.TcpSocketFactory;
import org.mule.transport.tcp.TcpSocketKey;
import org.mule.transport.tcp.protocols.SafeProtocol;
import org.mule.util.monitor.ExpiryMonitor;

public class TcpConnector
extends AbstractConnector {
    public static final String TCP = "tcp";
    public static final String KEEP_SEND_SOCKET_OPEN_PROPERTY = "keepSendSocketOpen";
    public static final int DEFAULT_SOCKET_TIMEOUT = -1;
    public static final int DEFAULT_SO_LINGER = -1;
    public static final int DEFAULT_BUFFER_SIZE = -1;
    public static final int DEFAULT_BACKLOG = -1;
    public static final boolean SERVER = false;
    public static final boolean CLIENT = true;
    private int clientSoTimeout = -1;
    private int serverSoTimeout = -1;
    private int sendBufferSize = -1;
    private int receiveBufferSize = -1;
    private int receiveBacklog = -1;
    private boolean sendTcpNoDelay;
    private Boolean reuseAddress = Boolean.TRUE;
    private int socketSoLinger = -1;
    private TcpProtocol tcpProtocol;
    private AbstractTcpSocketFactory socketFactory;
    private SimpleServerSocketFactory serverSocketFactory;
    private GenericKeyedObjectPool socketsPool = new GenericKeyedObjectPool();
    private int keepAliveTimeout = 0;
    private ExpiryMonitor keepAliveMonitor;
    private boolean keepSendSocketOpen = false;
    private boolean keepAlive = false;
    private TcpSocketKey lastSocketKey;

    public TcpConnector(MuleContext context) {
        super(context);
        this.setSocketFactory(new TcpSocketFactory());
        this.setServerSocketFactory(new TcpServerSocketFactory());
        this.setTcpProtocol(new SafeProtocol());
        this.keepAliveMonitor = new ExpiryMonitor("SocketTimeoutMonitor", 1000, this.getClass().getClassLoader());
    }

    public void configureSocket(boolean client, Socket socket) throws SocketException {
        if (this.newValue(this.getReceiveBufferSize(), socket.getReceiveBufferSize())) {
            socket.setReceiveBufferSize(this.getReceiveBufferSize());
        }
        if (this.newValue(this.getSendBufferSize(), socket.getSendBufferSize())) {
            socket.setSendBufferSize(this.getSendBufferSize());
        }
        if (client) {
            if (this.newValue(this.getClientSoTimeout(), socket.getSoTimeout())) {
                socket.setSoTimeout(this.getClientSoTimeout());
            }
        } else if (this.newValue(this.getServerSoTimeout(), socket.getSoTimeout())) {
            socket.setSoTimeout(this.getServerSoTimeout());
        }
        if (this.newValue(this.getSocketSoLinger(), socket.getSoLinger())) {
            socket.setSoLinger(true, this.getSocketSoLinger());
        }
        try {
            socket.setTcpNoDelay(this.isSendTcpNoDelay());
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        socket.setKeepAlive(this.isKeepAlive());
    }

    private boolean newValue(int parameter, int socketValue) {
        return parameter != -1 && parameter != socketValue;
    }

    protected void doInitialise() throws InitialisationException {
        this.socketsPool.setFactory((KeyedPoolableObjectFactory)this.getSocketFactory());
        this.socketsPool.setTestOnBorrow(true);
        this.socketsPool.setTestOnReturn(true);
        this.socketsPool.setMaxActive(1);
        this.socketsPool.setWhenExhaustedAction((byte)1);
    }

    protected void doDispose() {
        this.logger.debug((Object)"Closing TCP connector");
        try {
            this.socketsPool.close();
        }
        catch (Exception e) {
            this.logger.warn((Object)("Failed to close dispatcher socket pool: " + e.getMessage()));
        }
        this.keepAliveMonitor.dispose();
    }

    protected Socket getSocket(ImmutableEndpoint endpoint) throws Exception {
        TcpSocketKey socketKey = new TcpSocketKey(endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("borrowing socket for " + socketKey + "/" + socketKey.hashCode()));
            if (null != this.lastSocketKey) {
                this.logger.debug((Object)("same as " + this.lastSocketKey.hashCode() + "? " + this.lastSocketKey.equals(socketKey)));
            }
        }
        Socket socket = (Socket)this.socketsPool.borrowObject((Object)socketKey);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("borrowed socket, " + (socket.isClosed() ? "closed" : "open") + "; debt " + this.socketsPool.getNumActive()));
        }
        return socket;
    }

    void releaseSocket(Socket socket, ImmutableEndpoint endpoint) throws Exception {
        TcpSocketKey socketKey;
        this.lastSocketKey = socketKey = new TcpSocketKey(endpoint);
        this.socketsPool.returnObject((Object)socketKey, (Object)socket);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("returning socket for " + socketKey.hashCode()));
            this.logger.debug((Object)("returned socket; debt " + this.socketsPool.getNumActive()));
        }
    }

    public OutputStream getOutputStream(final ImmutableEndpoint endpoint, MuleMessage message) throws MuleException {
        Socket socket;
        try {
            socket = this.getSocket(endpoint);
        }
        catch (Exception e) {
            throw new MessagingException(CoreMessages.failedToGetOutputStream(), message, (Throwable)e);
        }
        if (socket == null) {
            throw new IllegalStateException("could not get socket for endpoint: " + endpoint.getEndpointURI().getAddress());
        }
        try {
            return new CallbackOutputStream(new DataOutputStream(new BufferedOutputStream(socket.getOutputStream())), new CallbackOutputStream.Callback(){

                public void onClose() throws Exception {
                    TcpConnector.this.releaseSocket(socket, endpoint);
                }
            });
        }
        catch (IOException e) {
            throw new MessagingException(CoreMessages.failedToGetOutputStream(), message, (Throwable)e);
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
        this.socketsPool.clear();
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public String getProtocol() {
        return TCP;
    }

    public boolean isKeepSendSocketOpen() {
        return this.keepSendSocketOpen;
    }

    public void setKeepSendSocketOpen(boolean keepSendSocketOpen) {
        this.keepSendSocketOpen = keepSendSocketOpen;
    }

    @Deprecated
    public void setTimeout(int timeout) {
        this.setClientSoTimeout(timeout);
        this.setServerSoTimeout(timeout);
    }

    public int getClientSoTimeout() {
        return this.clientSoTimeout;
    }

    public void setClientSoTimeout(int timeout) {
        this.clientSoTimeout = TcpConnector.valueOrDefault(timeout, 0, -1);
    }

    public int getServerSoTimeout() {
        return this.serverSoTimeout;
    }

    public void setServerSoTimeout(int timeout) {
        this.serverSoTimeout = TcpConnector.valueOrDefault(timeout, 0, -1);
    }

    @Deprecated
    public int getBufferSize() {
        return this.sendBufferSize;
    }

    @Deprecated
    public void setBufferSize(int bufferSize) {
        this.sendBufferSize = TcpConnector.valueOrDefault(bufferSize, 1, -1);
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int bufferSize) {
        this.sendBufferSize = TcpConnector.valueOrDefault(bufferSize, 1, -1);
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int bufferSize) {
        this.receiveBufferSize = TcpConnector.valueOrDefault(bufferSize, 1, -1);
    }

    public int getReceiveBacklog() {
        return this.receiveBacklog;
    }

    public void setReceiveBacklog(int receiveBacklog) {
        this.receiveBacklog = TcpConnector.valueOrDefault(receiveBacklog, 0, -1);
    }

    public int getSocketSoLinger() {
        return this.socketSoLinger;
    }

    public void setSocketSoLinger(int soLinger) {
        this.socketSoLinger = TcpConnector.valueOrDefault(soLinger, 0, -1);
    }

    @Deprecated
    public int getBacklog() {
        return this.receiveBacklog;
    }

    @Deprecated
    public void setBacklog(int backlog) {
        this.receiveBacklog = backlog;
    }

    public TcpProtocol getTcpProtocol() {
        return this.tcpProtocol;
    }

    public void setTcpProtocol(TcpProtocol tcpProtocol) {
        this.tcpProtocol = tcpProtocol;
    }

    public boolean isResponseEnabled() {
        return true;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isSendTcpNoDelay() {
        return this.sendTcpNoDelay;
    }

    public void setSendTcpNoDelay(boolean sendTcpNoDelay) {
        this.sendTcpNoDelay = sendTcpNoDelay;
    }

    protected void setSocketFactory(AbstractTcpSocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    protected AbstractTcpSocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public SimpleServerSocketFactory getServerSocketFactory() {
        return this.serverSocketFactory;
    }

    public void setServerSocketFactory(SimpleServerSocketFactory serverSocketFactory) {
        this.serverSocketFactory = serverSocketFactory;
    }

    protected ServerSocket getServerSocket(URI uri) throws IOException {
        return this.getServerSocketFactory().createServerSocket(uri, this.getReceiveBacklog(), this.isReuseAddress());
    }

    private static int valueOrDefault(int value, int threshhold, int deflt) {
        if (value < threshhold) {
            return deflt;
        }
        return value;
    }

    public Boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(Boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public ExpiryMonitor getKeepAliveMonitor() {
        return this.keepAliveMonitor;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public void setDispatcherFactory(MessageDispatcherFactory dispatcherFactory) {
        if (this.dispatcherFactory == null) {
            super.setDispatcherFactory(dispatcherFactory);
        }
    }

    public ConfigurableKeyedObjectPool getDispatchers() {
        return this.dispatchers;
    }
}

