/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el.tree.impl;

import de.odysseus.el.misc.LocalMessages;
import java.util.HashMap;

final class Scanner {
    private static final HashMap<String, Symbol> KEYMAP = new HashMap(16);
    private String image;
    private String value;
    private int position;
    private boolean eval;
    private final String input;
    private final StringBuilder builder = new StringBuilder();

    Scanner(String string) {
        this.input = string;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    /*
     * Enabled aggressive block sorting
     */
    private Symbol nextText() throws ScanException {
        int n;
        this.builder.setLength(0);
        int n2 = this.input.length();
        boolean bl = false;
        block4: for (n = this.position; n < n2; ++n) {
            char c = this.input.charAt(n);
            switch (c) {
                case '\\': {
                    if (bl) {
                        this.builder.append('\\');
                        continue block4;
                    }
                    bl = true;
                    continue block4;
                }
                case '#': 
                case '$': {
                    if (n + 1 < n2 && this.input.charAt(n + 1) == '{') {
                        if (!bl) {
                            this.value = this.builder.toString();
                            this.image = this.input.substring(this.position, n);
                            return Symbol.TEXT;
                        }
                        this.builder.append(c);
                    } else {
                        if (bl) {
                            this.builder.append('\\');
                        }
                        this.builder.append(c);
                    }
                    bl = false;
                    continue block4;
                }
                default: {
                    if (bl) {
                        this.builder.append('\\');
                    }
                    this.builder.append(c);
                    bl = false;
                }
            }
        }
        if (bl) {
            this.builder.append('\\');
        }
        this.value = this.builder.toString();
        this.image = this.input.substring(this.position, n);
        return Symbol.TEXT;
    }

    private Symbol nextString() throws ScanException {
        this.builder.setLength(0);
        char c = this.input.charAt(this.position);
        int n = this.position + 1;
        int n2 = this.input.length();
        while (n < n2) {
            char c2;
            if ((c2 = this.input.charAt(n++)) == '\\') {
                if (n == n2) {
                    throw new ScanException(this.position, "unterminated string", c + " or \\");
                }
                if ((c2 = this.input.charAt(n++)) == '\\' || c2 == c) {
                    this.builder.append(c2);
                    continue;
                }
                throw new ScanException(this.position, "invalid escape sequence \\" + c2, "\\" + c + " or \\\\");
            }
            if (c2 == c) {
                this.value = this.builder.toString();
                this.image = this.input.substring(this.position, n);
                return Symbol.STRING;
            }
            this.builder.append(c2);
        }
        throw new ScanException(this.position, "unterminated string", Character.valueOf(c));
    }

    private Symbol nextNumber() throws ScanException {
        int n;
        int n2 = this.input.length();
        for (n = this.position; n < n2 && this.isDigit(this.input.charAt(n)); ++n) {
        }
        Symbol symbol = Symbol.INTEGER;
        if (n < n2 && this.input.charAt(n) == '.') {
            ++n;
            while (n < n2 && this.isDigit(this.input.charAt(n))) {
                ++n;
            }
            symbol = Symbol.FLOAT;
        }
        if (n < n2 && (this.input.charAt(n) == 'e' || this.input.charAt(n) == 'E')) {
            int n3 = n++;
            if (n < n2 && (this.input.charAt(n) == '+' || this.input.charAt(n) == '-')) {
                ++n;
            }
            if (n < n2 && this.isDigit(this.input.charAt(n))) {
                ++n;
                while (n < n2 && this.isDigit(this.input.charAt(n))) {
                    ++n;
                }
                symbol = Symbol.FLOAT;
            } else {
                n = n3;
            }
        }
        this.image = this.input.substring(this.position, n);
        return symbol;
    }

    private Symbol nextEval() throws ScanException {
        char c = this.input.charAt(this.position);
        int n = this.position + 1;
        switch (c) {
            case '*': {
                this.image = "*";
                return Symbol.MUL;
            }
            case '/': {
                this.image = "/";
                return Symbol.DIV;
            }
            case '%': {
                this.image = "%";
                return Symbol.MOD;
            }
            case '+': {
                this.image = "+";
                return Symbol.PLUS;
            }
            case '-': {
                this.image = "-";
                return Symbol.MINUS;
            }
            case '?': {
                this.image = "?";
                return Symbol.QUESTION;
            }
            case ':': {
                this.image = ":";
                return Symbol.COLON;
            }
            case '[': {
                this.image = "[";
                return Symbol.LBRACK;
            }
            case ']': {
                this.image = "]";
                return Symbol.RBRACK;
            }
            case '(': {
                this.image = "(";
                return Symbol.LPAREN;
            }
            case ')': {
                this.image = ")";
                return Symbol.RPAREN;
            }
            case ',': {
                this.image = ",";
                return Symbol.COMMA;
            }
            case '.': {
                if (n != this.input.length() && this.isDigit(this.input.charAt(n))) break;
                this.image = ".";
                return Symbol.DOT;
            }
            case '=': {
                if (n >= this.input.length() || this.input.charAt(n) != '=') break;
                this.image = "==";
                return Symbol.EQ;
            }
            case '&': {
                if (n >= this.input.length() || this.input.charAt(n) != '&') break;
                this.image = "&&";
                return Symbol.AND;
            }
            case '|': {
                if (n >= this.input.length() || this.input.charAt(n) != '|') break;
                this.image = "||";
                return Symbol.OR;
            }
            case '!': {
                if (n < this.input.length() && this.input.charAt(n) == '=') {
                    this.image = "!=";
                    return Symbol.NE;
                }
                this.image = "!";
                return Symbol.NOT;
            }
            case '<': {
                if (n < this.input.length() && this.input.charAt(n) == '=') {
                    this.image = "<=";
                    return Symbol.LE;
                }
                this.image = "<";
                return Symbol.LT;
            }
            case '>': {
                if (n < this.input.length() && this.input.charAt(n) == '=') {
                    this.image = "<=";
                    return Symbol.GE;
                }
                this.image = ">";
                return Symbol.GT;
            }
            case '\"': 
            case '\'': {
                return this.nextString();
            }
        }
        if (this.isDigit(c) || c == '.') {
            return this.nextNumber();
        }
        if (Character.isJavaIdentifierStart(c)) {
            int n2;
            int n3 = this.input.length();
            for (n2 = n; n2 < n3 && Character.isJavaIdentifierPart(this.input.charAt(n2)); ++n2) {
            }
            this.image = this.input.substring(this.position, n2);
            return KEYMAP.containsKey(this.image) ? KEYMAP.get(this.image) : Symbol.IDENTIFIER;
        }
        throw new ScanException(this.position, "invalid character '" + c + "'", "expression token");
    }

    String getImage() {
        return this.value == null ? this.image : this.value;
    }

    int getPosition() {
        return this.position;
    }

    Symbol next() throws ScanException {
        if (this.image != null) {
            this.position += this.image.length();
            this.image = null;
            this.value = null;
        }
        int n = this.input.length();
        if (this.eval) {
            while (this.position < n && Character.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
        }
        if (this.position == n) {
            return Symbol.EOF;
        }
        if (this.eval) {
            if (this.input.charAt(this.position) == '}') {
                this.image = "}";
                this.eval = false;
                return Symbol.END_EVAL;
            }
            return this.nextEval();
        }
        if (this.position + 1 < n && this.input.charAt(this.position + 1) == '{') {
            switch (this.input.charAt(this.position)) {
                case '#': {
                    this.image = "#{";
                    this.eval = true;
                    return Symbol.START_EVAL_DEFERRED;
                }
                case '$': {
                    this.image = "${";
                    this.eval = true;
                    return Symbol.START_EVAL_DYNAMIC;
                }
            }
        }
        return this.nextText();
    }

    static {
        KEYMAP.put("null", Symbol.NULL);
        KEYMAP.put("true", Symbol.TRUE);
        KEYMAP.put("false", Symbol.FALSE);
        KEYMAP.put("empty", Symbol.EMPTY);
        KEYMAP.put("div", Symbol.DIV);
        KEYMAP.put("mod", Symbol.MOD);
        KEYMAP.put("not", Symbol.NOT);
        KEYMAP.put("and", Symbol.AND);
        KEYMAP.put("or", Symbol.OR);
        KEYMAP.put("le", Symbol.LE);
        KEYMAP.put("lt", Symbol.LT);
        KEYMAP.put("eq", Symbol.EQ);
        KEYMAP.put("ne", Symbol.NE);
        KEYMAP.put("ge", Symbol.GE);
        KEYMAP.put("gt", Symbol.GT);
        KEYMAP.put("instanceof", Symbol.INSTANCEOF);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Symbol {
        EOF,
        PLUS("'+'"),
        MINUS("'-'"),
        MUL("'*'"),
        DIV("'/'|'div'"),
        MOD("'%'|'mod'"),
        LPAREN("'('"),
        RPAREN("')'"),
        IDENTIFIER,
        NOT("'!'|'not'"),
        AND("'&&'|'and'"),
        OR("'||'|'or'"),
        EMPTY("'empty'"),
        INSTANCEOF("'instanceof'"),
        INTEGER,
        FLOAT,
        TRUE("'true'"),
        FALSE("'false'"),
        STRING,
        NULL("'null'"),
        LE("'<='|'le'"),
        LT("'<'|'lt'"),
        GE("'>='|'ge'"),
        GT("'>'|'gt'"),
        EQ("'=='|'eq'"),
        NE("'!='|'ne'"),
        QUESTION("'?'"),
        COLON("':'"),
        TEXT,
        DOT("'.'"),
        LBRACK("'['"),
        RBRACK("']'"),
        COMMA("','"),
        START_EVAL_DEFERRED("'#{'"),
        START_EVAL_DYNAMIC("'${'"),
        END_EVAL("'}'");

        private final String string;

        private Symbol() {
            this(null);
        }

        private Symbol(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string == null ? "<" + this.name() + ">" : this.string;
        }
    }

    static class ScanException
    extends Exception {
        ScanException(int n, String string, Object object) {
            super(LocalMessages.get("error.scan", n, string, object));
        }
    }
}

