/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Array;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayELResolver
extends ELResolver {
    private boolean isReadOnly;

    public ArrayELResolver() {
        this.isReadOnly = false;
    }

    public ArrayELResolver(boolean bl) {
        this.isReadOnly = bl;
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object != null && object.getClass().isArray()) {
            eLContext.setPropertyResolved(true);
            int n = this.toInteger(object2);
            if (n < 0 || n >= Array.getLength(object)) {
                throw new PropertyNotFoundException();
            }
            return object.getClass().getComponentType();
        }
        return null;
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object != null && object.getClass().isArray()) {
            eLContext.setPropertyResolved(true);
            int n = this.toInteger(object2);
            if (n >= 0 && n < Array.getLength(object)) {
                return Array.get(object, n);
            }
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object != null && object.getClass().isArray()) {
            eLContext.setPropertyResolved(true);
            if (this.isReadOnly) {
                throw new PropertyNotWritableException();
            }
            Class<?> clazz = object.getClass().getComponentType();
            if (object3 != null && !clazz.isAssignableFrom(object3.getClass())) {
                throw new ClassCastException();
            }
            int n = this.toInteger(object2);
            if (n < 0 || n >= Array.getLength(object)) {
                throw new PropertyNotFoundException();
            }
            Array.set(object, n, object3);
        }
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        if (eLContext == null) {
            throw new NullPointerException();
        }
        if (object != null && object.getClass().isArray()) {
            eLContext.setPropertyResolved(true);
            int n = this.toInteger(object2);
            if (n < 0 || n >= Array.getLength(object)) {
                throw new PropertyNotFoundException();
            }
        }
        return this.isReadOnly;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object != null && object.getClass().isArray()) {
            return Integer.class;
        }
        return null;
    }

    private int toInteger(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1 : 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new IllegalArgumentException();
    }
}

