/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.packet;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPPacketDataOutputStream;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class PGPLiteralDataPacket
extends PGPPacket {
    private byte[] data;
    private String filename;
    private boolean binary;
    private boolean local;
    private long time;

    public void decodeBody(PGPPacketDataInputStream in, PGPAlgorithmFactory factory) throws IOException, PGPFatalDataFormatException, PGPDataFormatException {
        byte type = in.readByte();
        if (type == 98) {
            this.binary = true;
            this.local = false;
        } else if (type == 116) {
            this.binary = false;
            this.local = false;
        } else if (type == 108) {
            this.binary = true;
            this.local = true;
        } else {
            in.readByteArray();
            throw new PGPDataFormatException("Illegal literal data type");
        }
        this.filename = in.readLengthPrependedString();
        this.time = in.readUnsignedInt();
        this.data = in.readByteArray();
    }

    public void encodeBody(PGPPacketDataOutputStream out) throws IOException {
        if (this.local) {
            out.writeByte((byte)108);
        } else if (this.binary) {
            out.writeByte((byte)98);
        } else {
            out.writeByte((byte)116);
        }
        if (this.filename == null) {
            out.writeLengthPrependedString("");
        } else {
            out.writeLengthPrependedString(this.filename);
        }
        if (this.time == 0L) {
            this.time = new Date().getTime() / 1000L;
        }
        out.writeInt((int)this.time);
        out.writeFully(this.data);
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPLiteralDataPacket)) {
            return false;
        }
        PGPLiteralDataPacket that = (PGPLiteralDataPacket)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getBinaryData(), that.getBinaryData()) && PGPCompare.equals(this.isBinary(), that.isBinary());
    }

    public byte[] getBinaryData() {
        return this.data;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getTextData() {
        try {
            return new String(this.data, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError("UTF-8 encoding not supported - " + uee);
        }
    }

    public long getTime() {
        return this.time;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isLocal() {
        return this.local;
    }

    public boolean isText() {
        return (this.binary || this.local) ^ true;
    }

    public void setData(String data) {
        if (data.length() == 0) {
            throw new IllegalArgumentException("String size == 0");
        }
        try {
            this.data = data.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new InternalError("UTF-8 encoding not supported - " + uee);
        }
        this.binary = false;
    }

    public void setData(byte[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Array size == 0");
        }
        this.data = data;
        this.binary = true;
    }

    public void setFileName(String filename) {
        if (filename.length() > 255) {
            throw new IllegalArgumentException("Filename too long (>255 chars");
        }
        this.filename = filename;
    }

    public void setTime(long time) {
        this.time = time;
    }
}

