/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.PGPCertificateParameterBuilder;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPPrincipal;
import cryptix.openpgp.PGPPrivateKey;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.PGPSignatureParameterSpec;
import cryptix.openpgp.PGPV3SignatureParameterSpec;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.io.PGPHashDataOutputStream;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.packet.PGPUserIDPacket;
import cryptix.openpgp.provider.PGPCertificateImpl;
import cryptix.openpgp.signature.PGPDateSP;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.pki.CertificateBuilderSpi;
import cryptix.pki.KeyBundle;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class PGPCertificateBuilder
extends CertificateBuilderSpi {
    public Certificate engineBuild(PublicKey subjectKey, Principal subjectName, KeyBundle issuer, char[] passphrase, SecureRandom sr) throws CertificateException, UnrecoverableKeyException {
        if (!(issuer instanceof PGPKeyBundle)) {
            throw new CertificateException("Issuer not instance of PGPKeyBundle");
        }
        PublicKey temppubkey = (PublicKey)issuer.getPublicKeys().next();
        PrivateKey tempkey = issuer.getPrivateKey(temppubkey, passphrase);
        if (!(tempkey instanceof PGPPrivateKey)) {
            throw new CertificateException("Issuer does not contain a private key.");
        }
        return this.engineBuild(subjectKey, subjectName, tempkey, sr);
    }

    public Certificate engineBuild(PublicKey subjectKey, Principal subjectName, KeyBundle issuer, char[] passphrase, SecureRandom sr, AlgorithmParameterSpec algSpec) throws CertificateException, InvalidAlgorithmParameterException, UnrecoverableKeyException {
        if (!(issuer instanceof PGPKeyBundle)) {
            throw new CertificateException("Issuer not instance of PGPKeyBundle");
        }
        PublicKey temppubkey = (PublicKey)issuer.getPublicKeys().next();
        PrivateKey tempkey = issuer.getPrivateKey(temppubkey, passphrase);
        if (!(tempkey instanceof PGPPrivateKey)) {
            throw new CertificateException("Issuer does not contain a private key.");
        }
        return this.engineBuild(subjectKey, subjectName, tempkey, sr, algSpec);
    }

    public Certificate engineBuild(PublicKey subjectKey, Principal subjectName, PrivateKey issuer, SecureRandom sr) throws CertificateException {
        try {
            return this.engineBuild(subjectKey, subjectName, issuer, sr, this.getDefaultParameterSpec(issuer));
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new CertificateException("Invalid default parameters. " + iape);
        }
        catch (InvalidKeyException ike) {
            throw new CertificateException("Invalid issuer key type. " + ike);
        }
    }

    public Certificate engineBuild(PublicKey subjectKey, Principal subjectName, PrivateKey issuer, SecureRandom sr, AlgorithmParameterSpec algSpec) throws CertificateException, InvalidAlgorithmParameterException {
        byte[] useridbytes;
        MessageDigest md;
        int hashid;
        AlgorithmParameterSpec sigSpec;
        if (!(subjectKey instanceof PGPPublicKey)) {
            throw new CertificateException("Subject key not instance of PGPPublicKey");
        }
        if (!(subjectName instanceof PGPPrincipal)) {
            throw new CertificateException("Subject name not instance of PGPPrincipal");
        }
        if (!(issuer instanceof PGPPrivateKey)) {
            throw new CertificateException("Issuer not instance of PGPPrivateKey");
        }
        PGPPrivateKey signkey = (PGPPrivateKey)issuer;
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        byte algoid = signkey.getPacket().getAlgorithmID();
        PGPSignaturePacket pkt = new PGPSignaturePacket();
        if (algSpec instanceof PGPSignatureParameterSpec) {
            sigSpec = (PGPSignatureParameterSpec)algSpec;
            hashid = 2;
            Vector hashed = ((PGPSignatureParameterSpec)sigSpec).getHashed();
            Vector<PGPSignatureSubPacket> newhashed = new Vector<PGPSignatureSubPacket>();
            Vector unhashed = ((PGPSignatureParameterSpec)sigSpec).getUnhashed();
            byte sigtype = ((PGPSignatureParameterSpec)sigSpec).getSigType();
            Enumeration enumeration = hashed.elements();
            while (enumeration.hasMoreElements()) {
                PGPSignatureSubPacket ssp = (PGPSignatureSubPacket)enumeration.nextElement();
                if (ssp.getPacketID() == 9) {
                    Date expire = ((PGPDateSP)ssp).getValue();
                    Date create = ((PGPPublicKey)subjectKey).getPacket().getCreationDate();
                    long delta = expire.getTime() - create.getTime();
                    if (delta < 0L) {
                        throw new InvalidAlgorithmParameterException("Key expires before it is created");
                    }
                    PGPDateSP newssp = new PGPDateSP();
                    newssp.setPacketID(ssp.getPacketID());
                    newssp.setCritical(ssp.getCritical());
                    newssp.setValue(new Date(delta));
                    newhashed.add(newssp);
                    continue;
                }
                newhashed.add(ssp);
            }
            pkt.setData(sigtype, algoid, (byte)hashid, newhashed, unhashed);
            pkt.setPacketID((byte)2);
        } else if (algSpec instanceof PGPV3SignatureParameterSpec) {
            hashid = 1;
            sigSpec = (PGPV3SignatureParameterSpec)algSpec;
            byte sigtype = ((PGPV3SignatureParameterSpec)sigSpec).getSigType();
            pkt.setData(sigtype, ((PGPV3SignatureParameterSpec)sigSpec).getTime(), ((PGPV3SignatureParameterSpec)sigSpec).getIssuer(), algoid, (byte)hashid);
            pkt.setPacketID((byte)2);
        } else {
            throw new InvalidAlgorithmParameterException("Expected PGPSignatureParameterSpec or PGPV3SignatureParameterSpec, got " + algSpec.getClass().toString());
        }
        PGPPublicKey pubkey = (PGPPublicKey)subjectKey;
        PGPPrincipal subject = (PGPPrincipal)subjectName;
        PGPPublicKeyPacket keypkt = (PGPPublicKeyPacket)pubkey.getPacket();
        PGPUserIDPacket idpkt = (PGPUserIDPacket)subject.getPacket();
        PGPSigner signer = (PGPSigner)signkey.getPacket().getAlgorithm();
        try {
            md = factory.getHashAlgorithm(hashid);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CertificateException(String.valueOf(String.valueOf(nsae)));
        }
        signer.initSign(hashid, factory);
        PGPHashDataOutputStream hdos = new PGPHashDataOutputStream(md, signer);
        try {
            keypkt.encodeBody(hdos);
            hdos.close();
        }
        catch (IOException ioe) {
            throw new InternalError("IOException on hashing key - " + ioe);
        }
        try {
            useridbytes = idpkt.getValue().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("UTF-8 encoding not supported.");
        }
        if (pkt.getVersion() == 4) {
            byte[] pre = new byte[]{-76, (byte)(useridbytes.length >> 24 & 0xFF), (byte)(useridbytes.length >> 16 & 0xFF), (byte)(useridbytes.length >> 8 & 0xFF), (byte)(useridbytes.length & 0xFF)};
            md.update(pre);
            signer.update(pre);
        }
        md.update(useridbytes);
        signer.update(useridbytes);
        int bytesWritten = pkt.hashData(md, signer);
        if (pkt.getVersion() == 4) {
            byte[] trailer = new byte[]{pkt.getVersion(), -1, (byte)(bytesWritten >> 24 & 0xFF), (byte)(bytesWritten >> 16 & 0xFF), (byte)(bytesWritten >> 8 & 0xFF), (byte)(bytesWritten & 0xFF)};
            md.update(trailer);
            signer.update(trailer);
        }
        byte[] digestcalc = md.digest();
        pkt.setHash(digestcalc);
        signer.computeSignature();
        pkt.setSignature(signer);
        return new PGPCertificateImpl(pkt, subject, pubkey);
    }

    protected AlgorithmParameterSpec getDefaultParameterSpec(PrivateKey issuer) throws InvalidKeyException {
        return new PGPCertificateParameterBuilder(issuer).build();
    }
}

