/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.stream.DecodedMessageInputStreamSpi;
import cryptix.message.stream.DecryptionKeyCallback;
import cryptix.message.stream.DecryptionKeyRequest;
import cryptix.message.stream.DecryptionKeyReturnValue;
import cryptix.message.stream.MessageStreamException;
import cryptix.message.stream.VerificationKeyCallback;
import cryptix.message.stream.VerificationKeyRequest;
import cryptix.message.stream.VerificationKeyReturnValue;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPDecryptionFailedException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.PGPKey;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPPrivateKey;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPCompressor;
import cryptix.openpgp.algorithm.PGPEncryptor;
import cryptix.openpgp.algorithm.PGPSigner;
import cryptix.openpgp.io.PGPInputStreamAdapter;
import cryptix.openpgp.io.PGPPacketDataInputStream;
import cryptix.openpgp.io.PGPZLibInputStreamAdapter;
import cryptix.openpgp.packet.PGPCompressedDataPacket;
import cryptix.openpgp.packet.PGPEncryptedDataPacket;
import cryptix.openpgp.packet.PGPLiteralDataPacket;
import cryptix.openpgp.packet.PGPMarkerPacket;
import cryptix.openpgp.packet.PGPOnePassSignaturePacket;
import cryptix.openpgp.packet.PGPPacket;
import cryptix.openpgp.packet.PGPPacketFactory;
import cryptix.openpgp.packet.PGPPublicKeyEncryptedSessionKeyPacket;
import cryptix.openpgp.packet.PGPSessionKey;
import cryptix.openpgp.packet.PGPSessionKeyPacket;
import cryptix.openpgp.packet.PGPSignaturePacket;
import cryptix.openpgp.packet.PGPSymmetricallyEncryptedIntegrityProtectedDataPacket;
import cryptix.openpgp.provider.PGPKeyIDImpl;
import cryptix.openpgp.signature.PGPKeyIDSP;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyID;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PGPDecodedMessageInputStream
implements DecodedMessageInputStreamSpi {
    private InputStream in = null;
    private InputStream encin = null;
    private MessageDigest mdc = null;
    private int verificationResult = 0;
    private int integrityResult = 0;

    public void engineClose() throws IOException {
        if (this.in == null) {
            throw new IllegalStateException("Not initialized");
        }
        byte[] b = new byte[1];
        if (this.in.read(b) > 0) {
            throw new MessageStreamException("Data left on closing");
        }
        this.verificationResult = this.in instanceof SignedLiteralInputStream ? ((SignedLiteralInputStream)this.in).verify() : 1;
        if (this.mdc == null) {
            this.integrityResult = 1;
        } else {
            b = new byte[2];
            if (this.encin.read(b) != 2 || b[0] != -45 || b[1] != 20) {
                this.integrityResult = 3;
            } else {
                byte[] hashcalc = this.mdc.digest();
                b = new byte[20];
                if (this.encin.read(b) != 20) {
                    this.integrityResult = 3;
                } else {
                    boolean result = true;
                    int i = 0;
                    while (i < 20) {
                        if (b[i] != hashcalc[i]) {
                            result = false;
                        }
                        ++i;
                    }
                    this.integrityResult = result ? 2 : 3;
                }
            }
        }
        this.in.close();
    }

    public int engineGetIntegrityResult() throws IllegalStateException {
        if (this.in == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.integrityResult == 0) {
            throw new IllegalStateException("Not yet closed");
        }
        return this.integrityResult;
    }

    public int engineGetVerificationResult() throws IllegalStateException {
        if (this.in == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (this.verificationResult == 0) {
            throw new IllegalStateException("Not yet closed");
        }
        return this.verificationResult;
    }

    public void engineInit(InputStream in, DecryptionKeyCallback dkc, VerificationKeyCallback vkc) throws IllegalStateException, IOException, MessageStreamException {
        PGPPacket pkt;
        PGPPacketFactory pf = PGPPacketFactory.getDefaultInstance();
        PGPAlgorithmFactory af = PGPAlgorithmFactory.getDefaultInstance();
        Vector<PGPPacket> sessionkeys = new Vector<PGPPacket>();
        MessageDigest md = null;
        boolean hasmdc = false;
        PGPSigner signer = null;
        PGPSignaturePacket sigpkt = null;
        while (true) {
            class Cryptix_openpgp_provider_PGPDecodedMessageInputStream$1 {
                /* synthetic */ Cryptix_openpgp_provider_PGPDecodedMessageInputStream$1() {
                }
            }
            KeyID[] ids;
            byte[] keyid;
            byte hashid;
            PGPPacketDataInputStream pin;
            int len;
            boolean old;
            int id;
            int type;
            try {
                type = in.read();
            }
            catch (IOException ioe) {
                throw new IOException("Error reading packet type: " + ioe.toString());
            }
            if (type == -1) {
                throw new MessageStreamException("End of stream reached before data.");
            }
            if (type < 128) {
                throw new MessageStreamException("Invalid packet type.");
            }
            if (type >= 192) {
                id = type & 0x3F;
                old = false;
                len = -1;
            } else {
                id = type >> 2 & 0xF;
                old = true;
                len = type & 3;
            }
            pkt = pf.getPacket(id);
            if (pkt instanceof PGPLiteralDataPacket) {
                try {
                    this.in = signer == null && md == null && this.mdc == null ? new LiteralInputStream(null, in, old, len) : new SignedLiteralInputStream(null, in, old, len, signer, md, sigpkt);
                }
                catch (PGPDataFormatException pdfe) {
                    throw new MessageStreamException(String.valueOf(String.valueOf(pdfe)));
                }
                catch (PGPFatalDataFormatException pdfe) {
                    throw new MessageStreamException(String.valueOf(String.valueOf(pdfe)));
                }
                return;
            }
            if (pkt instanceof PGPCompressedDataPacket) {
                pin = new PGPPacketDataInputStream(in, old, len);
                try {
                    short alg = pin.readUnsignedByte();
                    PGPCompressor cp = af.getCompressionAlgorithm(alg);
                    if (cp.needsDummy()) {
                        in = cp.getExpansionStream(new PGPZLibInputStreamAdapter(pin));
                    }
                    in = cp.getExpansionStream(new PGPInputStreamAdapter(pin));
                }
                catch (PGPDataFormatException pdfe) {
                    pdfe.printStackTrace();
                    throw new MessageStreamException("Error reading message compression type " + pdfe);
                }
                catch (PGPFatalDataFormatException pdfe) {
                    throw new MessageStreamException("Error reading message compression type " + pdfe);
                }
                catch (NoSuchAlgorithmException nsae) {
                    throw new MessageStreamException("compression id not found - " + nsae);
                }
            }
            if (pkt instanceof PGPEncryptedDataPacket) {
                Cipher cp;
                if (pkt instanceof PGPSymmetricallyEncryptedIntegrityProtectedDataPacket) {
                    hasmdc = true;
                    try {
                        this.mdc = MessageDigest.getInstance("SHA-1");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new RuntimeException("Could not find SHA-1");
                    }
                }
                int count = 0;
                int i = 0;
                while (i < sessionkeys.size()) {
                    PGPSessionKeyPacket skp = (PGPSessionKeyPacket)sessionkeys.elementAt(i);
                    if (skp instanceof PGPPublicKeyEncryptedSessionKeyPacket) {
                        ++count;
                    }
                    ++i;
                }
                KeyID[] hints = new KeyID[count * 2];
                int i2 = 0;
                while (i2 < sessionkeys.size()) {
                    PGPSessionKeyPacket skp = (PGPSessionKeyPacket)sessionkeys.elementAt(i2);
                    if (skp instanceof PGPPublicKeyEncryptedSessionKeyPacket) {
                        hints[i2 * 2] = new PGPKeyIDImpl(null, ((PGPPublicKeyEncryptedSessionKeyPacket)skp).getKeyID(), 3);
                        hints[i2 * 2 + 1] = new PGPKeyIDImpl(null, ((PGPPublicKeyEncryptedSessionKeyPacket)skp).getKeyID(), 4);
                    }
                    ++i2;
                }
                DecryptionKeyReturnValue last = null;
                int retryCount = 0;
                PGPSessionKey decryptkey = null;
                while (decryptkey == null) {
                    DecryptionKeyReturnValue val = dkc.getDecryptionKey(new DecryptionKeyRequest(hints, retryCount, last));
                    if (val.getError() == 1) {
                        throw new MessageStreamException("Failed retrieving decryption key");
                    }
                    if (val.getBundle() != null) {
                        PGPKeyBundle pgpbundle = (PGPKeyBundle)val.getBundle();
                        Iterator it = pgpbundle.getPublicSubKeys();
                        while (it.hasNext()) {
                            PGPPublicKey pubsubkey = (PGPPublicKey)it.next();
                            try {
                                PGPPrivateKey privsubkey = (PGPPrivateKey)pgpbundle.getPrivateSubKey(pubsubkey, val.getPassphrase());
                                PGPEncryptor cryptor = (PGPEncryptor)privsubkey.getPacket().getAlgorithm();
                                int i3 = 0;
                                while (i3 < sessionkeys.size()) {
                                    if (sessionkeys.elementAt(i3) instanceof PGPPublicKeyEncryptedSessionKeyPacket) {
                                        PGPPublicKeyEncryptedSessionKeyPacket pkeskp = (PGPPublicKeyEncryptedSessionKeyPacket)sessionkeys.elementAt(i3);
                                        boolean success = false;
                                        pkeskp.decrypt(cryptor);
                                        success = true;
                                        if (success) {
                                            decryptkey = pkeskp.getSessionKey();
                                        }
                                    }
                                    ++i3;
                                }
                            }
                            catch (UnrecoverableKeyException unrecoverableKeyException) {
                            }
                            catch (PGPDataFormatException pGPDataFormatException) {
                            }
                            catch (PGPDecryptionFailedException pGPDecryptionFailedException) {}
                        }
                        continue;
                    }
                    if (val.getPrivateKey() != null) {
                        PGPEncryptor cryptor = (PGPEncryptor)((PGPKey)((Object)val.getPrivateKey())).getPacket().getAlgorithm();
                        int i4 = 0;
                        while (i4 < sessionkeys.size()) {
                            if (sessionkeys.elementAt(i4) instanceof PGPPublicKeyEncryptedSessionKeyPacket) {
                                PGPPublicKeyEncryptedSessionKeyPacket pkeskp = (PGPPublicKeyEncryptedSessionKeyPacket)sessionkeys.elementAt(i4);
                                boolean success = false;
                                try {
                                    pkeskp.decrypt(cryptor);
                                    success = true;
                                }
                                catch (PGPDataFormatException pGPDataFormatException) {
                                }
                                catch (PGPDecryptionFailedException pGPDecryptionFailedException) {}
                                if (success) {
                                    decryptkey = pkeskp.getSessionKey();
                                }
                            }
                            ++i4;
                        }
                        continue;
                    }
                    throw new MessageStreamException("Invalid decryption key callback result");
                }
                byte[] key = decryptkey.getBytes();
                boolean failed = false;
                byte cpid = decryptkey.getCipherID();
                int blocksize = 0;
                int keysize = 0;
                try {
                    blocksize = af.getCipherBlockSize(cpid);
                    keysize = af.getCipherKeySize(cpid);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    failed = true;
                }
                byte[] iv = new byte[blocksize];
                int j = 0;
                while (j < iv.length) {
                    iv[j] = 0;
                    ++j;
                }
                IvParameterSpec ivspec = new IvParameterSpec(iv);
                try {
                    cp = hasmdc ? af.getCipherAlgorithm(cpid, "CFB") : af.getCipherAlgorithm(cpid, "OpenpgpCFB");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("Inconsistency in factory: factory.getCipherBlockSize(id) and .getCipherKeySize(id) succeeded, but factory.getCipherAlgorithm(id) did not.");
                }
                StringTokenizer st = new StringTokenizer(cp.getAlgorithm(), "/");
                SecretKeySpec keyspec = new SecretKeySpec(key, st.nextToken());
                try {
                    cp.init(2, (Key)keyspec, ivspec);
                }
                catch (InvalidKeyException ike) {
                    ike.printStackTrace();
                    throw new InternalError("InvalidKeyException on decrypting a key - " + ike);
                }
                catch (InvalidAlgorithmParameterException iape) {
                    iape.printStackTrace();
                    throw new InternalError("InvalidAlgorithmParameterException on decrypting a key - " + iape);
                }
                this.encin = in = new EncryptedInputStream(null, in, old, len, cp, blocksize, this.mdc);
                byte[] prefix = new byte[blocksize + 2];
                if (in.read(prefix) == prefix.length) continue;
                throw new MessageStreamException("Could not read prefix");
            }
            pin = new PGPPacketDataInputStream(in, old, len);
            try {
                pkt.decodeBody(pin, af);
            }
            catch (PGPDataFormatException pdfe) {
                throw new MessageStreamException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new MessageStreamException(String.valueOf(String.valueOf(pdfe)));
            }
            if (pkt instanceof PGPSessionKeyPacket) {
                sessionkeys.add(pkt);
                continue;
            }
            if (pkt instanceof PGPMarkerPacket) continue;
            if (!(pkt instanceof PGPOnePassSignaturePacket) && !(pkt instanceof PGPSignaturePacket)) break;
            if (pkt instanceof PGPOnePassSignaturePacket) {
                PGPOnePassSignaturePacket opsp = (PGPOnePassSignaturePacket)pkt;
                hashid = opsp.getHashID();
                keyid = opsp.getKeyID();
            } else {
                sigpkt = (PGPSignaturePacket)pkt;
                hashid = sigpkt.getHashID();
                if (sigpkt.getVersion() <= 3) {
                    keyid = sigpkt.getKeyID();
                } else {
                    PGPKeyIDSP idsp;
                    Object o;
                    keyid = null;
                    Vector subpkts = sigpkt.getUnhashedSubPackets();
                    Iterator it = ((AbstractList)subpkts).iterator();
                    while (it.hasNext()) {
                        o = it.next();
                        if (!(o instanceof PGPKeyIDSP) || (idsp = (PGPKeyIDSP)o).getPacketID() != 16) continue;
                        keyid = idsp.getValue();
                    }
                    subpkts = sigpkt.getHashedSubPackets();
                    it = ((AbstractList)subpkts).iterator();
                    while (it.hasNext()) {
                        o = it.next();
                        if (!(o instanceof PGPKeyIDSP) || (idsp = (PGPKeyIDSP)o).getPacketID() != 16) continue;
                        keyid = idsp.getValue();
                    }
                }
            }
            try {
                md = af.getHashAlgorithm(hashid);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new MessageStreamException(String.valueOf(String.valueOf(nsae)));
            }
            if (keyid == null) {
                ids = new KeyID[]{};
            } else {
                PGPKeyIDImpl id3 = new PGPKeyIDImpl(null, keyid, 3);
                PGPKeyIDImpl id4 = new PGPKeyIDImpl(null, keyid, 4);
                ids = new KeyID[]{id4, id3};
            }
            VerificationKeyReturnValue val = vkc.getVerificationKey(new VerificationKeyRequest(ids, 0, null));
            if (val.getError() == 1) {
                throw new MessageStreamException("Failed retrieving verification key");
            }
            if (val.getError() == 2) {
                throw new RuntimeException("NYI");
            }
            KeyBundle bundle = val.getBundle();
            PGPKey key = bundle == null ? (PGPKey)((Object)val.getPublicKey()) : (PGPKey)bundle.getPublicKeys().next();
            signer = (PGPSigner)key.getPacket().getAlgorithm();
            signer.initVerify(hashid, af);
        }
        throw new MessageStreamException("Invalid streaming message found. Found unexpected " + pkt.getClass());
    }

    public int engineRead() throws IOException {
        if (this.in == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.in.read();
    }

    public int engineRead(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this.in.read(b, off, len);
    }

    private class LiteralInputStream
    extends InputStream {
        private PGPPacketDataInputStream in;

        /* synthetic */ LiteralInputStream(1 $0, InputStream $1, boolean $2, int $3) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
            this($1, $2, $3);
        }

        private LiteralInputStream(InputStream in, boolean old, int lentype) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
            this.in = new PGPPacketDataInputStream(in, old, lentype);
            byte type = this.in.readByte();
            String filename = this.in.readLengthPrependedString();
            long time = this.in.readUnsignedInt();
        }

        public void close() throws IOException {
            try {
                this.in.close();
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }

        public int read() throws IOException {
            try {
                return this.in.readByte();
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                return this.in.readBuffer(b);
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                return this.in.readBuffer(b, off, len);
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }
    }

    private class SignedLiteralInputStream
    extends InputStream {
        private PGPPacketDataInputStream in;
        private InputStream under;
        private PGPSigner signer;
        private MessageDigest md;
        private PGPSignaturePacket pkt;

        /* synthetic */ SignedLiteralInputStream(1 $0, InputStream $1, boolean $2, int $3, PGPSigner $4, MessageDigest $5, PGPSignaturePacket $6) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
            this($1, $2, $3, $4, $5, $6);
        }

        private SignedLiteralInputStream(InputStream in, boolean old, int lentype, PGPSigner signer, MessageDigest md, PGPSignaturePacket pkt) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
            this.in = new PGPPacketDataInputStream(in, old, lentype);
            this.under = in;
            this.signer = signer;
            this.md = md;
            this.pkt = pkt;
            byte type = this.in.readByte();
            String filename = this.in.readLengthPrependedString();
            long time = this.in.readUnsignedInt();
        }

        public void close() throws IOException {
            try {
                this.in.close();
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }

        public int read() throws IOException {
            try {
                byte value = this.in.readByte();
                byte[] data = new byte[]{value};
                if (this.signer != null) {
                    this.signer.update(data);
                }
                if (this.md != null) {
                    this.md.update(data);
                }
                return value;
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }

        public int read(byte[] b) throws IOException {
            try {
                int retlen = this.in.readBuffer(b);
                if (this.signer != null) {
                    this.signer.update(b, 0, retlen);
                }
                if (this.md != null) {
                    this.md.update(b, 0, retlen);
                }
                return retlen;
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                int retlen = this.in.readBuffer(b, off, len);
                if (this.signer != null) {
                    this.signer.update(b, off, retlen);
                }
                if (this.md != null) {
                    this.md.update(b, off, retlen);
                }
                return retlen;
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }

        public int verify() throws IOException {
            byte[] digestinsig;
            byte[] digestcalc;
            boolean ok;
            PGPAlgorithmFactory af = PGPAlgorithmFactory.getDefaultInstance();
            PGPPacketFactory pf = PGPPacketFactory.getDefaultInstance();
            int result = 1;
            if (this.pkt == null) {
                int len;
                boolean old;
                int id;
                int type = this.under.read();
                if (type == -1) {
                    throw new MessageStreamException("End of stream reached, expecting signature.");
                }
                if (type < 128) {
                    throw new MessageStreamException("Invalid packet type.");
                }
                if (type >= 192) {
                    id = type & 0x3F;
                    old = false;
                    len = -1;
                } else {
                    id = type >> 2 & 0xF;
                    old = true;
                    len = type & 3;
                }
                PGPPacket p = pf.getPacket(id);
                if (!(p instanceof PGPSignaturePacket)) {
                    throw new MessageStreamException("Expecting signature, got " + p);
                }
                this.pkt = (PGPSignaturePacket)p;
                PGPPacketDataInputStream pin = new PGPPacketDataInputStream(this.under, old, len);
                try {
                    this.pkt.decodeBody(pin, af);
                }
                catch (PGPDataFormatException pdfe) {
                    throw new MessageStreamException(String.valueOf(String.valueOf(pdfe)));
                }
                catch (PGPFatalDataFormatException pdfe) {
                    pdfe.printStackTrace();
                    throw new MessageStreamException(String.valueOf(String.valueOf(pdfe)));
                }
            }
            int bytesWritten = this.pkt.hashData(this.md, this.signer);
            if (this.pkt.getVersion() == 4) {
                byte[] trailer = new byte[]{this.pkt.getVersion(), -1, (byte)(bytesWritten >> 24 & 0xFF), (byte)(bytesWritten >> 16 & 0xFF), (byte)(bytesWritten >> 8 & 0xFF), (byte)(bytesWritten & 0xFF)};
                this.md.update(trailer);
                this.signer.update(trailer);
            }
            boolean bl = ok = (digestcalc = this.md.digest())[0] == (digestinsig = this.pkt.getHash())[0] && digestcalc[1] == digestinsig[1];
            if (!ok) {
                result = 3;
            } else {
                try {
                    this.pkt.interpretSignature(this.signer);
                }
                catch (PGPDataFormatException pGPDataFormatException) {
                    throw new MessageStreamException("Invalid signature");
                }
                result = this.signer.verifySignature() ? 2 : 3;
            }
            return result;
        }
    }

    private class EncryptedInputStream
    extends InputStream {
        private PGPPacketDataInputStream in;
        private Cipher cipher;
        private byte[] buf;
        private int bufoffset;
        private int blocksize;
        private int tot;
        private MessageDigest mdc;
        private boolean finalcall = false;

        /* synthetic */ EncryptedInputStream(1 $0, InputStream $1, boolean $2, int $3, Cipher $4, int $5, MessageDigest $6) throws IOException {
            this($1, $2, $3, $4, $5, $6);
        }

        private EncryptedInputStream(InputStream in, boolean old, int lentype, Cipher cipher, int blocksize, MessageDigest mdc) throws IOException {
            this.in = new PGPPacketDataInputStream(in, old, lentype);
            this.cipher = cipher;
            this.buf = new byte[blocksize * 2];
            this.bufoffset = this.buf.length;
            this.blocksize = blocksize;
            this.mdc = mdc;
            try {
                if (mdc != null && this.in.readByte() != 1) {
                    throw new MessageStreamException("Invalid MDC version");
                }
            }
            catch (PGPDataFormatException pdfe) {
                throw new MessageStreamException("Cannot read MDC version: " + pdfe);
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new MessageStreamException("Cannot read MDC version: " + pdfe);
            }
        }

        public int available() {
            int result = 0;
            if (this.in.isFinal()) {
                result = this.mdc == null ? (int)this.in.available() + this.buf.length - this.bufoffset + this.blocksize : (int)this.in.available() + this.buf.length - this.bufoffset + this.blocksize - 22;
                if (this.finalcall) {
                    result = 0;
                }
                this.finalcall = true;
            } else {
                result = (int)this.in.available() + this.buf.length - this.bufoffset;
            }
            return result;
        }

        public void close() throws IOException {
            try {
                this.in.close();
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }

        public int read() throws IOException {
            if (this.bufoffset == this.buf.length) {
                byte[] b = new byte[1];
                if (this.read(b) == 0) {
                    return -1;
                }
                return b[0] & 0xFF;
            }
            if (this.mdc != null) {
                this.mdc.update(this.buf, this.bufoffset, 1);
            }
            return this.buf[this.bufoffset++] & 0xFF;
        }

        public int read(byte[] b) throws IOException {
            int result = this.read(b, 0, b.length);
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            try {
                byte[] data;
                byte[] temp;
                if (this.buf.length - this.bufoffset >= len) {
                    System.arraycopy(this.buf, this.bufoffset, b, 0, len);
                    if (this.mdc != null) {
                        this.mdc.update(b, 0, len);
                    }
                    this.bufoffset += len;
                    return len;
                }
                if (this.in.available() > 32L) {
                    temp = new byte[(int)this.in.available() & 0xFFFFFFE0];
                    if (temp.length < len + this.blocksize * 2 + 2) {
                        temp = new byte[len + this.blocksize * 2 + 2];
                    }
                } else {
                    temp = new byte[len + this.blocksize * 2 + 2];
                }
                if (this.in.available() == 0L && this.buf.length - this.bufoffset == 0) {
                    return 0;
                }
                int size = this.in.readBuffer(temp);
                if (size < temp.length) {
                    try {
                        data = this.cipher.doFinal(temp, 0, size);
                    }
                    catch (IllegalBlockSizeException ibse) {
                        throw new IOException(String.valueOf(String.valueOf(ibse)));
                    }
                    catch (BadPaddingException bpe) {
                        throw new IOException(String.valueOf(String.valueOf(bpe)));
                    }
                } else {
                    data = this.cipher.update(temp, 0, size);
                }
                size = 0;
                if (this.bufoffset < this.buf.length) {
                    System.arraycopy(this.buf, this.bufoffset, b, off, this.buf.length - this.bufoffset);
                    size += this.buf.length - this.bufoffset;
                }
                if (size + data.length > len) {
                    System.arraycopy(data, 0, b, off + size, len - size);
                    int newbuflen = data.length - (len - size);
                    this.buf = new byte[newbuflen];
                    System.arraycopy(data, len - size, this.buf, 0, newbuflen);
                    this.bufoffset = 0;
                    if (this.mdc != null) {
                        this.mdc.update(b, 0, len);
                    }
                    return len;
                }
                System.arraycopy(data, 0, b, off + size, data.length);
                this.bufoffset = this.buf.length;
                if (this.mdc != null) {
                    this.mdc.update(b, 0, size + data.length);
                }
                return size + data.length;
            }
            catch (PGPDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pdfe) {
                throw new IOException(String.valueOf(String.valueOf(pdfe)));
            }
        }
    }
}

