/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.message.EncryptedMessageBuilderSpi;
import cryptix.message.Message;
import cryptix.message.MessageException;
import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.PGPKey;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPEncryptor;
import cryptix.openpgp.packet.PGPCompressedDataPacket;
import cryptix.openpgp.packet.PGPContainerPacket;
import cryptix.openpgp.packet.PGPKeyPacket;
import cryptix.openpgp.packet.PGPPacketFactory;
import cryptix.openpgp.packet.PGPPublicKeyEncryptedSessionKeyPacket;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPPublicSubKeyPacket;
import cryptix.openpgp.packet.PGPSessionKeyPacket;
import cryptix.openpgp.packet.PGPSymmetricKeyEncryptedSessionKeyPacket;
import cryptix.openpgp.packet.PGPSymmetricallyEncryptedDataPacket;
import cryptix.openpgp.provider.PGPEncryptedMessageImpl;
import cryptix.openpgp.provider.PGPKeyIDFactory;
import cryptix.openpgp.provider.PGPLiteralMessageImpl;
import cryptix.openpgp.provider.PGPSignedMessageImpl;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyID;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.crypto.SecretKey;

public class PGPEncryptedMessageBuilder
extends EncryptedMessageBuilderSpi {
    private boolean compression = false;
    private Message contents;
    private SecureRandom sr;
    private Vector recipients = new Vector();
    protected boolean v3 = false;

    public void engineAddRecipient(KeyBundle bundle) throws IllegalStateException, UnsupportedOperationException, MessageException {
        this.recipients.add(bundle);
    }

    public void engineAddRecipient(String passphrase) throws IllegalStateException, UnsupportedOperationException, MessageException {
        this.recipients.add(passphrase);
    }

    public void engineAddRecipient(PublicKey publickey) throws IllegalStateException, UnsupportedOperationException, MessageException {
        this.recipients.add(publickey);
    }

    public void engineAddRecipient(SecretKey symmetrickey) throws IllegalStateException, UnsupportedOperationException, MessageException {
        throw new UnsupportedOperationException("Symmetric key encryption not supported.");
    }

    public Message engineBuild() throws IllegalStateException, MessageException {
        int keysize;
        Vector<PGPSessionKeyPacket> skps = new Vector<PGPSessionKeyPacket>();
        byte datacipher = this.v3 ? (byte)1 : 2;
        PGPAlgorithmFactory factory = PGPAlgorithmFactory.getDefaultInstance();
        try {
            keysize = factory.getCipherKeySize(datacipher);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new MessageException(String.valueOf(String.valueOf(nsae)));
        }
        byte[] sessionkey = new byte[keysize];
        this.sr.nextBytes(sessionkey);
        Iterator it = ((AbstractList)this.recipients).iterator();
        while (it.hasNext()) {
            PGPSessionKeyPacket pkt;
            Object rcpt = it.next();
            if (rcpt instanceof KeyBundle) {
                KeyID keyid;
                PGPEncryptor cryptor;
                byte id;
                PGPKeyPacket keypkt;
                Iterator it2 = ((PGPKeyBundle)((Object)rcpt)).getPublicSubKeys();
                PGPKey publickey = null;
                while (it2.hasNext()) {
                    PGPPublicKey temp = (PGPPublicKey)it2.next();
                    publickey = temp;
                }
                if (publickey == null) {
                    it2 = ((PGPKeyBundle)((Object)rcpt)).getPublicKeys();
                    publickey = (PGPPublicKey)it2.next();
                    keypkt = (PGPPublicKeyPacket)publickey.getPacket();
                    id = keypkt.getAlgorithmID();
                    try {
                        cryptor = (PGPEncryptor)keypkt.getAlgorithm();
                    }
                    catch (ClassCastException classCastException) {
                        throw new MessageException("No encryption key found.");
                    }
                } else {
                    keypkt = (PGPPublicSubKeyPacket)publickey.getPacket();
                    id = keypkt.getAlgorithmID();
                    cryptor = (PGPEncryptor)keypkt.getAlgorithm();
                }
                if (publickey == null) {
                    throw new MessageException("No encryption key found.");
                }
                PGPPublicKeyEncryptedSessionKeyPacket pkt2 = new PGPPublicKeyEncryptedSessionKeyPacket();
                pkt2.setSessionKey(sessionkey, datacipher);
                pkt2.encrypt(cryptor, this.sr);
                pkt2.setPacketID((byte)1);
                pkt2.setPublicKeyAlgorithmID(id);
                try {
                    keyid = PGPKeyIDFactory.convert(publickey);
                }
                catch (InvalidKeyException ike) {
                    ike.printStackTrace();
                    throw new MessageException(String.valueOf(String.valueOf(ike)));
                }
                pkt2.setKeyID(keyid.getBytes(8));
                skps.add(pkt2);
                continue;
            }
            if (rcpt instanceof PublicKey) {
                KeyID keyid;
                PGPKeyPacket keypkt = ((PGPPublicKey)rcpt).getPacket();
                PGPEncryptor cryptor = (PGPEncryptor)keypkt.getAlgorithm();
                pkt = new PGPPublicKeyEncryptedSessionKeyPacket();
                ((PGPPublicKeyEncryptedSessionKeyPacket)pkt).setSessionKey(sessionkey, datacipher);
                ((PGPPublicKeyEncryptedSessionKeyPacket)pkt).encrypt(cryptor, this.sr);
                pkt.setPacketID((byte)1);
                ((PGPPublicKeyEncryptedSessionKeyPacket)pkt).setPublicKeyAlgorithmID(keypkt.getAlgorithmID());
                try {
                    keyid = PGPKeyIDFactory.convert((PublicKey)rcpt);
                }
                catch (InvalidKeyException ike) {
                    ike.printStackTrace();
                    throw new MessageException(String.valueOf(String.valueOf(ike)));
                }
                ((PGPPublicKeyEncryptedSessionKeyPacket)pkt).setKeyID(keyid.getBytes(8));
                skps.add(pkt);
                continue;
            }
            if (!(rcpt instanceof String)) continue;
            byte s2kid = 3;
            byte hashid = 2;
            pkt = new PGPSymmetricKeyEncryptedSessionKeyPacket();
            ((PGPSymmetricKeyEncryptedSessionKeyPacket)pkt).setDirect((String)rcpt, factory, this.sr, datacipher, s2kid, hashid);
            pkt.setPacketID((byte)3);
            skps.add(pkt);
        }
        PGPSessionKeyPacket[] skparr = new PGPSessionKeyPacket[skps.size()];
        int i = 0;
        while (i < skparr.length) {
            skparr[i] = (PGPSessionKeyPacket)skps.elementAt(i);
            ++i;
        }
        PGPContainerPacket pkt = new PGPSymmetricallyEncryptedDataPacket();
        pkt.setPacketID((byte)9);
        if (this.compression) {
            pkt = new PGPCompressedDataPacket();
            pkt.setPacketID((byte)8);
            ((PGPCompressedDataPacket)pkt).setAlgorithmID(1);
        }
        byte[] data = this.contents.getEncoded();
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        PGPPacketFactory pktfactory = PGPPacketFactory.getDefaultInstance();
        while (bais.available() > 0) {
            try {
                pkt.appendPacket(pktfactory.readPacket(bais, factory));
            }
            catch (IOException ioe) {
                throw new MessageException(String.valueOf(String.valueOf(ioe)));
            }
            catch (PGPDataFormatException pdfe) {
                throw new MessageException(String.valueOf(String.valueOf(pdfe)));
            }
            catch (PGPFatalDataFormatException pfdfe) {
                throw new MessageException(String.valueOf(String.valueOf(pfdfe)));
            }
        }
        if (this.compression) {
            PGPSymmetricallyEncryptedDataPacket pkt2 = new PGPSymmetricallyEncryptedDataPacket();
            pkt2.appendPacket(pkt);
            pkt2.setPacketID((byte)9);
            pkt = pkt2;
        }
        ((PGPSymmetricallyEncryptedDataPacket)pkt).encrypt(sessionkey, datacipher, factory, this.sr);
        return new PGPEncryptedMessageImpl(skparr, (PGPSymmetricallyEncryptedDataPacket)pkt);
    }

    public void engineInit(Message contents, SecureRandom sr) throws IllegalStateException, MessageException {
        if (!(contents instanceof PGPLiteralMessageImpl) && !(contents instanceof PGPSignedMessageImpl)) {
            throw new MessageException("Can only encrypt OpenPGP literal or signed messages");
        }
        if (this.contents != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.contents = contents;
        this.sr = sr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void engineSetAttribute(String name, Object attr) throws IllegalStateException, IllegalArgumentException, MessageException {
        if (!"compressed".equals(name)) throw new IllegalArgumentException("Illegal attribute.");
        if (!(attr instanceof String)) throw new IllegalArgumentException("Illegal value for attribute 'compressed'. Expected a String containing 'true' or 'false'.");
        if ("false".equals(attr)) {
            this.compression = false;
            return;
        } else {
            if (!"true".equals(attr)) throw new IllegalArgumentException("Illegal value for attribute 'compressed'. Only 'true' and 'false' are valid values.");
            this.compression = true;
        }
    }

    public static class Legacy
    extends PGPEncryptedMessageBuilder {
        public Legacy() {
            this.v3 = true;
        }
    }
}

