/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.PGPLegacyKeyPairGeneratorParameterSpec;
import cryptix.openpgp.PGPPrivateKey;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.algorithm.PGPAlgorithmFactory;
import cryptix.openpgp.algorithm.PGPPublicKeyAlgorithm;
import cryptix.openpgp.packet.PGPKeyPacket;
import cryptix.openpgp.packet.PGPPublicKeyPacket;
import cryptix.openpgp.packet.PGPPublicSubKeyPacket;
import cryptix.openpgp.packet.PGPSecretKeyPacket;
import cryptix.openpgp.packet.PGPSecretSubKeyPacket;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;

public class PGPKeyPairGenerator
extends KeyPairGeneratorSpi {
    protected static final int DEFAULT_KEY_SIZE_DSA = 1024;
    protected static final int DEFAULT_KEY_SIZE_RSA = 2048;
    protected static final int DEFAULT_KEY_SIZE_ELGAMAL = 2048;
    private int keysize;
    private int algid;
    private String algorithm;
    private SecureRandom sr = null;
    private PGPAlgorithmFactory factory = null;
    private boolean subkey;
    private boolean legacy;
    private int expiration;
    private PGPKeyPacket pk;
    private PGPKeyPacket sk;

    protected PGPKeyPairGenerator(int algid, int defaultkeysize, String algorithm, boolean subkey, boolean legacy) {
        this.algid = algid;
        this.keysize = defaultkeysize;
        this.algorithm = algorithm;
        this.subkey = subkey;
        this.legacy = legacy;
        this.expiration = 0;
    }

    public KeyPair generateKeyPair() {
        PGPPublicKeyAlgorithm alg;
        if (this.sr == null) {
            this.sr = new SecureRandom();
        }
        if (this.factory == null) {
            this.factory = PGPAlgorithmFactory.getDefaultInstance();
        }
        try {
            alg = this.factory.getPublicKeyAlgorithm(this.algid);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("NoSuchAlgorithm - " + nsae);
        }
        alg.generateKeyPair(this.keysize, this.sr);
        if (this.subkey) {
            this.sk = new PGPSecretSubKeyPacket();
            this.pk = new PGPPublicSubKeyPacket();
            this.sk.setPacketID((byte)7);
            this.pk.setPacketID((byte)14);
        } else {
            this.sk = new PGPSecretKeyPacket();
            this.pk = new PGPPublicKeyPacket();
            this.sk.setPacketID((byte)5);
            this.pk.setPacketID((byte)6);
        }
        if (this.legacy) {
            this.sk.setVersion(3);
            this.pk.setVersion(3);
            this.sk.setV23ExpirationDate(this.expiration);
            this.pk.setV23ExpirationDate(this.expiration);
        } else {
            this.sk.setVersion(4);
            this.pk.setVersion(4);
            if (this.expiration != 0) {
                throw new IllegalStateException("V4 keys cannot have an expiration date set directly on the key.");
            }
        }
        Date d = new Date();
        this.sk.setCreationDate(d);
        this.pk.setCreationDate(d);
        this.sk.setAlgorithm(alg, (byte)this.algid);
        this.pk.setAlgorithm(alg.clonePublic(), (byte)this.algid);
        return new KeyPair(new PGPPublicKey(this.pk, this.algorithm), new PGPPrivateKey(this.sk, this.algorithm));
    }

    public void initialize(int keysize, SecureRandom random) {
        if (keysize <= 0) {
            throw new InvalidParameterException("Keysize < 0");
        }
        this.keysize = keysize;
        this.sr = random;
        this.expiration = 0;
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!this.legacy) {
            throw new InvalidAlgorithmParameterException("Can only initialize with an AlgorithmParameterSpec for legacy keys, use the initialize method with the keysize for newer keys as that is the only possible parameter.");
        }
        if (!(params instanceof PGPLegacyKeyPairGeneratorParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Parameters not of type PGPLegacyKeyPairGeneratorParameterSpec");
        }
        int keysize = ((PGPLegacyKeyPairGeneratorParameterSpec)params).getKeySize();
        if (keysize <= 0) {
            throw new InvalidAlgorithmParameterException("Keysize <= 0");
        }
        int expiration = ((PGPLegacyKeyPairGeneratorParameterSpec)params).getExpiration();
        if (expiration < 0) {
            throw new InvalidAlgorithmParameterException("Expiration < 0");
        }
        if (expiration > 65535) {
            throw new InvalidAlgorithmParameterException("Expiration > 65535");
        }
        this.keysize = keysize;
        this.expiration = expiration;
        this.sr = random;
    }

    public static class SigningDSA
    extends PGPKeyPairGenerator {
        public SigningDSA() {
            super(17, 1024, "OpenPGP/Signing/DSA", false, false);
        }
    }

    public static class SigningRSA
    extends PGPKeyPairGenerator {
        public SigningRSA() {
            super(1, 2048, "OpenPGP/Signing/RSA", false, false);
        }
    }

    public static class SigningElGamal
    extends PGPKeyPairGenerator {
        public SigningElGamal() {
            super(20, 2048, "OpenPGP/Signing/ElGamal", false, false);
        }
    }

    public static class EncryptionRSA
    extends PGPKeyPairGenerator {
        public EncryptionRSA() {
            super(1, 2048, "OpenPGP/Encryption/RSA", true, false);
        }
    }

    public static class EncryptionElGamal
    extends PGPKeyPairGenerator {
        public EncryptionElGamal() {
            super(16, 2048, "OpenPGP/Encryption/ElGamal", true, false);
        }
    }

    public static class LegacyRSA
    extends PGPKeyPairGenerator {
        public LegacyRSA() {
            super(1, 2048, "OpenPGP/Legacy/RSA", false, true);
        }
    }
}

