/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.provider;

import cryptix.openpgp.PGPCertificate;
import cryptix.openpgp.PGPKeyBundle;
import cryptix.openpgp.PGPPrivateKey;
import cryptix.openpgp.PGPPublicKey;
import cryptix.openpgp.provider.PGPKeyBundleFactory;
import cryptix.openpgp.provider.PGPKeyBundleImpl;
import cryptix.openpgp.provider.PGPKeyIDFactory;
import cryptix.pki.ExtendedKeyStoreSpi;
import cryptix.pki.KeyBundle;
import cryptix.pki.KeyBundleException;
import cryptix.pki.KeyID;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.AbstractList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class PGPKeyRingKeyStore
extends ExtendedKeyStoreSpi {
    private Vector bundles;
    private HashMap bundleAliases;
    private boolean loaded = false;
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Enumeration engineAliases() {
        return new IteratorEnumeration(this.bundleAliases.keySet().iterator());
    }

    public boolean engineContainsAlias(String alias) {
        return this.bundleAliases.containsKey(alias);
    }

    public void engineDeleteEntry(String alias) throws KeyStoreException {
        Object x = this.bundleAliases.remove(alias);
        if (x != null) {
            this.bundles.remove(x);
        }
    }

    public Certificate engineGetCertificate(String alias) {
        return null;
    }

    public String engineGetCertificateAlias(Certificate cert) {
        return null;
    }

    public Certificate[] engineGetCertificateChain(String alias) {
        if (!this.bundleAliases.containsKey(alias)) {
            return null;
        }
        PGPKeyBundle bundle = (PGPKeyBundle)((Object)this.bundleAliases.get(alias));
        Iterator it = bundle.getCertificates();
        int size = 0;
        while (it.hasNext()) {
            ++size;
        }
        Certificate[] result = new Certificate[size];
        it = bundle.getCertificates();
        int i = 0;
        while (it.hasNext()) {
            result[i++] = (Certificate)it.next();
        }
        return result;
    }

    public Date engineGetCreationDate(String alias) {
        throw new RuntimeException("NYI");
    }

    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        if (!this.bundleAliases.containsKey(alias)) {
            return null;
        }
        PGPKeyBundle bundle = (PGPKeyBundle)((Object)this.bundleAliases.get(alias));
        PGPPublicKey mainkey = (PGPPublicKey)bundle.getPublicKeys().next();
        return bundle.getPrivateKey(mainkey, password);
    }

    public KeyBundle engineGetKeyBundle(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException("Not yet loaded.");
        }
        return (KeyBundle)this.bundleAliases.get(alias);
    }

    public boolean engineIsCertificateEntry(String alias) {
        return false;
    }

    public boolean engineIsKeyBundleEntry(String alias) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException("Not yet loaded.");
        }
        return this.bundleAliases.containsKey(alias);
    }

    public boolean engineIsKeyEntry(String alias) {
        if (this.bundleAliases.containsKey(alias)) {
            PGPKeyBundleImpl bundle = (PGPKeyBundleImpl)((Object)this.bundleAliases.get(alias));
            return bundle.containsPrivateKey();
        }
        return false;
    }

    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (password != null) {
            throw new NoSuchAlgorithmException("Password based integrity protection is not supported.");
        }
        try {
            if (stream == null) {
                this.bundles = new Vector();
                this.bundleAliases = new HashMap();
            } else {
                this.bundles = (Vector)PGPKeyBundleFactory.helper(stream, false);
                this.bundleAliases = new HashMap();
                Iterator it = ((AbstractList)this.bundles).iterator();
                while (it.hasNext()) {
                    PGPKeyBundle bundle = (PGPKeyBundle)((Object)it.next());
                    KeyID id = PGPKeyIDFactory.convert((Key)bundle.getPublicKeys().next());
                    byte[] keyid = id.getBytes(4);
                    char[] buf = new char[]{'0', 'x', hexDigits[keyid[0] >>> 4 & 0xF], hexDigits[keyid[0] & 0xF], hexDigits[keyid[1] >>> 4 & 0xF], hexDigits[keyid[1] & 0xF], hexDigits[keyid[2] >>> 4 & 0xF], hexDigits[keyid[2] & 0xF], hexDigits[keyid[3] >>> 4 & 0xF], hexDigits[keyid[3] & 0xF]};
                    String keyalias = new String(buf);
                    this.bundleAliases.put(keyalias, bundle);
                }
            }
        }
        catch (KeyBundleException kbe) {
            throw new CertificateException("Error while reading keyring - " + (Object)((Object)kbe));
        }
        catch (InvalidKeyException ike) {
            throw new CertificateException("Error while reading keyring - " + ike);
        }
        this.loaded = true;
    }

    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        try {
            if (!(cert instanceof PGPCertificate)) {
                throw new KeyStoreException("Supplied certificate is not a PGPCertificate.");
            }
            if (alias != null) {
                throw new KeyStoreException("This keystore does not support storing user-supplied aliases. Use null as the alias and let the keystore think of an alias.");
            }
            KeyID id = PGPKeyIDFactory.convert(cert.getPublicKey());
            byte[] keyid = id.getBytes(4);
            char[] buf = new char[]{'0', 'x', hexDigits[keyid[0] >>> 4 & 0xF], hexDigits[keyid[0] & 0xF], hexDigits[keyid[1] >>> 4 & 0xF], hexDigits[keyid[1] & 0xF], hexDigits[keyid[2] >>> 4 & 0xF], hexDigits[keyid[2] & 0xF], hexDigits[keyid[3] >>> 4 & 0xF], hexDigits[keyid[3] & 0xF]};
            String keyalias = new String(buf);
            PGPKeyBundleImpl bundle = (PGPKeyBundleImpl)((Object)this.bundleAliases.get(keyalias));
            if (bundle == null) {
                bundle = new PGPKeyBundleImpl();
                this.bundles.add(bundle);
                this.bundleAliases.put(keyalias, bundle);
            }
            bundle.addCertificate(cert);
        }
        catch (InvalidKeyException ike) {
            throw new KeyStoreException(String.valueOf(String.valueOf(ike)));
        }
        catch (KeyBundleException kbe) {
            throw new KeyStoreException(String.valueOf(String.valueOf((Object)kbe)));
        }
    }

    public String engineSetKeyBundleEntry(KeyBundle bundle) throws KeyStoreException {
        if (!this.loaded) {
            throw new KeyStoreException("Not yet loaded.");
        }
        try {
            if (!(bundle instanceof PGPKeyBundle)) {
                throw new KeyStoreException("Supplied certificate is not a PGPCertificate.");
            }
            KeyID id = PGPKeyIDFactory.convert((Key)bundle.getPublicKeys().next());
            byte[] keyid = id.getBytes(4);
            char[] buf = new char[]{'0', 'x', hexDigits[keyid[0] >>> 4 & 0xF], hexDigits[keyid[0] & 0xF], hexDigits[keyid[1] >>> 4 & 0xF], hexDigits[keyid[1] & 0xF], hexDigits[keyid[2] >>> 4 & 0xF], hexDigits[keyid[2] & 0xF], hexDigits[keyid[3] >>> 4 & 0xF], hexDigits[keyid[3] & 0xF]};
            String keyalias = new String(buf);
            this.bundles.add(bundle);
            this.bundleAliases.put(keyalias, bundle);
            return keyalias;
        }
        catch (InvalidKeyException ike) {
            throw new KeyStoreException(String.valueOf(String.valueOf(ike)));
        }
    }

    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        try {
            if (!(key instanceof PGPPrivateKey)) {
                throw new KeyStoreException("PGPPrivateKey expected.");
            }
            PGPKeyBundleImpl bundle = new PGPKeyBundleImpl();
            int i = 0;
            while (i < chain.length) {
                bundle.addCertificate(chain[i]);
                ++i;
            }
            bundle.addPrivateKey((PGPPrivateKey)key, chain[0].getPublicKey(), password, new SecureRandom());
            KeyID id = PGPKeyIDFactory.convert(key);
            byte[] keyid = id.getBytes(4);
            char[] buf = new char[]{'0', 'x', hexDigits[keyid[0] >>> 4 & 0xF], hexDigits[keyid[0] & 0xF], hexDigits[keyid[1] >>> 4 & 0xF], hexDigits[keyid[1] & 0xF], hexDigits[keyid[2] >>> 4 & 0xF], hexDigits[keyid[2] & 0xF], hexDigits[keyid[3] >>> 4 & 0xF], hexDigits[keyid[3] & 0xF]};
            String newalias = new String(buf);
            if (alias != null && !newalias.equals(alias)) {
                throw new KeyStoreException("This keystore does not support storing user-supplied aliases. Use null as the alias and let the keystore think of an alias.");
            }
            this.bundles.add(bundle);
            this.bundleAliases.put(newalias, bundle);
        }
        catch (InvalidKeyException ike) {
            throw new KeyStoreException(String.valueOf(String.valueOf(ike)));
        }
        catch (KeyBundleException kbe) {
            throw new KeyStoreException(String.valueOf(String.valueOf((Object)kbe)));
        }
    }

    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new RuntimeException("NYI");
    }

    public int engineSize() {
        return this.bundles.size();
    }

    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (password != null) {
            throw new NoSuchAlgorithmException("Password based integrity protection is not supported.");
        }
        try {
            Iterator it = ((AbstractList)this.bundles).iterator();
            while (it.hasNext()) {
                stream.write(((PGPKeyBundle)((Object)it.next())).getEncoded());
            }
        }
        catch (KeyBundleException kbe) {
            throw new CertificateException("Error while writing keyring - " + (Object)((Object)kbe));
        }
    }

    private class IteratorEnumeration
    implements Enumeration {
        private Iterator parent;

        public IteratorEnumeration(Iterator parent) {
            this.parent = parent;
        }

        public boolean hasMoreElements() {
            return this.parent.hasNext();
        }

        public Object nextElement() {
            return this.parent.next();
        }
    }
}

