/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public class PGPKeyIDSP
extends PGPSignatureSubPacket {
    private byte[] value;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] value = new byte[8];
        in.readFully(value);
        this.setValue(value);
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getValue() == null) {
            throw new IllegalStateException("Packet data not initialized");
        }
        out.writeFully(this.getValue());
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPKeyIDSP)) {
            return false;
        }
        PGPKeyIDSP that = (PGPKeyIDSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getValue(), that.getValue());
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        if (value.length != 8) {
            throw new IllegalArgumentException("KeyID should be 8 bytes");
        }
        this.value = value;
    }
}

