/*
 * Decompiled with CFR 0.152.
 */
package cryptix.openpgp.signature;

import cryptix.openpgp.PGPDataFormatException;
import cryptix.openpgp.PGPFatalDataFormatException;
import cryptix.openpgp.io.PGPSignatureDataInputStream;
import cryptix.openpgp.io.PGPSignatureDataOutputStream;
import cryptix.openpgp.signature.PGPSignatureSubPacket;
import cryptix.openpgp.util.PGPCompare;
import java.io.IOException;

public class PGPUnknownSP
extends PGPSignatureSubPacket {
    private byte[] payload;

    protected void decodeBody(PGPSignatureDataInputStream in) throws IOException, PGPDataFormatException, PGPFatalDataFormatException {
        byte[] value = in.readByteArray();
        if (value.length == 0) {
            throw new PGPDataFormatException("No data found.");
        }
        this.setPayload(value);
    }

    protected void encodeBody(PGPSignatureDataOutputStream out) throws IOException {
        if (this.getPayload() == null) {
            throw new IllegalStateException("Packet data not initialized");
        }
        out.writeFully(this.getPayload());
    }

    public boolean equals(Object ssp) {
        if (!(ssp instanceof PGPUnknownSP)) {
            return false;
        }
        PGPUnknownSP that = (PGPUnknownSP)ssp;
        return PGPCompare.equals(this.getPacketID(), that.getPacketID()) && PGPCompare.equals(this.getPayload(), that.getPayload());
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public void setPayload(byte[] payload) {
        if (payload.length == 0) {
            throw new IllegalArgumentException("Array size == 0");
        }
        this.payload = payload;
    }
}

