/*
 * Decompiled with CFR 0.152.
 */
package cryptix.pki;

import cryptix.pki.KeyID;
import cryptix.pki.KeyIDFactorySpi;
import cryptix.pki.Support;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public class KeyIDFactory {
    private final KeyIDFactorySpi spi;
    private final Provider provider;
    private final String format;

    protected KeyIDFactory(KeyIDFactorySpi builderSpi, Provider provider, String format) {
        this.spi = builderSpi;
        this.provider = provider;
        this.format = format;
    }

    public final KeyID generateKeyID(Key key) throws InvalidKeyException {
        return this.spi.engineGenerateKeyID(key);
    }

    public final String getFormat() {
        return this.format;
    }

    public static KeyIDFactory getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("KeyIDFactory", format);
        return new KeyIDFactory((KeyIDFactorySpi)o[0], (Provider)o[1], format);
    }

    public static KeyIDFactory getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("KeyIDFactory", format, provider);
        return new KeyIDFactory((KeyIDFactorySpi)o[0], (Provider)o[1], format);
    }

    public static KeyIDFactory getInstance(String format, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("KeyIDFactory", format, provider);
        return new KeyIDFactory((KeyIDFactorySpi)o[0], (Provider)o[1], format);
    }

    public final Provider getProvider() {
        return this.provider;
    }
}

