/*
 * Decompiled with CFR 0.152.
 */
package org.mule.agent;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.mule.agent.AbstractNotificationLoggerAgent;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.util.MapUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4jNotificationLoggerAgent
extends AbstractNotificationLoggerAgent {
    protected static final int DEFAULT_DESCRIPTION_BUFFER_SIZE = 64;
    protected Logger eventLogger;
    private String logName = Log4jNotificationLoggerAgent.class.getName();
    private String logFile = null;
    private String logConfigFile = null;
    private String chainsawHost = "localhost";
    private int chainsawPort = -1;
    private final Map<?, ?> levelMappings = new HashMap();

    public Log4jNotificationLoggerAgent() {
        super("log4j-notifications");
    }

    @Override
    public String getDescription() {
        StringBuffer buf = new StringBuffer(64);
        if (StringUtils.isNotBlank((String)this.logName)) {
            buf.append("Logging notifications to logger: ").append(this.logName);
        }
        if (StringUtils.isNotBlank((String)this.logFile)) {
            buf.append("Logging notifications to: ").append(this.logFile);
        }
        if (this.chainsawPort > -1) {
            buf.append(" Chainsaw: ").append(this.chainsawHost).append(":").append(this.chainsawPort);
        }
        if (buf.length() == 0) {
            buf.append("No logging or event forwarding is configured");
        }
        return this.getName() + ": " + buf.toString();
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        if (this.logConfigFile != null) {
            if (this.logConfigFile.endsWith(".xml")) {
                DOMConfigurator.configure((String)this.logConfigFile);
            } else {
                PropertyConfigurator.configure((String)this.logConfigFile);
            }
        } else {
            this.eventLogger = Logger.getLogger((String)this.logName);
        }
    }

    @Override
    protected void logEvent(ServerNotification e) {
        if (this.eventLogger != null) {
            String actionKey = e.EVENT_NAME + "." + e.getActionName();
            String level = MapUtils.getString(this.levelMappings, (Object)actionKey, (String)e.getType());
            this.eventLogger.log((Priority)Level.toLevel((String)level, (Level)Level.INFO), (Object)e);
        }
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getLogConfigFile() {
        return this.logConfigFile;
    }

    public void setLogConfigFile(String logConfigFile) {
        this.logConfigFile = logConfigFile;
    }

    public String getChainsawHost() {
        return this.chainsawHost;
    }

    public void setChainsawHost(String chainsawHost) {
        this.chainsawHost = chainsawHost;
    }

    public int getChainsawPort() {
        return this.chainsawPort;
    }

    public void setChainsawPort(int chainsawPort) {
        this.chainsawPort = chainsawPort;
    }

    public Map<?, ?> getLevelMappings() {
        return this.levelMappings;
    }

    public void setLevelMappings(Map levelMappings) {
        this.levelMappings.putAll(levelMappings);
    }
}

