/*
 * Decompiled with CFR 0.152.
 */
package org.mule.management.stats;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mule.management.stats.ServiceStatistics;
import org.mule.management.stats.printers.AbstractTablePrinter;
import org.mule.management.stats.printers.SimplePrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllStatistics {
    private boolean isStatisticsEnabled;
    private long startTime;
    private Map<String, ServiceStatistics> serviceStats = new HashMap<String, ServiceStatistics>();

    public AllStatistics() {
        this.clear();
    }

    public void logSummary() {
        this.logSummary(new SimplePrinter(System.out));
    }

    public void logSummary(PrintWriter printer) {
        if (printer instanceof AbstractTablePrinter) {
            printer.print(this.serviceStats.values());
        } else {
            for (ServiceStatistics serviceStatistics : this.serviceStats.values()) {
                printer.print(serviceStatistics);
            }
        }
    }

    public synchronized void clear() {
        for (ServiceStatistics serviceStatistics : this.getServiceStatistics()) {
            serviceStatistics.clear();
        }
        this.startTime = System.currentTimeMillis();
    }

    public boolean isEnabled() {
        return this.isStatisticsEnabled;
    }

    public void setEnabled(boolean b) {
        this.isStatisticsEnabled = b;
        for (ServiceStatistics serviceStatistics : this.serviceStats.values()) {
            serviceStatistics.setEnabled(b);
        }
    }

    public synchronized long getStartTime() {
        return this.startTime;
    }

    public synchronized void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public synchronized void add(ServiceStatistics stat) {
        if (stat != null) {
            this.serviceStats.put(stat.getName(), stat);
        }
    }

    public synchronized void remove(ServiceStatistics stat) {
        if (stat != null) {
            this.serviceStats.remove(stat.getName());
        }
    }

    @Deprecated
    public synchronized Collection<ServiceStatistics> getComponentStatistics() {
        return this.serviceStats.values();
    }

    public synchronized Collection<ServiceStatistics> getServiceStatistics() {
        return this.serviceStats.values();
    }
}

