/*
 * Decompiled with CFR 0.152.
 */
package org.mule.model.resolvers;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MuleEventContext;
import org.mule.api.model.EntryPointResolver;
import org.mule.api.model.EntryPointResolverSet;
import org.mule.api.model.InvocationResult;
import org.mule.model.resolvers.EntryPointNotFoundException;
import org.mule.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEntryPointResolverSet
implements EntryPointResolverSet {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final Set<EntryPointResolver> entryPointResolvers = new LinkedHashSet<EntryPointResolver>(4);
    private final Set<String> exceptions = new CopyOnWriteArraySet<String>();

    @Override
    public Object invoke(Object component, MuleEventContext context) throws Exception {
        try {
            for (EntryPointResolver resolver : this.entryPointResolvers) {
                InvocationResult result = resolver.invoke(component, context);
                if (result.getState() == InvocationResult.State.SUCCESSFUL) {
                    Object object = result.getResult();
                    return object;
                }
                if (!result.hasError()) continue;
                this.exceptions.add(result.getErrorMessage());
            }
            throw new EntryPointNotFoundException(CollectionUtils.toString(this.exceptions, true));
        }
        finally {
            this.exceptions.clear();
        }
    }

    public Set<EntryPointResolver> getEntryPointResolvers() {
        return this.entryPointResolvers;
    }

    public void setEntryPointResolvers(Set<EntryPointResolver> entryPointResolvers) {
        this.entryPointResolvers.clear();
        this.entryPointResolvers.addAll(entryPointResolvers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntryPointResolver(EntryPointResolver resolver) {
        Set<EntryPointResolver> set = this.entryPointResolvers;
        synchronized (set) {
            this.entryPointResolvers.add(resolver);
        }
    }

    @Override
    public boolean removeEntryPointResolver(EntryPointResolver resolver) {
        return this.entryPointResolvers.remove(resolver);
    }
}

