/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.RouterResultsHandler;
import org.mule.api.routing.RouterStatisticsRecorder;
import org.mule.api.routing.SelectiveRouter;
import org.mule.api.routing.filter.Filter;
import org.mule.config.i18n.MessageFactory;
import org.mule.management.stats.RouterStatistics;
import org.mule.routing.DefaultRouterResultsHandler;
import org.mule.routing.MessageProcessorFilterPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectiveRouter
implements SelectiveRouter,
RouterStatisticsRecorder,
Lifecycle,
FlowConstructAware {
    private final List<MessageProcessorFilterPair> conditionalMessageProcessors = new ArrayList<MessageProcessorFilterPair>();
    private MessageProcessor defaultProcessor;
    private final RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    private RouterStatistics routerStatistics;
    final AtomicBoolean initialised = new AtomicBoolean(false);
    final AtomicBoolean starting = new AtomicBoolean(false);
    final AtomicBoolean started = new AtomicBoolean(false);
    private FlowConstruct flowConstruct;

    public AbstractSelectiveRouter() {
        this.routerStatistics = new RouterStatistics(2);
    }

    @Override
    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws InitialisationException {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (o instanceof FlowConstructAware) {
                    ((FlowConstructAware)o).setFlowConstruct(this.flowConstruct);
                }
                if (!(o instanceof Initialisable)) continue;
                ((Initialisable)o).initialise();
            }
        }
        this.initialised.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws MuleException {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            this.starting.set(true);
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Startable)) continue;
                ((Startable)o).start();
            }
            this.started.set(true);
            this.starting.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws MuleException {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Stoppable)) continue;
                ((Stoppable)o).stop();
            }
            this.started.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (Object o : this.getLifecycleManagedObjects()) {
                if (!(o instanceof Disposable)) continue;
                ((Disposable)o).dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoute(MessageProcessor processor, Filter filter) {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            MessageProcessorFilterPair addedPair = new MessageProcessorFilterPair(processor, filter);
            this.conditionalMessageProcessors.add(this.transitionLifecycleManagedObjectForAddition(addedPair));
        }
    }

    @Override
    public void removeRoute(MessageProcessor processor) {
        this.updateRoute(processor, new RoutesUpdater(){

            public void updateAt(int index) {
                MessageProcessorFilterPair removedPair = (MessageProcessorFilterPair)AbstractSelectiveRouter.this.conditionalMessageProcessors.remove(index);
                AbstractSelectiveRouter.this.transitionLifecycleManagedObjectForRemoval(removedPair);
            }
        });
    }

    @Override
    public void updateRoute(final MessageProcessor processor, final Filter filter) {
        this.updateRoute(processor, new RoutesUpdater(){

            public void updateAt(int index) {
                MessageProcessorFilterPair addedPair = new MessageProcessorFilterPair(processor, filter);
                MessageProcessorFilterPair removedPair = (MessageProcessorFilterPair)AbstractSelectiveRouter.this.conditionalMessageProcessors.set(index, AbstractSelectiveRouter.this.transitionLifecycleManagedObjectForAddition(addedPair));
                AbstractSelectiveRouter.this.transitionLifecycleManagedObjectForRemoval(removedPair);
            }
        });
    }

    @Override
    public void setDefaultRoute(MessageProcessor processor) {
        this.defaultProcessor = processor;
    }

    @Override
    public MuleEvent process(MuleEvent event) throws MuleException {
        Collection<MessageProcessor> selectedProcessors = this.selectProcessors(event);
        if (!selectedProcessors.isEmpty()) {
            return this.routeWithProcessors(selectedProcessors, event);
        }
        if (this.defaultProcessor != null) {
            return this.routeWithProcessor(this.defaultProcessor, event);
        }
        if (this.getRouterStatistics() != null) {
            this.getRouterStatistics().incrementNoRoutedMessage();
        }
        throw new RoutePathNotFoundException(MessageFactory.createStaticMessage("Can't process message because no route has been found matching any filter and no default route is defined"), event, this);
    }

    protected abstract Collection<MessageProcessor> selectProcessors(MuleEvent var1);

    private Collection<?> getLifecycleManagedObjects() {
        if (this.defaultProcessor == null) {
            return this.conditionalMessageProcessors;
        }
        return ListUtils.union(this.conditionalMessageProcessors, Collections.singletonList(this.defaultProcessor));
    }

    private <O> O transitionLifecycleManagedObjectForAddition(O managedObject) {
        try {
            if (this.flowConstruct != null && managedObject instanceof FlowConstructAware) {
                ((FlowConstructAware)managedObject).setFlowConstruct(this.flowConstruct);
            }
            if (this.initialised.get() && managedObject instanceof Initialisable) {
                ((Initialisable)managedObject).initialise();
            }
            if (this.started.get() && managedObject instanceof Startable) {
                ((Startable)managedObject).start();
            }
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        return managedObject;
    }

    private <O> O transitionLifecycleManagedObjectForRemoval(O managedObject) {
        try {
            if (managedObject instanceof Stoppable) {
                ((Stoppable)managedObject).stop();
            }
            if (managedObject instanceof Disposable) {
                ((Disposable)managedObject).dispose();
            }
        }
        catch (MuleException me) {
            throw new MuleRuntimeException(me);
        }
        return managedObject;
    }

    private MuleEvent routeWithProcessor(MessageProcessor processor, MuleEvent event) throws MuleException {
        return this.routeWithProcessors(Collections.singleton(processor), event);
    }

    private MuleEvent routeWithProcessors(Collection<MessageProcessor> processors, MuleEvent event) throws MuleException {
        ArrayList<MuleEvent> results = new ArrayList<MuleEvent>();
        for (MessageProcessor processor : processors) {
            this.processEventWithProcessor(event, processor, results);
        }
        return this.resultsHandler.aggregateResults(results, event, event.getMuleContext());
    }

    private void processEventWithProcessor(MuleEvent event, MessageProcessor processor, List<MuleEvent> results) throws MuleException {
        MuleEvent processedEvent = event;
        if (processor instanceof OutboundEndpoint) {
            processedEvent = new DefaultMuleEvent(event.getMessage(), (OutboundEndpoint)processor, event.getSession());
        }
        results.add(processor.process(processedEvent));
        if (this.getRouterStatistics() != null) {
            this.getRouterStatistics().incrementRoutedMessage(event.getEndpoint());
        }
    }

    protected List<MessageProcessorFilterPair> getConditionalMessageProcessors() {
        return Collections.unmodifiableList(this.conditionalMessageProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoute(MessageProcessor processor, RoutesUpdater routesUpdater) {
        List<MessageProcessorFilterPair> list = this.conditionalMessageProcessors;
        synchronized (list) {
            for (int i = 0; i < this.conditionalMessageProcessors.size(); ++i) {
                if (!this.conditionalMessageProcessors.get(i).getMessageProcessor().equals(processor)) continue;
                routesUpdater.updateAt(i);
            }
        }
    }

    public RouterStatistics getRouterStatistics() {
        return this.routerStatistics;
    }

    @Override
    public void setRouterStatistics(RouterStatistics routerStatistics) {
        this.routerStatistics = routerStatistics;
    }

    public String toString() {
        return String.format("%s [flow-construct=%s, started=%s]", this.getClass().getSimpleName(), this.flowConstruct != null ? this.flowConstruct.getName() : null, this.started);
    }

    private static interface RoutesUpdater {
        public void updateAt(int var1);
    }
}

