/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.DefaultMuleEvent;
import org.mule.api.MuleEvent;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.config.i18n.CoreMessages;
import org.mule.routing.AbstractCatchAllStrategy;

public class ForwardingCatchAllStrategy
extends AbstractCatchAllStrategy {
    private boolean sendTransformed = false;
    protected OutboundEndpoint endpoint;

    public void setEndpoint(OutboundEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public void setMessageProcessor(MessageProcessor processor) {
        this.endpoint = (OutboundEndpoint)processor;
    }

    public OutboundEndpoint getEndpoint() {
        return this.endpoint;
    }

    public MuleEvent doCatchMessage(MuleEvent event) throws RoutingException {
        if (this.getEndpoint() == null) {
            throw new RoutingException(CoreMessages.noCatchAllEndpointSet(), event, this.getEndpoint());
        }
        try {
            OutboundEndpoint endpoint = this.getEndpoint();
            if (this.sendTransformed && endpoint.getTransformers() != null) {
                event.getMessage().applyTransformers(event, endpoint.getTransformers());
            }
            event = new DefaultMuleEvent(event.getMessage(), (ImmutableEndpoint)endpoint, event.getFlowConstruct(), event);
            MuleEvent result = endpoint.process(event);
            if (this.statistics != null) {
                this.statistics.incrementRoutedMessage(this.getEndpoint());
            }
            return result;
        }
        catch (Exception e) {
            throw new RoutingException(event, this.getEndpoint(), (Throwable)e);
        }
    }

    public boolean isSendTransformed() {
        return this.sendTransformed;
    }

    public void setSendTransformed(boolean sendTransformed) {
        this.sendTransformed = sendTransformed;
    }
}

