/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.filters;

import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.security.Authentication;
import org.mule.api.security.CredentialsNotSetException;
import org.mule.api.security.CryptoFailureException;
import org.mule.api.security.EncryptionStrategyNotFoundException;
import org.mule.api.security.SecurityContext;
import org.mule.api.security.SecurityException;
import org.mule.api.security.SecurityProviderNotFoundException;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.security.UnknownAuthenticationTypeException;
import org.mule.config.i18n.CoreMessages;
import org.mule.security.AbstractEndpointSecurityFilter;
import org.mule.security.DefaultMuleAuthentication;
import org.mule.security.MuleCredentials;
import org.mule.security.MuleHeaderCredentialsAccessor;

public class MuleEncryptionEndpointSecurityFilter
extends AbstractEndpointSecurityFilter {
    private EncryptionStrategy strategy;

    public MuleEncryptionEndpointSecurityFilter() {
        this.setCredentialsAccessor(new MuleHeaderCredentialsAccessor());
    }

    protected final void authenticateInbound(MuleEvent event) throws SecurityException, CryptoFailureException, EncryptionStrategyNotFoundException, UnknownAuthenticationTypeException {
        Authentication authentication;
        String userHeader = (String)this.getCredentialsAccessor().getCredentials(event);
        if (userHeader == null) {
            throw new CredentialsNotSetException(event, event.getSession().getSecurityContext(), event.getEndpoint(), this);
        }
        MuleCredentials user = new MuleCredentials(userHeader, this.getSecurityManager());
        try {
            authentication = this.getSecurityManager().authenticate(new DefaultMuleAuthentication(user));
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication request for user: " + user.getUsername() + " failed: " + e.toString()));
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser(user.getUsername()), event, (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Authentication success: " + authentication.toString()));
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authentication);
        context.setAuthentication(authentication);
        event.getSession().setSecurityContext(context);
    }

    protected void authenticateOutbound(MuleEvent event) throws SecurityException, SecurityProviderNotFoundException, CryptoFailureException {
        if (event.getSession().getSecurityContext() == null) {
            if (this.isAuthenticate()) {
                throw new UnauthorisedException(event, event.getSession().getSecurityContext(), event.getEndpoint(), this);
            }
            return;
        }
        Authentication auth = event.getSession().getSecurityContext().getAuthentication();
        if (this.isAuthenticate()) {
            auth = this.getSecurityManager().authenticate(auth);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Authentication success: " + auth.toString()));
            }
        }
        String token = auth.getCredentials().toString();
        String header = new String(this.strategy.encrypt(token.getBytes(), null));
        this.getCredentialsAccessor().setCredentials(event, header);
    }

    protected void doInitialise() throws InitialisationException {
        if (this.strategy == null) {
            throw new InitialisationException(CoreMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }

    public EncryptionStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(EncryptionStrategy strategy) {
        this.strategy = strategy;
    }
}

