/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformer.simple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.mule.RequestContext;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.OutputHandler;
import org.mule.transformer.simple.SerializableToByteArray;
import org.mule.transformer.types.DataTypeFactory;

public class ObjectToInputStream
extends SerializableToByteArray {
    public ObjectToInputStream() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.create(OutputHandler.class));
        this.setReturnDataType(DataTypeFactory.INPUT_STREAM);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            if (src instanceof String) {
                return new ByteArrayInputStream(((String)src).getBytes(encoding));
            }
            if (src instanceof byte[]) {
                return new ByteArrayInputStream((byte[])src);
            }
            if (src instanceof OutputHandler) {
                OutputHandler oh = (OutputHandler)src;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                oh.write(RequestContext.getEvent(), out);
                return new ByteArrayInputStream(out.toByteArray());
            }
            return new ByteArrayInputStream((byte[])super.doTransform(src, encoding));
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }
}

