/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.ServiceRegistry;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.launcher.AppBloodhound;
import org.mule.module.launcher.descriptor.ApplicationDescriptor;
import org.mule.module.launcher.descriptor.DescriptorParser;
import org.mule.module.launcher.descriptor.EmptyApplicationDescriptor;
import org.mule.module.launcher.descriptor.Preferred;
import org.mule.module.launcher.descriptor.PropertiesDescriptorParser;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;

public class DefaultAppBloodhound
implements AppBloodhound {
    protected Map<String, DescriptorParser> parserRegistry = new HashMap<String, DescriptorParser>();

    public DefaultAppBloodhound() {
        this.parserRegistry.put("properties", new PropertiesDescriptorParser());
        Iterator<DescriptorParser> it = ServiceRegistry.lookupProviders(DescriptorParser.class);
        MultiValueMap overrides = new MultiValueMap();
        while (it.hasNext()) {
            DescriptorParser parser = it.next();
            overrides.put((Object)parser.getSupportedFormat(), (Object)parser);
        }
        this.mergeParserOverrides((MultiMap)overrides);
    }

    public ApplicationDescriptor fetch(String appName) throws IOException {
        File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
        File appDir = new File(appsDir, appName);
        if (!appDir.exists()) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage(String.format("Application directory does not exist '%s'", appName)));
        }
        Collection deployFiles = FileUtils.listFiles((File)appDir, (IOFileFilter)new WildcardFileFilter("mule-deploy.*"), null);
        if (deployFiles.isEmpty()) {
            return new EmptyApplicationDescriptor(appName);
        }
        if (deployFiles.size() > 1) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage(String.format("More than one mule-deploy descriptors found in application '%s'", appName)));
        }
        File descriptorFile = (File)deployFiles.iterator().next();
        String ext = FilenameUtils.getExtension((String)descriptorFile.getName());
        DescriptorParser descriptorParser = this.parserRegistry.get(ext);
        if (descriptorParser == null) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage(String.format("Unsupported deployment descriptor format for app '%s': %s", appName, ext)));
        }
        ApplicationDescriptor desc = descriptorParser.parse(descriptorFile);
        desc.setAppName(appName);
        return desc;
    }

    protected void mergeParserOverrides(MultiMap overrides) {
        for (Map.Entry<String, DescriptorParser> entry : this.parserRegistry.entrySet()) {
            Collection candidates = (Collection)overrides.get((Object)entry.getKey());
            if (candidates == null) continue;
            ArrayList sorted = new ArrayList(candidates);
            Comparator<DescriptorParser> annotationComparator = new Comparator<DescriptorParser>(){

                @Override
                public int compare(DescriptorParser p1, DescriptorParser p2) {
                    Preferred ann1 = p1.getClass().getAnnotation(Preferred.class);
                    Preferred ann2 = p2.getClass().getAnnotation(Preferred.class);
                    if (ann1 == null && ann2 == null) {
                        return 0;
                    }
                    if (ann1 != null && ann2 == null) {
                        return 1;
                    }
                    if (ann1 == null) {
                        return -1;
                    }
                    return new Integer(ann1.weight()).compareTo(ann2.weight());
                }
            };
            Collections.sort(sorted, Collections.reverseOrder(annotationComparator));
            this.parserRegistry.put(entry.getKey(), (DescriptorParser)sorted.get(0));
        }
    }
}

