/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.beanutils.BeanPropertyValueEqualsPredicate;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.StartupContext;
import org.mule.module.launcher.AppDeployerMonitorThreadFactory;
import org.mule.module.launcher.Application;
import org.mule.module.launcher.ApplicationWrapper;
import org.mule.module.launcher.DefaultMuleApplication;
import org.mule.module.launcher.DefaultMuleDeployer;
import org.mule.module.launcher.MuleDeployer;
import org.mule.module.reboot.MuleContainerBootstrapUtils;
import org.mule.util.CollectionUtils;
import org.mule.util.FileUtils;
import org.mule.util.FilenameUtils;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentService {
    public static final String APP_ANCHOR_SUFFIX = "-anchor.txt";
    protected static final int DEFAULT_CHANGES_CHECK_INTERVAL_MS = 5000;
    protected ScheduledExecutorService appDirMonitorTimer;
    protected final transient Log logger = LogFactory.getLog(this.getClass());
    protected MuleDeployer deployer = new DefaultMuleDeployer();
    private List<Application> applications = new ArrayList<Application>();

    public void start() {
        String[] apps;
        boolean explicitAppSet;
        String[] appAnchors;
        Map<String, Object> options = StartupContext.get().getStartupOptions();
        String appString = (String)options.get("app");
        File appsDir = MuleContainerBootstrapUtils.getMuleAppsDir();
        for (String anchor : appAnchors = appsDir.list((FilenameFilter)new SuffixFileFilter(APP_ANCHOR_SUFFIX))) {
            new File(appsDir, anchor).delete();
        }
        boolean bl = explicitAppSet = appString != null;
        if (!explicitAppSet) {
            String[] zips;
            for (String zip : zips = appsDir.list((FilenameFilter)new SuffixFileFilter(".zip"))) {
                try {
                    this.deployer.installFromAppDir(zip);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            apps = appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
        } else {
            apps = appString.split(":");
        }
        for (String app : apps) {
            ApplicationWrapper a = new ApplicationWrapper(new DefaultMuleApplication(app));
            this.applications.add(a);
        }
        for (Application application : this.applications) {
            try {
                this.deployer.deploy(application);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!explicitAppSet) {
            this.scheduleChangeMonitor(appsDir);
        }
    }

    protected void scheduleChangeMonitor(File appsDir) {
        int reloadIntervalMs = 5000;
        this.appDirMonitorTimer = Executors.newSingleThreadScheduledExecutor(new AppDeployerMonitorThreadFactory());
        this.appDirMonitorTimer.scheduleWithFixedDelay(new AppDirWatcher(appsDir), 0L, 5000L, TimeUnit.MILLISECONDS);
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Application directory check interval: 5000");
        }
    }

    public void stop() {
        if (this.appDirMonitorTimer != null) {
            this.appDirMonitorTimer.shutdownNow();
        }
        Collections.reverse(this.applications);
        for (Application application : this.applications) {
            try {
                application.stop();
                application.dispose();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public List<Application> getApplications() {
        return Collections.unmodifiableList(this.applications);
    }

    public MuleDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(MuleDeployer deployer) {
        this.deployer = deployer;
    }

    protected class AppDirWatcher
    implements Runnable {
        protected File appsDir;
        protected String[] deployedApps;
        protected String[] appAnchors = new String[0];

        public AppDirWatcher(File appsDir) {
            this.appsDir = appsDir;
            this.deployedApps = new String[DeploymentService.this.applications.size()];
            for (int i = 0; i < DeploymentService.this.applications.size(); ++i) {
                this.deployedApps[i] = ((Application)DeploymentService.this.applications.get(i)).getAppName();
            }
        }

        public void run() {
            String[] zips = this.appsDir.list((FilenameFilter)new SuffixFileFilter(".zip"));
            String[] apps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
            String[] currentAnchors = this.appsDir.list((FilenameFilter)new SuffixFileFilter(DeploymentService.APP_ANCHOR_SUFFIX));
            Collection deletedAnchors = CollectionUtils.subtract(Arrays.asList(this.appAnchors), Arrays.asList(currentAnchors));
            for (String deletedAnchor : deletedAnchors) {
                String appName = StringUtils.removeEnd((String)deletedAnchor, (String)DeploymentService.APP_ANCHOR_SUFFIX);
                try {
                    this.onApplicationUndeployRequested(appName);
                }
                catch (Throwable t) {
                    DeploymentService.this.logger.error((Object)("Failed to undeploy application: " + appName), t);
                }
            }
            this.appAnchors = currentAnchors;
            for (String zip : zips) {
                try {
                    String appName = StringUtils.removeEnd((String)zip, (String)".zip");
                    Application app = (Application)CollectionUtils.find((Collection)DeploymentService.this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("appName", (Object)appName));
                    if (app != null) {
                        this.onApplicationUndeployRequested(appName);
                    }
                    this.onNewApplicationArchive(new File(this.appsDir, zip));
                }
                catch (Throwable t) {
                    DeploymentService.this.logger.error((Object)("Failed to deploy application archive: " + zip), t);
                }
            }
            if (zips.length > 0) {
                apps = this.appsDir.list((FilenameFilter)DirectoryFileFilter.DIRECTORY);
                this.deployedApps = apps;
            }
            Collection addedApps = CollectionUtils.subtract(Arrays.asList(apps), Arrays.asList(this.deployedApps));
            for (String addedApp : addedApps) {
                try {
                    this.onNewExplodedApplication(addedApp);
                }
                catch (Throwable t) {
                    DeploymentService.this.logger.error((Object)("Failed to deploy exploded application: " + addedApp), t);
                }
            }
            this.deployedApps = apps;
        }

        protected void onApplicationUndeployRequested(String appName) throws Exception {
            if (DeploymentService.this.logger.isInfoEnabled()) {
                DeploymentService.this.logger.info((Object)("================== Request to Undeploy Application: " + appName));
            }
            Application app = (Application)CollectionUtils.find((Collection)DeploymentService.this.applications, (Predicate)new BeanPropertyValueEqualsPredicate("appName", (Object)appName));
            DeploymentService.this.applications.remove(app);
            DeploymentService.this.deployer.undeploy(app);
        }

        protected void onNewExplodedApplication(String appName) throws Exception {
            if (DeploymentService.this.logger.isInfoEnabled()) {
                DeploymentService.this.logger.info((Object)("================== New Exploded Application: " + appName));
            }
            ApplicationWrapper a = new ApplicationWrapper(new DefaultMuleApplication(appName));
            DeploymentService.this.applications.add(a);
            DeploymentService.this.deployer.deploy(a);
        }

        protected void onNewApplicationArchive(File file) throws Exception {
            if (DeploymentService.this.logger.isInfoEnabled()) {
                DeploymentService.this.logger.info((Object)("================== New Application Archive: " + file));
            }
            String appName = FilenameUtils.getBaseName((String)file.getName());
            FileUtils.deleteTree(new File(this.appsDir, appName));
            Application app = DeploymentService.this.deployer.installFrom(file.toURL());
            DeploymentService.this.applications.add(app);
            DeploymentService.this.deployer.deploy(app);
        }
    }
}

