/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tck;

import java.util.List;
import org.mule.api.DefaultMuleException;
import org.mule.api.MuleException;
import org.mule.api.component.InterfaceBinding;
import org.mule.api.component.JavaComponent;
import org.mule.api.config.ThreadingProfile;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.interceptor.Interceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.routing.filter.Filter;
import org.mule.api.service.Service;
import org.mule.api.transformer.Transformer;
import org.mule.component.AbstractComponent;
import org.mule.component.PooledJavaComponent;
import org.mule.config.PoolingProfile;
import org.mule.config.QueueProfile;
import org.mule.exception.AbstractMessagingExceptionStrategy;
import org.mule.interceptor.InterceptorStack;
import org.mule.interceptor.LoggingInterceptor;
import org.mule.interceptor.TimerInterceptor;
import org.mule.model.seda.SedaService;
import org.mule.routing.IdempotentMessageFilter;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.MessagePropertyFilter;
import org.mule.routing.filters.PayloadTypeFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.filters.logic.AndFilter;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractScriptConfigBuilderTestCase;
import org.mule.tck.testmodels.mule.TestCatchAllStrategy;
import org.mule.tck.testmodels.mule.TestCompressionTransformer;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.tck.testmodels.mule.TestTransactionFactory;
import org.mule.transformer.TransformerUtils;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.AbstractConnector;

public abstract class AbstractConfigBuilderTestCase
extends AbstractScriptConfigBuilderTestCase {
    public AbstractConfigBuilderTestCase(boolean legacy) {
        super(legacy);
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    public void testManagerConfig() throws Exception {
        super.testManagerConfig();
        AbstractConfigBuilderTestCase.assertNotNull((Object)muleContext.getTransactionManager());
    }

    public void testConnectorConfig() throws Exception {
        super.testConnectorConfig();
        MessagingExceptionHandler es = muleContext.getRegistry().lookupModel("main").getExceptionListener();
        AbstractConfigBuilderTestCase.assertNotNull((Object)es);
        AbstractConfigBuilderTestCase.assertTrue((String)es.getClass().getName(), (boolean)(es instanceof TestExceptionStrategy));
    }

    public void testGlobalEndpointConfig() throws MuleException {
        super.testGlobalEndpointConfig();
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("fruitBowlEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)endpoint.getEndpointURI().getAddress(), (String)"fruitBowlPublishQ");
        MessagePropertyFilter filter = (MessagePropertyFilter)endpoint.getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractConfigBuilderTestCase.assertEquals((String)"foo=bar", (String)filter.getPattern());
    }

    public void testEndpointConfig() throws MuleException {
        super.testEndpointConfig();
        InboundEndpoint endpoint = muleContext.getRegistry().lookupEndpointFactory().getInboundEndpoint("waterMelonEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)endpoint);
        AbstractConfigBuilderTestCase.assertEquals((String)"UTF-8-TEST", (String)endpoint.getEncoding());
        AbstractConfigBuilderTestCase.assertEquals((String)"test.queue", (String)endpoint.getEndpointURI().getAddress());
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        AbstractConfigBuilderTestCase.assertNotNull((Object)service);
    }

    public void testExceptionStrategy2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)service.getExceptionListener());
        AbstractConfigBuilderTestCase.assertTrue((boolean)AbstractMessagingExceptionStrategy.class.isAssignableFrom(service.getExceptionListener().getClass()));
    }

    public void testTransformerConfig() {
        super.testTransformerConfig();
        Transformer t = muleContext.getRegistry().lookupTransformer("TestCompressionTransformer");
        AbstractConfigBuilderTestCase.assertNotNull((Object)t);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(t instanceof TestCompressionTransformer));
        AbstractConfigBuilderTestCase.assertEquals((Object)t.getReturnDataType(), (Object)DataTypeFactory.STRING);
        AbstractConfigBuilderTestCase.assertNotNull((Object)((TestCompressionTransformer)t).getContainerProperty());
    }

    public void testModelConfig() throws Exception {
        super.testModelConfig();
        AbstractConfigBuilderTestCase.assertNotNull((Object)muleContext.getRegistry().lookupService("appleComponent"));
        AbstractConfigBuilderTestCase.assertNotNull((Object)muleContext.getRegistry().lookupService("appleComponent2"));
    }

    public void testOutboundRouterConfig2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)service.getOutboundMessageProcessor());
        OutboundRouterCollection router = (OutboundRouterCollection)service.getOutboundMessageProcessor();
        AbstractConfigBuilderTestCase.assertNotNull((Object)router.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)router.getRoutes().size());
        OutboundRouter route1 = (OutboundRouter)router.getRoutes().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route1 instanceof FilteringOutboundRouter));
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)route1.getRoutes().size());
        ImmutableEndpoint ep = (ImmutableEndpoint)route1.getRoutes().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)ep.getTransformers());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(TransformerUtils.firstOrNull((List)ep.getTransformers()) instanceof TestCompressionTransformer));
        Filter filter = ((FilteringOutboundRouter)route1).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals(String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        OutboundRouter route2 = (OutboundRouter)router.getRoutes().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(route2 instanceof FilteringOutboundRouter));
        Filter filter2 = ((FilteringOutboundRouter)route2).getFilter();
        AbstractConfigBuilderTestCase.assertNotNull((Object)filter2);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter2 instanceof AndFilter));
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)((AndFilter)filter2).getFilters().size());
        Filter left = (Filter)((AndFilter)filter2).getFilters().get(0);
        Filter right = (Filter)((AndFilter)filter2).getFilters().get(1);
        AbstractConfigBuilderTestCase.assertNotNull((Object)left);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(left instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"the quick brown (.*)", (String)((RegExFilter)left).getPattern());
        AbstractConfigBuilderTestCase.assertNotNull((Object)right);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(right instanceof RegExFilter));
        AbstractConfigBuilderTestCase.assertEquals((String)"(.*) brown (.*)", (String)((RegExFilter)right).getPattern());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router.getCatchAllStrategy() instanceof TestCatchAllStrategy));
    }

    public void testInboundRouterConfig2() {
        Service service = muleContext.getRegistry().lookupService("appleComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)service.getMessageSource());
        ServiceCompositeMessageSource messageRouter = (ServiceCompositeMessageSource)service.getMessageSource();
        AbstractConfigBuilderTestCase.assertNotNull((Object)messageRouter.getCatchAllStrategy());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)messageRouter.getMessageProcessors().size());
        MessageProcessor router = (MessageProcessor)messageRouter.getMessageProcessors().get(0);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router instanceof MessageFilter));
        MessageFilter sc = (MessageFilter)router;
        AbstractConfigBuilderTestCase.assertNotNull((Object)sc.getFilter());
        Filter filter = sc.getFilter();
        AbstractConfigBuilderTestCase.assertTrue((boolean)(filter instanceof PayloadTypeFilter));
        AbstractConfigBuilderTestCase.assertEquals(String.class, (Object)((PayloadTypeFilter)filter).getExpectedType());
        MessageProcessor router2 = (MessageProcessor)messageRouter.getMessageProcessors().get(1);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(router2 instanceof IdempotentMessageFilter));
    }

    public void testThreadingConfig() throws DefaultMuleException {
        int defaultMaxBufferSize = 42;
        int defaultMaxThreadsActive = 16;
        int defaultMaxThreadsIdle = 3;
        int defaultThreadPoolExhaustedAction = 0;
        int defaultThreadTTL = 60001;
        int connectorMaxBufferSize = 2;
        int componentMaxBufferSize = 6;
        int componentMaxThreadsActive = 12;
        int componentMaxThreadsIdle = 6;
        int componentThreadPoolExhaustedAction = 1;
        ThreadingProfile tp = muleContext.getDefaultThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        tp = muleContext.getDefaultServiceThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        AbstractConnector c = (AbstractConnector)muleContext.getRegistry().lookupConnector("dummyConnector");
        tp = c.getDispatcherThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)connectorMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)defaultThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        AbstractConfigBuilderTestCase.assertTrue((String)"service must be SedaService to get threading profile", (boolean)(service instanceof SedaService));
        tp = ((SedaService)service).getThreadingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxBufferSize, (int)tp.getMaxBufferSize());
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxThreadsActive, (int)tp.getMaxThreadsActive());
        AbstractConfigBuilderTestCase.assertEquals((int)componentMaxThreadsIdle, (int)tp.getMaxThreadsIdle());
        AbstractConfigBuilderTestCase.assertEquals((int)componentThreadPoolExhaustedAction, (int)tp.getPoolExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((long)defaultThreadTTL, (long)tp.getThreadTTL());
    }

    public void testPoolingConfig() {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        PoolingProfile pp = ((PooledJavaComponent)service.getComponent()).getPoolingProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)9, (int)pp.getMaxActive());
        AbstractConfigBuilderTestCase.assertEquals((int)6, (int)pp.getMaxIdle());
        AbstractConfigBuilderTestCase.assertEquals((long)4002L, (long)pp.getMaxWait());
        AbstractConfigBuilderTestCase.assertEquals((int)0, (int)pp.getExhaustedAction());
        AbstractConfigBuilderTestCase.assertEquals((int)2, (int)pp.getInitialisationPolicy());
    }

    public void testQueueProfileConfig() {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        QueueProfile qp = ((SedaService)service).getQueueProfile();
        AbstractConfigBuilderTestCase.assertEquals((int)102, (int)qp.getMaxOutstandingMessages());
        AbstractConfigBuilderTestCase.assertTrue((boolean)qp.isPersistent());
    }

    public void testEndpointProperties() throws Exception {
        Service service = muleContext.getRegistry().lookupService("appleComponent2");
        InboundEndpoint inEndpoint = ((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getProperties());
        AbstractConfigBuilderTestCase.assertEquals((Object)"Prop1", inEndpoint.getProperties().get("testEndpointProperty"));
    }

    public void testTransactionConfig() throws Exception {
        Service apple = muleContext.getRegistry().lookupService("appleComponent2");
        InboundEndpoint inEndpoint = ((ServiceCompositeMessageSource)apple.getMessageSource()).getEndpoint("transactedInboundEndpoint");
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint);
        AbstractConfigBuilderTestCase.assertEquals((int)1, (int)((OutboundRouterCollection)apple.getOutboundMessageProcessor()).getRoutes().size());
        AbstractConfigBuilderTestCase.assertNotNull((Object)inEndpoint.getTransactionConfig());
        AbstractConfigBuilderTestCase.assertEquals((byte)1, (byte)inEndpoint.getTransactionConfig().getAction());
        AbstractConfigBuilderTestCase.assertTrue((boolean)(inEndpoint.getTransactionConfig().getFactory() instanceof TestTransactionFactory));
        AbstractConfigBuilderTestCase.assertNull((Object)inEndpoint.getTransactionConfig().getConstraint());
        OutboundRouter outRouter = (OutboundRouter)((OutboundRouterCollection)apple.getOutboundMessageProcessor()).getRoutes().get(0);
        MessageProcessor outEndpoint = (MessageProcessor)outRouter.getRoutes().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)outEndpoint);
    }

    public void testEnvironmentProperties() {
        AbstractConfigBuilderTestCase.assertEquals((Object)"true", (Object)muleContext.getRegistry().lookupObject("doCompression"));
        AbstractConfigBuilderTestCase.assertEquals((Object)"this was set from the manager properties!", (Object)muleContext.getRegistry().lookupObject("beanProperty1"));
        AbstractConfigBuilderTestCase.assertNotNull((Object)muleContext.getRegistry().lookupObject("OS_Version"));
    }

    public void testBindngProxyCreation() {
        Service orange = muleContext.getRegistry().lookupService("orangeComponent");
        AbstractConfigBuilderTestCase.assertNotNull((Object)orange);
        AbstractConfigBuilderTestCase.assertTrue((boolean)(orange.getComponent() instanceof JavaComponent));
        InterfaceBinding r = (InterfaceBinding)((JavaComponent)orange.getComponent()).getInterfaceBindings().get(0);
        AbstractConfigBuilderTestCase.assertNotNull((Object)r);
    }

    public void testMuleConfiguration() {
        AbstractConfigBuilderTestCase.assertEquals((int)10, (int)muleContext.getConfiguration().getDefaultResponseTimeout());
        AbstractConfigBuilderTestCase.assertEquals((int)20, (int)muleContext.getConfiguration().getDefaultTransactionTimeout());
        AbstractConfigBuilderTestCase.assertEquals((int)30, (int)muleContext.getConfiguration().getShutdownTimeout());
    }

    public void testGlobalInterceptorStack() {
        InterceptorStack interceptorStack = (InterceptorStack)muleContext.getRegistry().lookupObject("testInterceptorStack");
        AbstractConfigBuilderTestCase.assertNotNull((Object)interceptorStack);
        AbstractConfigBuilderTestCase.assertEquals((int)3, (int)interceptorStack.getInterceptors().size());
        AbstractConfigBuilderTestCase.assertEquals(LoggingInterceptor.class, ((Interceptor)interceptorStack.getInterceptors().get(0)).getClass());
        AbstractConfigBuilderTestCase.assertEquals(TimerInterceptor.class, ((Interceptor)interceptorStack.getInterceptors().get(1)).getClass());
        AbstractConfigBuilderTestCase.assertEquals(LoggingInterceptor.class, ((Interceptor)interceptorStack.getInterceptors().get(2)).getClass());
    }

    public void testInterceptors() {
        Service service = muleContext.getRegistry().lookupService("orangeComponent");
        InterceptorStack globalInterceptorStack = (InterceptorStack)muleContext.getRegistry().lookupObject("testInterceptorStack");
        AbstractComponent component = (AbstractComponent)service.getComponent();
        AbstractConfigBuilderTestCase.assertEquals((int)3, (int)component.getInterceptors().size());
        AbstractConfigBuilderTestCase.assertEquals(LoggingInterceptor.class, ((Interceptor)component.getInterceptors().get(0)).getClass());
        AbstractConfigBuilderTestCase.assertEquals((Object)globalInterceptorStack, component.getInterceptors().get(1));
        AbstractConfigBuilderTestCase.assertEquals(TimerInterceptor.class, ((Interceptor)component.getInterceptors().get(2)).getClass());
    }
}

