/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message.stream;

import cryptix.message.stream.DecodedMessageInputStreamSpi;
import cryptix.message.stream.DecryptionKeyCallback;
import cryptix.message.stream.MessageStreamException;
import cryptix.message.stream.Support;
import cryptix.message.stream.VerificationKeyCallback;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;

public final class DecodedMessageInputStream
extends InputStream {
    public static final int VERIFICATION_NOT_SIGNED = 1;
    public static final int VERIFICATION_GOOD_SIGNATURE = 2;
    public static final int VERIFICATION_BAD_SIGNATURE = 3;
    public static final int INTEGRITY_NOT_PROTECTED = 1;
    public static final int INTEGRITY_GOOD = 2;
    public static final int INTEGRITY_VIOLATED = 3;
    protected final DecodedMessageInputStreamSpi spi;
    private final Provider provider;
    private final String format;

    protected DecodedMessageInputStream(DecodedMessageInputStreamSpi spi, Provider provider, String format) {
        this.spi = spi;
        this.provider = provider;
        this.format = format;
    }

    public final void close() throws IOException {
        this.spi.engineClose();
    }

    public final String getFormat() {
        return this.format;
    }

    public static DecodedMessageInputStream getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("DecodedMessageInputStream", format);
        return new DecodedMessageInputStream((DecodedMessageInputStreamSpi)o[0], (Provider)o[1], format);
    }

    public static DecodedMessageInputStream getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("DecodedMessageInputStream", format, provider);
        return new DecodedMessageInputStream((DecodedMessageInputStreamSpi)o[0], (Provider)o[1], format);
    }

    public static DecodedMessageInputStream getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("DecodedMessageInputStream", format, provider);
        return new DecodedMessageInputStream((DecodedMessageInputStreamSpi)o[0], (Provider)o[1], format);
    }

    public final int getIntegrityResult() throws IllegalStateException {
        return this.spi.engineGetIntegrityResult();
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final int getVerificationResult() throws IllegalStateException {
        return this.spi.engineGetVerificationResult();
    }

    public final void init(InputStream in, DecryptionKeyCallback dkc, VerificationKeyCallback vkc) throws IllegalStateException, IOException, MessageStreamException {
        this.spi.engineInit(in, dkc, vkc);
    }

    public final int read() throws IOException {
        return this.spi.engineRead();
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.spi.engineRead(b, off, len);
    }
}

