/*
 * Decompiled with CFR 0.152.
 */
package cryptix.message.stream;

import cryptix.message.stream.EncryptedMessageOutputStreamSpi;
import cryptix.message.stream.MessageOutputStream;
import cryptix.message.stream.MessageOutputStreamSpi;
import cryptix.message.stream.MessageStreamException;
import cryptix.message.stream.Support;
import cryptix.pki.KeyBundle;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import javax.crypto.SecretKey;

public final class EncryptedMessageOutputStream
extends MessageOutputStream {
    protected EncryptedMessageOutputStream(MessageOutputStreamSpi spi, Provider provider, String format) {
        super(spi, provider, format);
    }

    public final void addRecipient(KeyBundle bundle) throws IllegalStateException, UnsupportedOperationException, IOException, MessageStreamException {
        ((EncryptedMessageOutputStreamSpi)this.spi).engineAddRecipient(bundle);
    }

    public final void addRecipient(String passphrase) throws IllegalStateException, UnsupportedOperationException, IOException, MessageStreamException {
        ((EncryptedMessageOutputStreamSpi)this.spi).engineAddRecipient(passphrase);
    }

    public final void addRecipient(PublicKey publickey) throws IllegalStateException, UnsupportedOperationException, IOException, MessageStreamException {
        ((EncryptedMessageOutputStreamSpi)this.spi).engineAddRecipient(publickey);
    }

    public final void addRecipient(SecretKey symmetrickey) throws IllegalStateException, UnsupportedOperationException, IOException, MessageStreamException {
        ((EncryptedMessageOutputStreamSpi)this.spi).engineAddRecipient(symmetrickey);
    }

    public static EncryptedMessageOutputStream getInstance(String format) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("EncryptedMessageOutputStream", format);
        return new EncryptedMessageOutputStream((EncryptedMessageOutputStreamSpi)o[0], (Provider)o[1], format);
    }

    public static EncryptedMessageOutputStream getInstance(String format, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Object[] o = Support.getImplementation("EncryptedMessageOutputStream", format, provider);
        return new EncryptedMessageOutputStream((EncryptedMessageOutputStreamSpi)o[0], (Provider)o[1], format);
    }

    public static EncryptedMessageOutputStream getInstance(String format, Provider provider) throws NoSuchAlgorithmException {
        Object[] o = Support.getImplementation("EncryptedMessageOutputStream", format, provider);
        return new EncryptedMessageOutputStream((EncryptedMessageOutputStreamSpi)o[0], (Provider)o[1], format);
    }
}

