/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.i18n;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.mule.config.i18n.Message;
import org.mule.config.i18n.MessageFactory;
import org.mule.util.StringUtils;

public class AnnotationsMessages
extends MessageFactory {
    private static final String BUNDLE_PATH = AnnotationsMessages.getBundlePath("annotations");
    private static final AnnotationsMessages factory = new AnnotationsMessages();

    public static Message serviceDoesNotHaveAnnotation(Class serviceClass, String annotationName) {
        return factory.createMessage(BUNDLE_PATH, 1, (Object)serviceClass.getName(), (Object)annotationName);
    }

    public static Message serviceHasNoEntrypoint(Class serviceClass) {
        return factory.createMessage(BUNDLE_PATH, 2, (Object)serviceClass.getName());
    }

    public static Message noParserFoundForAnnotation(Annotation annotation) {
        return factory.createMessage(BUNDLE_PATH, 3, (Object)annotation);
    }

    public static Message noPropertyConverterForType(Class type) {
        return factory.createMessage(BUNDLE_PATH, 4, (Object)type);
    }

    public static Message failedToInvokeReplyMethod(String method) {
        return factory.createMessage(BUNDLE_PATH, 5, (Object)method);
    }

    public static Message transformerMethodNotValid(Method method) {
        return factory.createMessage(BUNDLE_PATH, 6, (Object)method);
    }

    public static Message lookupNotFoundInRegistry(Class type, String name, Class object) {
        return factory.createMessage(BUNDLE_PATH, 7, (Object)type, (Object)(StringUtils.isBlank((String)name) ? "[no name]" : name), (Object)object);
    }

    public static Message lookupFailedSeePreviousException(Object object) {
        return factory.createMessage(BUNDLE_PATH, 8, object);
    }
}

