/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl.model.resolvers;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.lang.reflect.Method;
import java.util.Map;
import net.sf.cglib.proxy.Enhancer;
import org.mule.api.MuleEventContext;
import org.mule.api.annotations.meta.Evaluator;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.model.InvocationResult;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.PropertyScope;
import org.mule.config.expression.ExpressionAnnotationsHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.expression.transformers.ExpressionTransformer;
import org.mule.model.resolvers.AbstractEntryPointResolver;
import org.mule.transport.NullPayload;
import org.mule.util.ClassUtils;
import org.mule.util.annotation.AnnotationUtils;

public class AnnotatedEntryPointResolver
extends AbstractEntryPointResolver {
    private AtomicBoolean cacheBuilt = new AtomicBoolean(false);
    private Map<Method, Transformer> transformerCache = new ConcurrentHashMap();

    public InvocationResult invoke(Object component, MuleEventContext context) throws Exception {
        Object[] payload;
        try {
            this.initCache(component, context);
        }
        catch (Exception e) {
            InvocationResult result = new InvocationResult(this, InvocationResult.State.NOT_SUPPORTED);
            result.setErrorMessage(e.toString());
            return result;
        }
        if (this.methodCache.size() == 0) {
            InvocationResult result = new InvocationResult(this, InvocationResult.State.NOT_SUPPORTED);
            result.setErrorMessage("Component: " + component + " doesn't have any annotated methods, skipping.");
            return result;
        }
        Method method = null;
        Object tempMethod = context.getMessage().removeProperty("method", PropertyScope.INVOCATION);
        String methodName = null;
        if (tempMethod != null && tempMethod instanceof Method) {
            method = (Method)tempMethod;
        } else {
            methodName = (String)tempMethod;
        }
        if (methodName != null) {
            method = this.getMethodByName(methodName, context);
            if (method == null) {
                InvocationResult result = new InvocationResult(this, InvocationResult.State.NOT_SUPPORTED);
                result.setErrorMessage("Method not found: " + methodName + " on object: " + component.getClass() + ". If the component is a proxy there needs to be an interface on the proxy that defines this method");
                return result;
            }
            payload = this.getPayloadForMethod(method, component, context);
        } else if (method != null) {
            payload = this.getPayloadForMethod(method, component, context);
        } else if (this.methodCache.size() == 1) {
            method = (Method)this.methodCache.values().iterator().next();
            payload = this.getPayloadForMethod(method, component, context);
        } else {
            InvocationResult result = new InvocationResult(this, InvocationResult.State.FAILED);
            result.setErrorMessage("Component: " + component + " has more than one method annotated, which means the target method name needs to be set on the event");
            return result;
        }
        return this.invokeMethod(component, method, method.getParameterTypes().length == 0 ? ClassUtils.NO_ARGS : payload);
    }

    protected Object[] getPayloadForMethod(Method method, Object component, MuleEventContext context) throws TransformerException, InitialisationException {
        Object[] payload = null;
        Method m = method;
        if (Enhancer.isEnhanced(component.getClass())) {
            try {
                m = component.getClass().getSuperclass().getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new TransformerException(CoreMessages.createStaticMessage(e.getMessage()), (Throwable)e);
            }
        }
        if (AnnotationUtils.getParamAnnotationsWithMeta(m, Evaluator.class).size() > 0) {
            payload = this.getPayloadFromMessageWithAnnotations(m, context);
        }
        return payload;
    }

    protected Object[] getPayloadFromMessageWithAnnotations(Method method, MuleEventContext context) throws TransformerException, InitialisationException {
        Object o;
        ExpressionTransformer trans = (ExpressionTransformer)this.transformerCache.get(method);
        if (trans == null) {
            trans = ExpressionAnnotationsHelper.getTransformerForMethodWithAnnotations(method, context.getMuleContext());
            this.transformerCache.put(method, trans);
        }
        if ((o = trans.transform(context.getMessage())) instanceof NullPayload) {
            return new Object[]{null};
        }
        if (o.getClass().isArray()) {
            return (Object[])o;
        }
        return new Object[]{o};
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("AnnotatedEntryPointResolver");
        sb.append(", acceptVoidMethods=").append(this.isAcceptVoidMethods());
        sb.append('}');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCache(Object component, MuleEventContext context) {
        if (!this.cacheBuilt.get()) {
            AnnotatedEntryPointResolver annotatedEntryPointResolver = this;
            synchronized (annotatedEntryPointResolver) {
                try {
                    if (!this.cacheBuilt.get()) {
                        for (int i = 0; i < component.getClass().getMethods().length; ++i) {
                            Method method = component.getClass().getMethods()[i];
                            if (AnnotationUtils.getParamAnnotationsWithMeta(method, Evaluator.class).size() <= 0) continue;
                            this.addMethodByName(method, context);
                        }
                    }
                }
                finally {
                    this.cacheBuilt.set(true);
                }
            }
        }
    }
}

