/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.tcp.protocols;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.mule.DefaultMuleMessage;
import org.mule.RequestContext;
import org.mule.api.MuleException;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.transformer.wire.SerializedMuleMessageWireFormat;

class MuleMessageWorker {
    private static WireFormat wireFormat = new SerializedMuleMessageWireFormat();

    private MuleMessageWorker() {
    }

    public static byte[] doWrite() throws IOException {
        DefaultMuleMessage msg = (DefaultMuleMessage)RequestContext.getEvent().getMessage();
        wireFormat.setMuleContext(RequestContext.getEvent().getMuleContext());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            wireFormat.write(baos, msg, msg.getEncoding());
        }
        catch (MuleException e) {
            throw new IOException(e.getDetailedMessage());
        }
        return baos.toByteArray();
    }

    public static Object doRead(Object message) throws IOException {
        if (message == null) {
            return null;
        }
        InputStream in = message instanceof byte[] ? new ByteArrayInputStream((byte[])message) : (InputStream)message;
        try {
            return wireFormat.read(in);
        }
        catch (MuleException e) {
            throw new IOException(e.getDetailedMessage());
        }
    }
}

