/*
 * Decompiled with CFR 0.152.
 */
package org.mule.context.notification;

import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationHandler;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.Event1;
import org.mule.context.notification.Event2;
import org.mule.context.notification.Event3;
import org.mule.context.notification.Listener1;
import org.mule.context.notification.Listener2;
import org.mule.context.notification.OptimisedNotificationHandler;
import org.mule.context.notification.Policy;
import org.mule.context.notification.ServerNotificationManager;
import org.mule.context.notification.SubEvent1;
import org.mule.context.notification.SubEvent2;
import org.mule.context.notification.SubSubEvent1;
import org.mule.tck.AbstractMuleTestCase;

public class NotificationManagerTestCase
extends AbstractMuleTestCase {
    protected Listener1 listener1;
    protected Listener2 listener2;
    protected ServerNotificationManager manager;

    protected void doSetUp() throws Exception {
        this.listener1 = new Listener1();
        this.listener2 = new Listener2();
        this.manager = new ServerNotificationManager();
    }

    protected void registerDefaultEvents() throws ClassNotFoundException {
        this.manager.addInterfaceToType(Listener1.class, SubEvent1.class);
        this.manager.addInterfaceToType(Listener2.class, Event2.class);
    }

    public void testNoListenersMeansNoEvents() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.assertNoEventsEnabled();
    }

    protected void assertNoEventsEnabled() {
        NotificationManagerTestCase.assertFalse((boolean)this.manager.isNotificationEnabled(Event1.class));
        NotificationManagerTestCase.assertFalse((boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        NotificationManagerTestCase.assertFalse((boolean)this.manager.isNotificationEnabled(SubSubEvent1.class));
        NotificationManagerTestCase.assertFalse((boolean)this.manager.isNotificationEnabled(Event2.class));
        NotificationManagerTestCase.assertFalse((boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        NotificationManagerTestCase.assertFalse((boolean)this.manager.isNotificationEnabled(Event3.class));
    }

    protected void registerDefaultListeners() {
        this.manager.addListenerSubscription((ServerNotificationListener)this.listener1, "id1");
        this.manager.addListener((ServerNotificationListener)this.listener2);
    }

    public void testAssociationOfInterfacesAndEvents() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.assertStandardEventsEnabled();
    }

    protected void assertStandardEventsEnabled() {
        NotificationManagerTestCase.assertTrue((String)"via subclass", (boolean)this.manager.isNotificationEnabled(Event1.class));
        NotificationManagerTestCase.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        NotificationManagerTestCase.assertTrue((String)"via superclass", (boolean)this.manager.isNotificationEnabled(SubSubEvent1.class));
        NotificationManagerTestCase.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(Event2.class));
        NotificationManagerTestCase.assertTrue((String)"via superclass", (boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        NotificationManagerTestCase.assertFalse((String)"not specified at all", (boolean)this.manager.isNotificationEnabled(Event3.class));
    }

    public void testDynamicResponseToDisablingEvents() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.assertStandardEventsEnabled();
        this.manager.disableType(Event2.class);
        NotificationManagerTestCase.assertTrue((String)"via subclass", (boolean)this.manager.isNotificationEnabled(Event1.class));
        NotificationManagerTestCase.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        NotificationManagerTestCase.assertFalse((String)"disabled", (boolean)this.manager.isNotificationEnabled(Event2.class));
        NotificationManagerTestCase.assertFalse((String)"no listener", (boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        NotificationManagerTestCase.assertFalse((String)"not specified at all", (boolean)this.manager.isNotificationEnabled(Event3.class));
        this.manager.addInterfaceToType(Listener2.class, SubEvent2.class);
        NotificationManagerTestCase.assertTrue((String)"via subclass", (boolean)this.manager.isNotificationEnabled(Event1.class));
        NotificationManagerTestCase.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        NotificationManagerTestCase.assertFalse((String)"disabled", (boolean)this.manager.isNotificationEnabled(Event2.class));
        NotificationManagerTestCase.assertFalse((String)"disabled", (boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        NotificationManagerTestCase.assertFalse((String)"not specified at all", (boolean)this.manager.isNotificationEnabled(Event3.class));
    }

    public void testDynamicResponseToDisablingInterfaces() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.assertStandardEventsEnabled();
        this.manager.disableInterface(Listener1.class);
        NotificationManagerTestCase.assertFalse((String)"via subclass, but no listener", (boolean)this.manager.isNotificationEnabled(Event1.class));
        NotificationManagerTestCase.assertFalse((String)"disabled", (boolean)this.manager.isNotificationEnabled(SubEvent1.class));
        NotificationManagerTestCase.assertFalse((String)"via superclass, but no listener", (boolean)this.manager.isNotificationEnabled(SubSubEvent1.class));
        NotificationManagerTestCase.assertTrue((String)"direct", (boolean)this.manager.isNotificationEnabled(Event2.class));
        NotificationManagerTestCase.assertTrue((String)"via superclass", (boolean)this.manager.isNotificationEnabled(SubEvent2.class));
        NotificationManagerTestCase.assertFalse((String)"not specified at all", (boolean)this.manager.isNotificationEnabled(Event3.class));
    }

    public void testPolicyCaching() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        Policy policy = this.manager.getPolicy();
        this.assertStandardEventsEnabled();
        NotificationManagerTestCase.assertSame((Object)policy, (Object)this.manager.getPolicy());
        this.manager.disableType(Event2.class);
        NotificationManagerTestCase.assertNotSame((Object)policy, (Object)this.manager.getPolicy());
    }

    public void testDynamicManagerDecisions() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.manager.setNotificationDynamic(true);
        OptimisedNotificationHandler decision = new OptimisedNotificationHandler((ServerNotificationHandler)this.manager, Event2.class);
        NotificationManagerTestCase.assertTrue((boolean)decision.isNotificationEnabled(Event2.class));
        this.manager.disableType(Event2.class);
        NotificationManagerTestCase.assertFalse((boolean)decision.isNotificationEnabled(Event2.class));
    }

    public void testNonDynamicManagerDecisions() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        OptimisedNotificationHandler decision = new OptimisedNotificationHandler((ServerNotificationHandler)this.manager, Event2.class);
        NotificationManagerTestCase.assertTrue((boolean)decision.isNotificationEnabled(Event2.class));
        this.manager.disableType(Event2.class);
        NotificationManagerTestCase.assertTrue((boolean)decision.isNotificationEnabled(Event2.class));
    }

    public void testNotification() throws ClassNotFoundException {
        this.registerDefaultEvents();
        this.registerDefaultListeners();
        this.assertNoListenersNotified();
        this.manager.notifyListeners((ServerNotification)new Event1());
        this.assertNoListenersNotified();
        this.manager.notifyListeners((ServerNotification)new SubEvent1());
        this.assertNoListenersNotified();
        this.manager.notifyListeners((ServerNotification)new Event1("id1"));
        this.assertNoListenersNotified();
        this.manager.notifyListeners((ServerNotification)new SubSubEvent1("id1"));
        NotificationManagerTestCase.assertTrue((boolean)this.listener1.isNotified());
        NotificationManagerTestCase.assertFalse((boolean)this.listener2.isNotified());
        this.manager.notifyListeners((ServerNotification)new Event2());
        NotificationManagerTestCase.assertTrue((boolean)this.listener1.isNotified());
        NotificationManagerTestCase.assertTrue((boolean)this.listener2.isNotified());
    }

    protected void assertNoListenersNotified() {
        NotificationManagerTestCase.assertFalse((boolean)this.listener1.isNotified());
        NotificationManagerTestCase.assertFalse((boolean)this.listener2.isNotified());
    }
}

