/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.Collections;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleException;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.testmodels.mule.TestConnector;
import org.mule.transaction.MuleTransactionConfig;
import org.mule.transformer.simple.StringAppendTransformer;
import org.mule.util.ObjectNameHelper;

public class EndpointURIEndpointBuilderTestCase
extends AbstractMuleTestCase {
    public void testBuildInboundEndpoint() throws Exception {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        InboundEndpoint ep = endpointBuilder.buildInboundEndpoint();
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep instanceof InboundEndpoint));
        EndpointURIEndpointBuilderTestCase.assertFalse((boolean)(ep instanceof OutboundEndpoint));
        EndpointURIEndpointBuilderTestCase.assertNotNull((Object)ep.getTransformers());
        EndpointURIEndpointBuilderTestCase.assertEquals((int)0, (int)ep.getTransformers().size());
        EndpointURIEndpointBuilderTestCase.assertNotNull((Object)ep.getResponseTransformers());
        EndpointURIEndpointBuilderTestCase.assertEquals((int)0, (int)ep.getResponseTransformers().size());
        this.testDefaultCommonEndpointAttributes((ImmutableEndpoint)ep);
    }

    public void testBuildOutboundEndpoint() throws MuleException {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        OutboundEndpoint ep = endpointBuilder.buildOutboundEndpoint();
        EndpointURIEndpointBuilderTestCase.assertFalse((boolean)(ep instanceof InboundEndpoint));
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep instanceof OutboundEndpoint));
        EndpointURIEndpointBuilderTestCase.assertEquals((int)0, (int)ep.getTransformers().size());
        EndpointURIEndpointBuilderTestCase.assertNotNull((Object)ep.getResponseTransformers());
        EndpointURIEndpointBuilderTestCase.assertEquals((int)0, (int)ep.getResponseTransformers().size());
        this.testDefaultCommonEndpointAttributes((ImmutableEndpoint)ep);
    }

    protected void testDefaultCommonEndpointAttributes(ImmutableEndpoint ep) {
        EndpointURIEndpointBuilderTestCase.assertEquals((String)ep.getEndpointURI().getUri().toString(), (String)"test://address");
        EndpointURIEndpointBuilderTestCase.assertEquals((int)muleContext.getConfiguration().getDefaultResponseTimeout(), (int)ep.getResponseTimeout());
        EndpointURIEndpointBuilderTestCase.assertTrue((String)("ep.getRetryPolicyTemplate() = " + ep.getRetryPolicyTemplate().getClass()), (boolean)(ep.getRetryPolicyTemplate() instanceof NoRetryPolicyTemplate));
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getTransactionConfig() instanceof MuleTransactionConfig));
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getTransactionConfig() instanceof MuleTransactionConfig));
        EndpointURIEndpointBuilderTestCase.assertEquals(null, (Object)ep.getSecurityFilter());
        EndpointURIEndpointBuilderTestCase.assertTrue((boolean)(ep.getConnector() instanceof TestConnector));
        EndpointURIEndpointBuilderTestCase.assertEquals((String)new ObjectNameHelper(muleContext).getEndpointName(ep.getEndpointURI()), (String)ep.getName());
        EndpointURIEndpointBuilderTestCase.assertFalse((boolean)ep.isDeleteUnacceptedMessages());
        EndpointURIEndpointBuilderTestCase.assertEquals((String)muleContext.getConfiguration().getDefaultEncoding(), (String)ep.getEncoding());
        EndpointURIEndpointBuilderTestCase.assertEquals(null, (Object)ep.getFilter());
        EndpointURIEndpointBuilderTestCase.assertEquals((String)"started", (String)ep.getInitialState());
    }

    public void testHasSetEncodingMethod() throws Exception {
        String uri = "test://address";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        EndpointURIEndpointBuilderTestCase.assertNotNull((Object)endpointBuilder.getClass().getMethod("setEncoding", String.class));
    }

    public void testEndpointBuilderFromEndpoint() throws Exception {
        String uri = "test://address";
        InboundEndpoint endpoint = EndpointURIEndpointBuilderTestCase.getTestInboundEndpoint("endpoint.test.address", uri);
        SensingEndpointURIEndpointBuilder builder = new SensingEndpointURIEndpointBuilder((ImmutableEndpoint)endpoint);
        EndpointURIEndpointBuilderTestCase.assertEquals((String)uri, (String)builder.getEndpointBuilder().getEndpoint().getUri().toString());
        EndpointURIEndpointBuilderTestCase.assertEquals((Object)endpoint.getConnector(), (Object)builder.getConnector());
        EndpointURIEndpointBuilderTestCase.assertEquals((Object)endpoint.getProperties(), (Object)builder.getProperties());
        EndpointURIEndpointBuilderTestCase.assertEquals((Object)endpoint.getTransactionConfig(), (Object)builder.getTransactionConfig());
        EndpointURIEndpointBuilderTestCase.assertEquals((boolean)endpoint.isDeleteUnacceptedMessages(), (boolean)builder.getDeleteUnacceptedMessages(builder.getConnector()));
        EndpointURIEndpointBuilderTestCase.assertEquals((String)endpoint.getInitialState(), (String)builder.getInitialState(builder.getConnector()));
        EndpointURIEndpointBuilderTestCase.assertEquals((int)endpoint.getResponseTimeout(), (int)builder.getResponseTimeout(builder.getConnector()));
        EndpointURIEndpointBuilderTestCase.assertEquals((Object)endpoint.getSecurityFilter(), (Object)builder.getSecurityFilter());
        EndpointURIEndpointBuilderTestCase.assertEquals((Object)endpoint.getRetryPolicyTemplate(), (Object)builder.getRetryPolicyTemplate(builder.getConnector()));
        EndpointURIEndpointBuilderTestCase.assertEquals((Object)MessageExchangePattern.ONE_WAY, (Object)builder.getExchangePattern());
    }

    public void testEndpointBuilderTransformersState() throws Exception {
        muleContext.getRegistry().registerObject("tran1", (Object)new StringAppendTransformer("1"));
        muleContext.getRegistry().registerObject("tran2", (Object)new StringAppendTransformer("2"));
        String uri = "test://address?transformers=tran1&responseTransformers=tran2";
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder(uri, muleContext);
        endpointBuilder.setTransformers(Collections.singletonList(new StringAppendTransformer("3")));
        endpointBuilder.setResponseTransformers(Collections.singletonList(new StringAppendTransformer("4")));
        InboundEndpoint endpoint = endpointBuilder.buildInboundEndpoint();
        EndpointURIEndpointBuilderTestCase.assertEquals((int)2, (int)endpoint.getMessageProcessors().size());
        EndpointURIEndpointBuilderTestCase.assertEquals((int)2, (int)endpoint.getResponseMessageProcessors().size());
        endpoint = endpointBuilder.buildInboundEndpoint();
        EndpointURIEndpointBuilderTestCase.assertEquals((int)2, (int)endpoint.getMessageProcessors().size());
        EndpointURIEndpointBuilderTestCase.assertEquals((int)2, (int)endpoint.getResponseMessageProcessors().size());
    }

    private static class SensingEndpointURIEndpointBuilder
    extends EndpointURIEndpointBuilder {
        public SensingEndpointURIEndpointBuilder(ImmutableEndpoint endpoint) {
            super(endpoint);
        }

        public MessageExchangePattern getExchangePattern() {
            return this.messageExchangePattern;
        }
    }
}

