/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint;

import java.util.HashMap;
import java.util.Map;
import org.mule.api.endpoint.EndpointURI;
import org.mule.endpoint.URIBuilder;
import org.mule.tck.AbstractMuleTestCase;

public class URIBuilderTestCase
extends AbstractMuleTestCase {
    private static final Map<String, String> queries = new HashMap<String, String>();

    public void testAddressForProtocol() {
        URIBuilder uri = new URIBuilder(muleContext);
        uri.setProtocol("foo");
        uri.setAddress("foo://bar");
        URIBuilderTestCase.assertEquals((String)"foo://bar", (String)uri.toString());
    }

    public void testAddressForMeta() {
        URIBuilder uri = new URIBuilder(muleContext);
        uri.setMeta("foo");
        uri.setAddress("baz://bar");
        URIBuilderTestCase.assertEquals((String)"foo:baz://bar", (String)uri.toString());
    }

    public void testQueriesWithAddress() {
        URIBuilder uri = new URIBuilder(muleContext);
        uri.setAddress("foo://bar");
        uri.setQueryMap(queries);
        URIBuilderTestCase.assertEquals((String)"foo://bar?aname=avalue&bname=bvalue", (String)uri.toString());
    }

    public void testLiteralQueries() {
        URIBuilder uri1 = new URIBuilder(muleContext);
        uri1.setAddress("foo://bar?cname=cvalue&aname=anothervalue");
        uri1.setQueryMap(queries);
        URIBuilderTestCase.assertEquals((String)"foo://bar?cname=cvalue&aname=avalue&bname=bvalue", (String)uri1.toString());
        URIBuilder uri2 = new URIBuilder(muleContext);
        uri2.setQueryMap(queries);
        uri2.setAddress("foo://bar?cname=cvalue&aname=anothervalue");
        URIBuilderTestCase.assertEquals((String)"foo://bar?cname=cvalue&aname=avalue&bname=bvalue", (String)uri2.toString());
    }

    public void testNullQueries() {
        URIBuilder uri1 = new URIBuilder(muleContext);
        uri1.setAddress("foo://bar?cname&aname");
        uri1.setQueryMap(queries);
        URIBuilderTestCase.assertEquals((String)"foo://bar?cname&aname=avalue&bname=bvalue", (String)uri1.toString());
    }

    public void testFromString() {
        URIBuilder uri = new URIBuilder("test://bar", muleContext);
        EndpointURI endpointURI = uri.getEndpoint();
        URIBuilderTestCase.assertEquals((String)"test://bar", (String)endpointURI.getUri().toString());
        URIBuilderTestCase.assertEquals((String)"test", (String)endpointURI.getSchemeMetaInfo());
        uri = new URIBuilder("meta:test://bar", muleContext);
        endpointURI = uri.getEndpoint();
        URIBuilderTestCase.assertEquals((String)"test://bar", (String)endpointURI.getUri().toString());
        URIBuilderTestCase.assertEquals((String)"meta", (String)endpointURI.getSchemeMetaInfo());
    }

    public void testMultiValueParam() {
        URIBuilder uri = new URIBuilder("test://bar?aname=avalue&aname=bvalue&aname=cvalue", muleContext);
        EndpointURI endpointURI = uri.getEndpoint();
        URIBuilderTestCase.assertEquals((String)"test://bar?aname=avalue&aname=bvalue&aname=cvalue", (String)endpointURI.getUri().toString());
        HashMap<String, String> tq = new HashMap<String, String>();
        tq.put("aname", "zvalue");
        tq.put("dname", "dvalue");
        uri = new URIBuilder("test://bar?aname=avalue&aname=bvalue&aname=cvalue", muleContext);
        uri.setQueryMap(tq);
        endpointURI = uri.getEndpoint();
        URIBuilderTestCase.assertEquals((String)"test://bar?aname=zvalue&aname=bvalue&aname=cvalue&dname=dvalue", (String)endpointURI.getUri().toString());
    }

    static {
        queries.put("aname", "avalue");
        queries.put("bname", "bvalue");
    }
}

