/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import java.util.ArrayList;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.DefaultMuleException;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.MuleSession;
import org.mule.api.processor.MessageProcessor;
import org.mule.message.DefaultExceptionPayload;
import org.mule.routing.FirstSuccessful;
import org.mule.tck.AbstractMuleTestCase;

public class FirstSuccessfulTestCase
extends AbstractMuleTestCase {
    private static final String EXCEPTION_SEEN = "EXCEPTION WAS SEEN";

    public FirstSuccessfulTestCase() {
        this.setStartContext(true);
    }

    public void testFirstSuccessful() throws Exception {
        MuleSession session = FirstSuccessfulTestCase.getTestSession(FirstSuccessfulTestCase.getTestService(), muleContext);
        FirstSuccessful fs = new FirstSuccessful();
        ArrayList<TestProcessor> routes = new ArrayList<TestProcessor>();
        routes.add(new TestProcessor("abc"));
        routes.add(new TestProcessor("def"));
        routes.add(new TestProcessor("ghi"));
        fs.setMessageProcessors(routes);
        FirstSuccessfulTestCase.assertEquals((String)"No abc", (String)this.getPayload((MessageProcessor)fs, session, ""));
        FirstSuccessfulTestCase.assertEquals((String)"No def", (String)this.getPayload((MessageProcessor)fs, session, "abc"));
        FirstSuccessfulTestCase.assertEquals((String)"No ghi", (String)this.getPayload((MessageProcessor)fs, session, "abcdef"));
        FirstSuccessfulTestCase.assertEquals((String)EXCEPTION_SEEN, (String)this.getPayload((MessageProcessor)fs, session, "abcdefghi"));
        FirstSuccessfulTestCase.assertEquals((String)"No def", (String)this.getPayload((MessageProcessor)fs, session, "ABC"));
        FirstSuccessfulTestCase.assertEquals((String)"No ghi", (String)this.getPayload((MessageProcessor)fs, session, "ABCDEF"));
        FirstSuccessfulTestCase.assertEquals((String)EXCEPTION_SEEN, (String)this.getPayload((MessageProcessor)fs, session, "ABCDEFGHI"));
    }

    private String getPayload(MessageProcessor mp, MuleSession session, String message) throws Exception {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)message, muleContext);
        try {
            MuleEvent event = mp.process((MuleEvent)new DefaultMuleEvent((MuleMessage)msg, null, session));
            MuleMessage returnedMessage = event.getMessage();
            if (returnedMessage.getExceptionPayload() != null) {
                return EXCEPTION_SEEN;
            }
            return returnedMessage.getPayloadAsString();
        }
        catch (Exception ex) {
            return EXCEPTION_SEEN;
        }
    }

    static class TestProcessor
    implements MessageProcessor {
        private String rejectIfMatches;

        TestProcessor(String rejectIfMatches) {
            this.rejectIfMatches = rejectIfMatches;
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            try {
                DefaultMuleMessage msg;
                String payload = event.getMessage().getPayloadAsString();
                if (payload.indexOf(this.rejectIfMatches) >= 0) {
                    throw new DefaultMuleException("Saw " + this.rejectIfMatches);
                }
                if (payload.toLowerCase().indexOf(this.rejectIfMatches) >= 0) {
                    msg = new DefaultMuleMessage(null, muleContext);
                    msg.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new Exception()));
                } else {
                    msg = new DefaultMuleMessage((Object)("No " + this.rejectIfMatches), muleContext);
                }
                return new DefaultMuleEvent((MuleMessage)msg, null, event.getSession());
            }
            catch (Exception e) {
                throw new DefaultMuleException((Throwable)e);
            }
        }
    }
}

