/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.WireTap;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.SensingNullMessageProcessor;

public class WireTapTestCase
extends AbstractMuleTestCase {
    protected SensingNullMessageProcessor tapListener;
    protected WireTap wireTap;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.wireTap = new WireTap();
        this.tapListener = this.getSensingNullMessageProcessor();
        this.wireTap.setTap((MessageProcessor)this.tapListener);
    }

    public void testWireTapNoFilter() throws Exception {
        MuleEvent event = WireTapTestCase.getTestInboundEvent("data");
        MuleEvent primaryOutput = this.wireTap.process(event);
        WireTapTestCase.assertSame((Object)event, (Object)primaryOutput);
        WireTapTestCase.assertNotNull((Object)this.tapListener.event);
        WireTapTestCase.assertEquals((Object)event.getMessage().getPayload(), (Object)this.tapListener.event.getMessage().getPayload());
    }

    public void testWireTapFilterAccepted() throws Exception {
        this.wireTap.setFilter(new Filter(){

            public boolean accept(MuleMessage message) {
                return true;
            }
        });
        MuleEvent event = WireTapTestCase.getTestInboundEvent("data");
        MuleEvent primaryOutput = this.wireTap.process(event);
        WireTapTestCase.assertSame((Object)event, (Object)primaryOutput);
        WireTapTestCase.assertNotNull((Object)this.tapListener.event);
        WireTapTestCase.assertEquals((Object)event.getMessage().getPayload(), (Object)this.tapListener.event.getMessage().getPayload());
    }

    public void testWireTapFilterUnaccepted() throws Exception {
        this.wireTap.setFilter(new Filter(){

            public boolean accept(MuleMessage message) {
                return false;
            }
        });
        MuleEvent event = WireTapTestCase.getTestInboundEvent("data");
        MuleEvent primaryOutput = this.wireTap.process(event);
        WireTapTestCase.assertSame((Object)event, (Object)primaryOutput);
        WireTapTestCase.assertNull((Object)this.tapListener.event);
    }

    public void testWireTapNullTap() throws Exception {
        this.wireTap.setTap(null);
        MuleEvent event = WireTapTestCase.getTestInboundEvent("data");
        MuleEvent primaryOutput = this.wireTap.process(event);
        WireTapTestCase.assertSame((Object)event, (Object)primaryOutput);
    }
}

