/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import com.mockobjects.dynamic.ConstraintMatcher;
import com.mockobjects.dynamic.Mock;
import java.util.ArrayList;
import java.util.List;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.MuleSession;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.filter.Filter;
import org.mule.routing.filters.RegExFilter;
import org.mule.routing.outbound.MulticastingRouter;
import org.mule.routing.outbound.OutboundRoutingTestEvent;
import org.mule.routing.outbound.RouterTestUtils;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.tck.MuleTestUtils;

public class MulticastingRouterTestCase
extends AbstractMuleTestCase {
    public MulticastingRouterTestCase() {
        this.setStartContext(true);
    }

    public void testMulticastingRouterAsync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getFlowConstruct", (Object)MulticastingRouterTestCase.getTestService());
        RegExFilter filter = new RegExFilter("(.*) Message");
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://test1", null, (Filter)filter, null);
        MulticastingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://test2", null, (Filter)filter, null);
        MulticastingRouterTestCase.assertNotNull((Object)endpoint2);
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        MulticastingRouter router = this.createObject(MulticastingRouter.class);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)mockendpoint1.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint2.proxy());
        router.setRoutes(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        MulticastingRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        mockendpoint1.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        mockendpoint2.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy()));
        mockendpoint1.verify();
        mockendpoint2.verify();
    }

    public void testMulticastingRouterSync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getFlowConstruct", (Object)MulticastingRouterTestCase.getTestService());
        session.matchAndReturn("setFlowConstruct", (ConstraintMatcher)RouterTestUtils.getArgListCheckerFlowConstruct(), null);
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=request-response");
        MulticastingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://Test2Provider?exchangePattern=request-response");
        MulticastingRouterTestCase.assertNotNull((Object)endpoint2);
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        MulticastingRouter router = this.createObject(MulticastingRouter.class);
        RegExFilter filter = new RegExFilter("(.*) Message");
        router.setFilter((Filter)filter);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)mockendpoint1.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint2.proxy());
        router.setRoutes(endpoints);
        MulticastingRouterTestCase.assertEquals((Object)filter, (Object)router.getFilter());
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        MulticastingRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null);
        mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint2.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy()));
        MulticastingRouterTestCase.assertNotNull((Object)result);
        MuleMessage resultMessage = result.getMessage();
        MulticastingRouterTestCase.assertNotNull((Object)resultMessage);
        MulticastingRouterTestCase.assertTrue((boolean)(resultMessage instanceof MuleMessageCollection));
        MulticastingRouterTestCase.assertEquals((int)2, (int)((MuleMessageCollection)resultMessage).size());
        mockendpoint1.verify();
        mockendpoint2.verify();
    }

    public void testMulticastingRouterMixedSyncAsync() throws Exception {
        Mock session = MuleTestUtils.getMockSession();
        session.matchAndReturn("getFlowConstruct", (Object)MulticastingRouterTestCase.getTestService());
        session.matchAndReturn("setFlowConstruct", (ConstraintMatcher)RouterTestUtils.getArgListCheckerFlowConstruct(), null);
        OutboundEndpoint endpoint1 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test1Provider", "test://Test1Provider?exchangePattern=request-response");
        MulticastingRouterTestCase.assertNotNull((Object)endpoint1);
        OutboundEndpoint endpoint2 = MulticastingRouterTestCase.getTestOutboundEndpoint("Test2Provider", "test://Test2Provider?exchangePattern=request-response");
        MulticastingRouterTestCase.assertNotNull((Object)endpoint2);
        Mock mockendpoint1 = RouterTestUtils.getMockEndpoint(endpoint1);
        Mock mockendpoint2 = RouterTestUtils.getMockEndpoint(endpoint2);
        MulticastingRouter router = this.createObject(MulticastingRouter.class);
        ArrayList<OutboundEndpoint> endpoints = new ArrayList<OutboundEndpoint>();
        endpoints.add((OutboundEndpoint)mockendpoint1.proxy());
        endpoints.add((OutboundEndpoint)mockendpoint2.proxy());
        router.setRoutes(endpoints);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        MulticastingRouterTestCase.assertTrue((boolean)router.isMatch((MuleMessage)message));
        OutboundRoutingTestEvent event = new OutboundRoutingTestEvent((MuleMessage)message, null);
        mockendpoint1.expectAndReturn("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent(), (Object)event);
        mockendpoint2.expect("process", (ConstraintMatcher)RouterTestUtils.getArgListCheckerMuleEvent());
        MuleEvent result = router.route((MuleEvent)new OutboundRoutingTestEvent((MuleMessage)message, (MuleSession)session.proxy()));
        MulticastingRouterTestCase.assertNotNull((Object)result);
        MulticastingRouterTestCase.assertEquals((String)this.getPayload((MuleMessage)message), (String)this.getPayload(result.getMessage()));
        mockendpoint1.verify();
        mockendpoint2.verify();
    }

    private String getPayload(MuleMessage message) throws Exception {
        Object payload = message.getPayload();
        if (payload instanceof List) {
            payload = ((List)payload).get(0);
        }
        return payload.toString();
    }
}

