/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.mule.tck.AbstractMuleTestCase;
import org.mule.util.JarUtils;

public class JarUtilsTestCase
extends AbstractMuleTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCreateAppendReadJarFileEntries() {
        File jarFile = null;
        File jarEntryFile = null;
        try {
            String jarEntryString = "testString";
            jarEntryFile = File.createTempFile("test", "file");
            byte[] jarEntryBytes = jarEntryString.getBytes();
            LinkedHashMap<String, Object> jarEntries = new LinkedHashMap<String, Object>();
            jarEntries.put("META-INF/string", jarEntryString);
            jarEntries.put("META-INF/file", jarEntryFile);
            jarEntries.put("META-INF/byte", jarEntryBytes);
            jarFile = File.createTempFile("test", ".jar");
            JarUtilsTestCase.assertTrue((boolean)jarFile.delete());
            JarUtils.createJarFileEntries((File)jarFile, jarEntries);
            LinkedHashMap<String, String> additionalJarEntries = new LinkedHashMap<String, String>();
            additionalJarEntries.put("META-INF/append/string", jarEntryString);
            jarEntries.put("META-INF/append/string", jarEntryString);
            JarUtils.appendJarFileEntries((File)jarFile, additionalJarEntries);
            LinkedHashMap readJarEntries = JarUtils.readJarFileEntries((File)jarFile);
            JarUtilsTestCase.assertEquals((int)jarEntries.size(), (int)readJarEntries.size());
            Iterator jarEntryIter = jarEntries.keySet().iterator();
            Iterator readJarEntryIter = readJarEntries.keySet().iterator();
            while (jarEntryIter.hasNext()) {
                String jarEntryPath = (String)jarEntryIter.next();
                String readJarEntryPath = (String)readJarEntryIter.next();
                JarUtilsTestCase.assertNotNull((Object)jarEntryPath);
                JarUtilsTestCase.assertNotNull((Object)readJarEntryPath);
                JarUtilsTestCase.assertEquals((String)jarEntryPath, (String)readJarEntryPath);
                Object jarEntry = jarEntries.get(jarEntryPath);
                Object readJarEntry = jarEntries.get(readJarEntryPath);
                if (jarEntry instanceof String || jarEntry instanceof File) {
                    JarUtilsTestCase.assertEquals(jarEntry, readJarEntry);
                    continue;
                }
                if (jarEntry instanceof byte[]) {
                    JarUtilsTestCase.assertTrue((boolean)Arrays.equals((byte[])jarEntry, (byte[])readJarEntry));
                    continue;
                }
                JarUtilsTestCase.fail((String)("Unsupported jar entry read for " + jarEntryPath));
            }
        }
        catch (Exception e) {
            JarUtilsTestCase.fail((String)e.getMessage());
        }
        finally {
            if (jarFile != null) {
                jarFile.delete();
            }
            if (jarEntryFile != null) {
                jarEntryFile.delete();
            }
        }
    }
}

