/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Vector;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.TokenWrapper;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractBindingBuilder;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecDKEncrypt;
import org.apache.ws.security.message.WSSecDKSign;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecEncryptedKey;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecTimestamp;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricBindingHandler
extends AbstractBindingBuilder {
    SymmetricBinding sbinding;
    TokenStore tokenStore;

    public SymmetricBindingHandler(SymmetricBinding binding, SOAPMessage saaj, WSSecHeader secHeader, AssertionInfoMap aim, SoapMessage message) {
        super(binding, saaj, secHeader, aim, message);
        this.sbinding = binding;
        this.tokenStore = this.getTokenStore();
        this.protectionOrder = binding.getProtectionOrder();
    }

    private TokenWrapper getSignatureToken() {
        if (this.sbinding.getProtectionToken() != null) {
            return this.sbinding.getProtectionToken();
        }
        return this.sbinding.getSignatureToken();
    }

    private TokenWrapper getEncryptionToken() {
        if (this.sbinding.getProtectionToken() != null) {
            return this.sbinding.getProtectionToken();
        }
        return this.sbinding.getEncryptionToken();
    }

    public void handleBinding() {
        WSSecTimestamp timestamp = this.createTimestamp();
        this.handleLayout(timestamp);
        if (this.isRequestor()) {
            this.initializeTokens();
        }
        if (this.sbinding.getProtectionOrder() == SPConstants.ProtectionOrder.EncryptBeforeSigning) {
            this.doEncryptBeforeSign();
        } else {
            this.doSignBeforeEncrypt();
        }
        this.policyAsserted(SP11Constants.TRUST_10);
        this.policyAsserted(SP12Constants.TRUST_13);
    }

    private void initializeTokens() {
        Token sigTok = this.getSignatureToken().getToken();
        if (sigTok instanceof IssuedToken || sigTok instanceof SecureConversationToken) {
            // empty if block
        }
    }

    private void doEncryptBeforeSign() {
        try {
            TokenWrapper encryptionWrapper = this.getEncryptionToken();
            Token encryptionToken = encryptionWrapper.getToken();
            Vector<WSEncryptionPart> encrParts = this.getEncryptedParts();
            Vector<WSEncryptionPart> sigParts = this.getSignedParts();
            if (encryptionToken != null || encrParts.size() > 0) {
                // empty if block
            }
            if (encryptionToken != null && encrParts.size() > 0) {
                Element el;
                String tokenId = null;
                SecurityToken tok = null;
                if (encryptionToken instanceof IssuedToken) {
                    tok = this.getSecurityToken();
                } else if (encryptionToken instanceof SecureConversationToken) {
                    tok = this.getSecurityToken();
                } else if (encryptionToken instanceof X509Token) {
                    tokenId = this.isRequestor() ? this.setupEncryptedKey(encryptionWrapper, encryptionToken) : this.getEncryptedKey();
                }
                if (tok == null) {
                    if (tokenId == null || tokenId.length() == 0) {
                        // empty if block
                    }
                    if (tokenId.startsWith("#")) {
                        tokenId = tokenId.substring(1);
                    }
                    tok = this.tokenStore.getToken(tokenId);
                }
                boolean attached = false;
                if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == encryptionToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == encryptionToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == encryptionToken.getInclusion()) {
                    el = tok.getToken();
                    this.addEncyptedKeyElement(this.cloneElement(el));
                    attached = true;
                } else if (encryptionToken instanceof X509Token && this.isRequestor()) {
                    el = tok.getToken();
                    this.addEncyptedKeyElement(this.cloneElement(el));
                    attached = true;
                }
                WSSecBase encr = this.doEncryption(encryptionWrapper, tok, attached, encrParts, true);
                this.handleEncryptedSignedHeaders(encrParts, sigParts);
                if (this.timestampEl != null) {
                    sigParts.add(new WSEncryptionPart(this.addWsuIdToElement(this.timestampEl.getElement())));
                }
                if (this.isRequestor()) {
                    this.addSupportingTokens(sigParts);
                } else {
                    this.addSignatureConfirmation(sigParts);
                }
                if (sigParts.size() > 0) {
                    this.signatures.add(this.doSignature(sigParts, encryptionWrapper, encryptionToken, tok, attached));
                }
                if (this.isRequestor()) {
                    this.doEndorse();
                }
                if (this.sbinding.isSignatureProtection() && this.mainSigId != null || this.encryptedTokensIdList.size() > 0 && this.isRequestor()) {
                    Vector<WSEncryptionPart> secondEncrParts = new Vector<WSEncryptionPart>();
                    if (this.sbinding.isSignatureProtection()) {
                        secondEncrParts.add(new WSEncryptionPart(this.mainSigId, "Element"));
                    }
                    if (this.isRequestor()) {
                        for (String s : this.encryptedTokensIdList) {
                            secondEncrParts.add(new WSEncryptionPart(s, "Element"));
                        }
                    }
                    Element secondRefList = null;
                    if (encryptionToken.isDerivedKeys()) {
                        secondRefList = ((WSSecDKEncrypt)encr).encryptForExternalRef(null, secondEncrParts);
                        this.addDerivedKeyElement(secondRefList);
                    } else {
                        secondRefList = ((WSSecEncrypt)encr).encryptForExternalRef(null, encrParts);
                        this.addDerivedKeyElement(secondRefList);
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new Fault((Throwable)ex);
        }
    }

    private void doSignBeforeEncrypt() {
        TokenWrapper sigTokenWrapper = this.getSignatureToken();
        Token sigToken = sigTokenWrapper.getToken();
        String sigTokId = null;
        Element sigTokElem = null;
        try {
            Element el;
            SecurityToken sigTok = null;
            if (sigToken != null) {
                if (sigToken instanceof SecureConversationToken) {
                    sigTok = this.getSecurityToken();
                } else if (sigToken instanceof IssuedToken) {
                    sigTok = this.getSecurityToken();
                } else if (sigToken instanceof X509Token) {
                    sigTokId = this.isRequestor() ? this.setupEncryptedKey(sigTokenWrapper, sigToken) : this.getEncryptedKey();
                }
            } else {
                this.policyNotAsserted((PolicyAssertion)this.sbinding, "No signature token");
                return;
            }
            if (sigTok == null && StringUtils.isEmpty(sigTokId)) {
                this.policyNotAsserted((PolicyAssertion)sigTokenWrapper, "No signature token id");
                return;
            }
            this.policyAsserted(sigTokenWrapper);
            if (sigTok == null) {
                sigTok = this.tokenStore.getToken(sigTokId);
            }
            if (sigTok == null) {
                // empty if block
            }
            boolean tokIncluded = true;
            if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == sigToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == sigToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == sigToken.getInclusion()) {
                el = sigTok.getToken();
                sigTokElem = this.cloneElement(el);
                this.addEncyptedKeyElement(sigTokElem);
            } else if (this.isRequestor() && sigToken instanceof X509Token) {
                el = sigTok.getToken();
                sigTokElem = (Element)this.secHeader.getSecurityHeader().getOwnerDocument().importNode(el, true);
                this.addEncyptedKeyElement(sigTokElem);
            } else {
                tokIncluded = false;
            }
            Vector<WSEncryptionPart> sigs = this.getSignedParts();
            if (this.timestampEl != null) {
                Element el2 = this.timestampEl.getElement();
                sigs.add(new WSEncryptionPart(this.addWsuIdToElement(el2)));
            }
            if (this.isRequestor()) {
                this.addSupportingTokens(sigs);
                if (!sigs.isEmpty()) {
                    this.signatures.add(this.doSignature(sigs, sigTokenWrapper, sigToken, sigTok, tokIncluded));
                }
                this.doEndorse();
            } else {
                this.assertSupportingTokens(sigs);
                this.addSignatureConfirmation(sigs);
                if (!sigs.isEmpty()) {
                    this.doSignature(sigs, sigTokenWrapper, sigToken, sigTok, tokIncluded);
                }
            }
            TokenWrapper encrTokenWrapper = this.getEncryptionToken();
            Token encrToken = encrTokenWrapper.getToken();
            SecurityToken encrTok = null;
            if (sigToken.equals(encrToken)) {
                encrTok = sigTok;
            } else {
                String encrTokId = null;
                encrTok = this.tokenStore.getToken(encrTokId);
                if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == encrToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == encrToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == encrToken.getInclusion()) {
                    Element encrTokElem = encrTok.getToken();
                    this.secHeader.getSecurityHeader().insertBefore(encrTokElem, sigTokElem);
                }
            }
            Vector<WSEncryptionPart> enc = this.getEncryptedParts();
            if (this.sbinding.isSignatureProtection() && this.mainSigId != null) {
                enc.add(new WSEncryptionPart(this.mainSigId, "Element"));
            }
            if (this.isRequestor()) {
                for (String id : this.encryptedTokensIdList) {
                    enc.add(new WSEncryptionPart(id, "Element"));
                }
            }
            this.doEncryption(encrTokenWrapper, encrTok, tokIncluded, enc, false);
        }
        catch (Exception e) {
            throw new Fault((Throwable)e);
        }
    }

    private WSSecBase doEncryption(TokenWrapper recToken, SecurityToken encrTok, boolean attached, Vector<WSEncryptionPart> encrParts, boolean atEnd) {
        if (recToken != null && recToken.getToken() != null && encrParts.size() > 0) {
            Token encrToken = recToken.getToken();
            this.policyAsserted(recToken);
            this.policyAsserted(encrToken);
            AlgorithmSuite algorithmSuite = this.sbinding.getAlgorithmSuite();
            if (encrToken.isDerivedKeys()) {
                try {
                    WSSecDKEncrypt dkEncr = new WSSecDKEncrypt();
                    if (recToken.getToken().getSPConstants() == SP12Constants.INSTANCE) {
                        dkEncr.setWscVersion(2);
                    }
                    if (attached && encrTok.getAttachedReference() != null) {
                        dkEncr.setExternalKey(encrTok.getSecret(), (Element)this.saaj.getSOAPPart().importNode((Node)encrTok.getAttachedReference(), true));
                    } else if (encrTok.getUnattachedReference() != null) {
                        dkEncr.setExternalKey(encrTok.getSecret(), (Element)this.saaj.getSOAPPart().importNode((Node)encrTok.getUnattachedReference(), true));
                    } else if (!this.isRequestor()) {
                        SecurityTokenReference tokenRef = new SecurityTokenReference((Document)this.saaj.getSOAPPart());
                        if (encrTok.getSHA1() != null) {
                            tokenRef.setKeyIdentifierEncKeySHA1(encrTok.getSHA1());
                        }
                        dkEncr.setExternalKey(encrTok.getSecret(), tokenRef.getElement());
                    } else if (attached) {
                        String id = encrTok.getWsuId();
                        if (id == null) {
                            id = encrTok.getId();
                        }
                        if (id.startsWith("#")) {
                            id = id.substring(1);
                        }
                        dkEncr.setExternalKey(encrTok.getSecret(), id);
                    } else {
                        dkEncr.setExternalKey(encrTok.getSecret(), encrTok.getId());
                    }
                    if (encrTok.getSHA1() != null) {
                        dkEncr.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
                    }
                    dkEncr.setSymmetricEncAlgorithm(this.sbinding.getAlgorithmSuite().getEncryption());
                    dkEncr.setDerivedKeyLength(this.sbinding.getAlgorithmSuite().getEncryptionDerivedKeyLength() / 8);
                    dkEncr.prepare((Document)this.saaj.getSOAPPart());
                    Element encrDKTokenElem = null;
                    encrDKTokenElem = dkEncr.getdktElement();
                    this.addDerivedKeyElement(encrDKTokenElem);
                    Element refList = dkEncr.encryptForExternalRef(null, encrParts);
                    if (atEnd) {
                        this.insertBeforeBottomUp(refList);
                    } else {
                        this.addDerivedKeyElement(refList);
                    }
                    return dkEncr;
                }
                catch (Exception e) {
                    this.policyNotAsserted((PolicyAssertion)recToken, e);
                }
            } else {
                try {
                    WSSecEncrypt encr = new WSSecEncrypt();
                    String encrTokId = encrTok.getId();
                    if (attached) {
                        encrTokId = encrTok.getWsuId();
                        if (encrTokId == null) {
                            encrTokId = encrTok.getId();
                        }
                        if (encrTokId.startsWith("#")) {
                            encrTokId = encrTokId.substring(1);
                        }
                    } else {
                        encr.setEncKeyIdDirectId(true);
                    }
                    if (encrTok.getTokenType() != null) {
                        encr.setEncKeyValueType(encrTok.getTokenType());
                    }
                    encr.setEncKeyId(encrTokId);
                    encr.setEphemeralKey(encrTok.getSecret());
                    Crypto crypto = this.getEncryptionCrypto(recToken);
                    if (crypto != null) {
                        this.message.getExchange().put((Object)"ws-security.encryption.crypto", (Object)crypto);
                        this.setEncryptionUser((WSSecEncryptedKey)encr, recToken, false, crypto);
                    }
                    encr.setDocument((Document)this.saaj.getSOAPPart());
                    encr.setEncryptSymmKey(false);
                    encr.setSymmetricEncAlgorithm(algorithmSuite.getEncryption());
                    if (!this.isRequestor()) {
                        if (encrTok.getSHA1() != null) {
                            encr.setUseKeyIdentifier(true);
                            encr.setCustomReferenceValue(encrTok.getSHA1());
                            encr.setKeyIdentifierType(10);
                        } else {
                            encr.setUseKeyIdentifier(true);
                            encr.setKeyIdentifierType(6);
                        }
                    }
                    encr.prepare((Document)this.saaj.getSOAPPart(), crypto);
                    if (encr.getBSTTokenId() != null) {
                        encr.prependBSTElementToHeader(this.secHeader);
                    }
                    Element refList = encr.encryptForExternalRef(null, encrParts);
                    if (atEnd) {
                        this.insertBeforeBottomUp(refList);
                    } else {
                        this.addDerivedKeyElement(refList);
                    }
                    return encr;
                }
                catch (WSSecurityException e) {
                    this.policyNotAsserted((PolicyAssertion)recToken, e.getMessage());
                }
            }
        }
        return null;
    }

    private byte[] doSignatureDK(Vector<WSEncryptionPart> sigs, TokenWrapper policyTokenWrapper, Token policyToken, SecurityToken tok, boolean included) throws WSSecurityException {
        Element ref;
        SOAPPart doc = this.saaj.getSOAPPart();
        WSSecDKSign dkSign = new WSSecDKSign();
        if (policyTokenWrapper.getToken().getSPConstants() == SP12Constants.INSTANCE) {
            dkSign.setWscVersion(2);
        }
        boolean attached = false;
        if (SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS == policyToken.getInclusion() || SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE == policyToken.getInclusion() || this.isRequestor() && SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT == policyToken.getInclusion()) {
            attached = true;
        }
        if ((ref = attached ? tok.getAttachedReference() : tok.getUnattachedReference()) != null) {
            dkSign.setExternalKey(tok.getSecret(), (Element)this.saaj.getSOAPPart().importNode((Node)ref, true));
        } else if (!this.isRequestor() && policyToken.isDerivedKeys()) {
            SecurityTokenReference tokenRef = new SecurityTokenReference((Document)doc);
            if (tok.getSHA1() != null) {
                tokenRef.setKeyIdentifierEncKeySHA1(tok.getSHA1());
            }
            dkSign.setExternalKey(tok.getSecret(), tokenRef.getElement());
        } else {
            dkSign.setExternalKey(tok.getSecret(), tok.getId());
        }
        dkSign.setSignatureAlgorithm(this.sbinding.getAlgorithmSuite().getSymmetricSignature());
        dkSign.setDerivedKeyLength(this.sbinding.getAlgorithmSuite().getSignatureDerivedKeyLength() / 8);
        if (tok.getSHA1() != null) {
            dkSign.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        }
        try {
            dkSign.prepare((Document)doc, this.secHeader);
        }
        catch (ConversationException e) {
            throw new WSSecurityException(e.getMessage(), (Throwable)e);
        }
        if (this.sbinding.isTokenProtection()) {
            String sigTokId = tok.getId();
            if (included) {
                sigTokId = tok.getWsuId();
                if (sigTokId == null) {
                    sigTokId = tok.getId();
                }
                if (sigTokId.startsWith("#")) {
                    sigTokId = sigTokId.substring(1);
                }
            }
            sigs.add(new WSEncryptionPart(sigTokId));
        }
        dkSign.setParts(sigs);
        dkSign.addReferencesToSign(sigs, this.secHeader);
        dkSign.computeSignature();
        Element el = dkSign.getdktElement();
        this.addDerivedKeyElement(el);
        this.insertBeforeBottomUp(dkSign.getSignatureElement());
        this.mainSigId = this.addWsuIdToElement(dkSign.getSignatureElement());
        return dkSign.getSignatureValue();
    }

    private byte[] doSignature(Vector<WSEncryptionPart> sigs, TokenWrapper policyTokenWrapper, Token policyToken, SecurityToken tok, boolean included) throws WSSecurityException {
        String sigTokId;
        int type;
        if (policyToken.isDerivedKeys()) {
            return this.doSignatureDK(sigs, policyTokenWrapper, policyToken, tok, included);
        }
        WSSecSignature sig = new WSSecSignature();
        int n = type = included ? 9 : 11;
        if (policyToken instanceof X509Token) {
            if (this.isRequestor()) {
                sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#EncryptedKey");
                sig.setKeyIdentifierType(type);
            } else {
                sig.setEncrKeySha1value(tok.getSHA1());
                sig.setKeyIdentifierType(10);
            }
        } else if (tok.getTokenType() != null) {
            sig.setCustomTokenValueType(tok.getTokenType());
            sig.setKeyIdentifierType(type);
        } else {
            sig.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            sig.setKeyIdentifierType(type);
        }
        if (included) {
            sigTokId = tok.getWsuId();
            if (sigTokId == null) {
                sigTokId = tok.getId();
            }
            if (sigTokId.startsWith("#")) {
                sigTokId = sigTokId.substring(1);
            }
        } else {
            sigTokId = tok.getId();
        }
        sig.setCustomTokenId(sigTokId);
        sig.setSecretKey(tok.getSecret());
        sig.setSignatureAlgorithm(this.sbinding.getAlgorithmSuite().getSymmetricSignature());
        Crypto crypto = null;
        crypto = this.sbinding.getProtectionToken() != null ? this.getEncryptionCrypto(this.sbinding.getProtectionToken()) : this.getSignatureCrypto(policyTokenWrapper);
        this.message.getExchange().put((Object)"ws-security.signature.crypto", (Object)crypto);
        sig.prepare((Document)this.saaj.getSOAPPart(), crypto, this.secHeader);
        sig.setParts(sigs);
        sig.addReferencesToSign(sigs, this.secHeader);
        sig.computeSignature();
        Element mainSigElement = sig.getSignatureElement();
        this.insertBeforeBottomUp(mainSigElement);
        this.mainSigId = this.addWsuIdToElement(mainSigElement);
        return sig.getSignatureValue();
    }

    private String setupEncryptedKey(TokenWrapper wrapper, Token sigToken) throws WSSecurityException {
        WSSecEncryptedKey encrKey = this.getEncryptedKeyBuilder(wrapper, sigToken);
        String id = encrKey.getId();
        byte[] secret = encrKey.getEphemeralKey();
        Calendar created = Calendar.getInstance();
        Calendar expires = Calendar.getInstance();
        expires.setTimeInMillis(System.currentTimeMillis() + 300000L);
        SecurityToken tempTok = new SecurityToken(id, encrKey.getEncryptedKeyElement(), created, expires);
        tempTok.setSecret(secret);
        tempTok.setSHA1(this.getSHA1(encrKey.getEncryptedEphemeralKey()));
        this.tokenStore.add(tempTok);
        String bstTokenId = encrKey.getBSTTokenId();
        if (bstTokenId != null && bstTokenId.length() > 0) {
            encrKey.prependBSTElementToHeader(this.secHeader);
        }
        return id;
    }

    private String getEncryptedKey() {
        Vector results = (Vector)this.message.getExchange().getInMessage().get((Object)"RECV_RESULTS");
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 4 || wser.get((Object)"encrypted-key-id") == null || ((String)wser.get((Object)"encrypted-key-id")).length() == 0) continue;
                String encryptedKeyID = (String)wser.get((Object)"encrypted-key-id");
                Calendar created = Calendar.getInstance();
                Calendar expires = Calendar.getInstance();
                expires.setTimeInMillis(System.currentTimeMillis() + 300000L);
                SecurityToken tempTok = new SecurityToken(encryptedKeyID, created, expires);
                tempTok.setSecret((byte[])wser.get((Object)"decrypted-key"));
                tempTok.setSHA1(this.getSHA1((byte[])wser.get(WSSecurityEngineResult.TAG_ENCRYPTED_EPHEMERAL_KEY)));
                this.tokenStore.add(tempTok);
                return encryptedKeyID;
            }
        }
        return null;
    }

    private String getSHA1(byte[] input) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            sha.reset();
            sha.update(input);
            byte[] data = sha.digest();
            return Base64.encode((byte[])data);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

