/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.key;

import cryptix.jce.provider.key.RawSecretKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

abstract class RawKeyGenerator
extends KeyGeneratorSpi {
    private final String algorithm;
    private final int defaultKeySize;
    private SecureRandom random = null;
    private int keySize = 0;

    protected RawKeyGenerator(String algorithm, int defaultKeySize) {
        this.algorithm = algorithm;
        this.defaultKeySize = defaultKeySize;
    }

    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] keyBytes = new byte[(this.strengthToBits(this.keySize) + 7) / 8];
        do {
            this.random.nextBytes(keyBytes);
        } while (this.isWeak(keyBytes = this.fixUp(keyBytes)));
        return new RawSecretKey(this.algorithm, keyBytes);
    }

    protected void engineInit(int keysize, SecureRandom random) {
        if (!this.isValidSize(keysize)) {
            throw new InvalidParameterException("Key size not supported [" + keysize + "]");
        }
        this.random = random;
        this.keySize = keysize;
    }

    protected void engineInit(SecureRandom random) {
        this.random = random;
        this.keySize = this.defaultKeySize;
    }

    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("No AlgorithmParameterSpec supported.");
    }

    protected byte[] fixUp(byte[] key) {
        return key;
    }

    protected abstract boolean isValidSize(int var1);

    protected abstract boolean isWeak(byte[] var1);

    protected int strengthToBits(int strength) {
        return strength;
    }
}

