/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.bpm;

import java.util.Map;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationException;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.config.i18n.MessageFactory;
import org.mule.module.bpm.BPMS;
import org.mule.module.bpm.MessageService;
import org.mule.module.client.MuleClient;
import org.mule.transport.AbstractConnector;
import org.mule.transport.bpm.ProcessMessageReceiver;
import org.mule.util.StringUtils;

public class ProcessConnector
extends AbstractConnector
implements MessageService {
    protected BPMS bpms;
    protected String processIdField;
    protected boolean allowGlobalReceiver = false;
    public static final String PROTOCOL = "bpm";
    public static final String GLOBAL_RECEIVER = "bpm://*";
    private MuleClient muleClient = null;

    public ProcessConnector(MuleContext context) {
        super(context);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    protected void doInitialise() throws InitialisationException {
        try {
            if (this.bpms == null) {
                this.bpms = this.createBpms();
            }
            if (this.bpms == null) {
                throw new ConfigurationException(MessageFactory.createStaticMessage("The bpms property must be set for this connector."));
            }
            if (this.bpms instanceof Initialisable) {
                ((Initialisable)((Object)this.bpms)).initialise();
            }
            this.bpms.setMessageService(this);
            if (this.muleClient == null) {
                this.muleClient = new MuleClient(this.muleContext);
            }
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    protected BPMS createBpms() throws Exception {
        return null;
    }

    protected void doDispose() {
        if (this.bpms instanceof Disposable) {
            ((Disposable)((Object)this.bpms)).dispose();
        }
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }

    public ProcessMessageReceiver lookupReceiver(String processName, Object processId) {
        ProcessMessageReceiver receiver = (ProcessMessageReceiver)this.lookupReceiver(this.toUrl(processName, processId));
        if (receiver == null) {
            receiver = (ProcessMessageReceiver)this.lookupReceiver(this.toUrl(processName, null));
        }
        if (receiver == null) {
            receiver = (ProcessMessageReceiver)this.lookupReceiver(this.toUrl(null, null));
        }
        return receiver;
    }

    public String toUrl(String processName, Object processId) {
        String url = this.getProtocol() + "://";
        if (StringUtils.isNotEmpty((String)processName)) {
            url = url + processName;
            if (processId != null) {
                url = url + "/" + processId;
            }
        } else {
            if (this.isAllowGlobalReceiver()) {
                return GLOBAL_RECEIVER;
            }
            throw new IllegalArgumentException("No valid URL could be created for the given process name and ID: processName = " + processName + ", processId = " + processId);
        }
        return url;
    }

    public MuleMessage generateMessage(String endpoint, Object payloadObject, Map messageProperties, MessageExchangePattern mep) throws Exception {
        Object processId;
        String processName = (String)messageProperties.get("MULE_BPM_PROCESS_TYPE");
        ProcessMessageReceiver receiver = this.lookupReceiver(processName, processId = messageProperties.get("MULE_BPM_PROCESS_ID"));
        if (receiver == null) {
            throw new ConfigurationException(MessageFactory.createStaticMessage("No corresponding receiver found for processName = " + processName + ", processId = " + processId));
        }
        this.logger.debug((Object)("Generating Mule message for process name = " + processName + " id = " + processId + ", synchronous = " + mep.hasResponse()));
        if (mep.hasResponse()) {
            return receiver.generateSynchronousEvent(endpoint, payloadObject, messageProperties);
        }
        receiver.generateAsynchronousEvent(endpoint, payloadObject, messageProperties);
        return null;
    }

    public BPMS getBpms() {
        return this.bpms;
    }

    public void setBpms(BPMS bpms) {
        this.bpms = bpms;
    }

    public MuleClient getMuleClient() {
        return this.muleClient;
    }

    public boolean isAllowGlobalReceiver() {
        return this.allowGlobalReceiver;
    }

    public void setAllowGlobalReceiver(boolean allowGlobalReceiver) {
        this.allowGlobalReceiver = allowGlobalReceiver;
    }

    public String getProcessIdField() {
        return this.processIdField;
    }

    public void setProcessIdField(String processIdField) {
        this.processIdField = processIdField;
    }
}

