/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import java.text.MessageFormat;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsSupport;

public class Jms11Support
implements JmsSupport {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected JmsConnector connector;

    public Jms11Support(JmsConnector connector) {
        this.connector = connector;
    }

    public Connection createConnection(ConnectionFactory connectionFactory, String username, String password) throws JMSException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        return connectionFactory.createConnection(username, password);
    }

    public Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        return connectionFactory.createConnection();
    }

    public Session createSession(Connection connection, boolean topic, boolean transacted, int ackMode, boolean noLocal) throws JMSException {
        return connection.createSession(transacted, transacted ? 0 : ackMode);
    }

    public MessageProducer createProducer(Session session, Destination destination, boolean topic) throws JMSException {
        return session.createProducer(destination);
    }

    public MessageConsumer createConsumer(Session session, Destination destination, boolean topic, ImmutableEndpoint endpoint) throws JMSException {
        return this.createConsumer(session, destination, null, false, null, topic, endpoint);
    }

    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, boolean noLocal, String durableName, boolean topic, ImmutableEndpoint endpoint) throws JMSException {
        if (durableName == null) {
            if (topic) {
                return session.createConsumer(destination, messageSelector, noLocal);
            }
            return session.createConsumer(destination, messageSelector);
        }
        if (topic) {
            return session.createDurableSubscriber((Topic)destination, durableName, messageSelector, noLocal);
        }
        throw new JMSException("A durable subscriber name was set but the destination was not a Topic");
    }

    public Destination createDestination(Session session, ImmutableEndpoint endpoint) throws JMSException {
        String address = endpoint.getEndpointURI().toString();
        if (address.contains("topic:")) {
            if ((address = address.substring((this.connector.getProtocol() + "://" + "topic" + ":").length())).contains("?")) {
                address = address.substring(0, address.indexOf(63));
            }
        } else {
            address = endpoint.getEndpointURI().getAddress();
        }
        return this.createDestination(session, address, this.connector.getTopicResolver().isTopic(endpoint), endpoint);
    }

    public Destination createDestination(Session session, String name, boolean topic, ImmutableEndpoint endpoint) throws JMSException {
        if (this.connector.isJndiDestinations()) {
            try {
                Destination dest = this.getJndiDestination(name);
                if (dest != null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)MessageFormat.format("Destination {0} located in JNDI, will use it now", name));
                    }
                    return dest;
                }
                throw new JMSException("JNDI destination not found with name: " + name);
            }
            catch (JMSException e) {
                if (this.connector.isForceJndiDestinations()) {
                    throw e;
                }
                this.logger.warn((Object)("Unable to look up JNDI destination " + name + ": " + e.getMessage()));
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using non-JNDI destination " + name + ", will create one now"));
        }
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (name == null) {
            throw new IllegalArgumentException("Destination name cannot be null when creating a destination");
        }
        if (topic) {
            return session.createTopic(name);
        }
        return session.createQueue(name);
    }

    protected Destination getJndiDestination(String name) throws JMSException {
        Object temp;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)MessageFormat.format("Looking up {0} from JNDI", name));
            }
            temp = this.connector.lookupFromJndi(name);
        }
        catch (NamingException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)e);
            }
            String message = MessageFormat.format("Failed to look up destination {0}. Reason: {1}", name, e.getMessage());
            throw new JMSException(message);
        }
        if (temp != null && temp instanceof Destination) {
            return (Destination)temp;
        }
        return null;
    }

    public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (topic) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }

    public void send(MessageProducer producer, Message message, boolean topic, ImmutableEndpoint endpoint) throws JMSException {
        this.send(producer, message, this.connector.isPersistentDelivery(), 4, 0L, topic, endpoint);
    }

    public void send(MessageProducer producer, Message message, Destination dest, boolean topic, ImmutableEndpoint endpoint) throws JMSException {
        this.send(producer, message, dest, this.connector.isPersistentDelivery(), 4, 0L, topic, endpoint);
    }

    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic, ImmutableEndpoint endpoint) throws JMSException {
        producer.send(message, persistent ? 2 : 1, priority, ttl);
    }

    public void send(MessageProducer producer, Message message, Destination dest, boolean persistent, int priority, long ttl, boolean topic, ImmutableEndpoint endpoint) throws JMSException {
        producer.send(dest, message, persistent ? 2 : 1, priority, ttl);
    }
}

