/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.jms;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transaction.Transaction;
import org.mule.api.transformer.TransformerException;
import org.mule.api.transport.DispatchException;
import org.mule.config.i18n.CoreMessages;
import org.mule.transaction.TransactionCoordination;
import org.mule.transport.AbstractMessageDispatcher;
import org.mule.transport.jms.JmsConnector;
import org.mule.transport.jms.JmsMessageUtils;
import org.mule.transport.jms.i18n.JmsMessages;
import org.mule.util.ClassUtils;
import org.mule.util.NumberUtils;
import org.mule.util.concurrent.Latch;
import org.mule.util.concurrent.WaitableBoolean;

public class JmsMessageDispatcher
extends AbstractMessageDispatcher {
    private JmsConnector connector;
    private Session cachedSession;
    private boolean disableTemporaryDestinations = false;
    private boolean returnOriginalMessageAsReply = false;

    public JmsMessageDispatcher(OutboundEndpoint endpoint) {
        super(endpoint);
        this.connector = (JmsConnector)endpoint.getConnector();
        this.disableTemporaryDestinations = this.connector.isDisableTemporaryReplyToDestinations() || "true".equals(endpoint.getProperty("disableTemporaryReplyToDestinations"));
        boolean bl = this.returnOriginalMessageAsReply = this.connector.isReturnOriginalMessageAsReply() || "true".equals(endpoint.getProperty("returnOriginalMessageAsReply"));
        if (this.returnOriginalMessageAsReply && !this.disableTemporaryDestinations) {
            this.logger.warn((Object)"The returnOriginalMessageAsReply property will be ignored because disableTemporaryReplyToDestinations=false.  You need to disable temporary ReplyTo destinations in order for this propery to take effect.");
        }
    }

    protected void doDispatch(MuleEvent event) throws Exception {
        if (this.connector.getConnection() == null) {
            throw new IllegalStateException("No JMS Connection");
        }
        this.dispatchMessage(event, false);
    }

    protected void doConnect() throws Exception {
    }

    protected void doDisconnect() throws Exception {
    }

    protected boolean isDisableTemporaryDestinations() {
        return this.disableTemporaryDestinations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MuleMessage dispatchMessage(MuleEvent event, boolean doSend) throws Exception {
        Message msg;
        boolean sessionManaged;
        boolean cached;
        boolean transacted;
        Destination replyTo;
        MessageConsumer consumer;
        MessageProducer producer;
        Session session;
        block51: {
            Message result;
            block54: {
                block52: {
                    Message result2;
                    block53: {
                        MuleMessage muleMessage;
                        session = null;
                        producer = null;
                        consumer = null;
                        replyTo = null;
                        transacted = false;
                        cached = false;
                        Transaction muleTx = TransactionCoordination.getInstance().getTransaction();
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("dispatching on endpoint: " + event.getEndpoint().getEndpointURI() + ". MuleEvent id is: " + event.getId() + ". Outbound transformers are: " + event.getEndpoint().getTransformers()));
                        }
                        sessionManaged = true;
                        try {
                            session = this.connector.getSessionFromTransaction();
                            if (session != null) {
                                transacted = true;
                            } else if (event.getMessage().getOutboundProperty("cacheJmsSessions", this.connector.isCacheJmsSessions()).booleanValue()) {
                                sessionManaged = false;
                                cached = true;
                                if (this.cachedSession != null) {
                                    session = this.cachedSession;
                                } else {
                                    this.cachedSession = session = this.connector.getSession(event.getEndpoint());
                                }
                            } else {
                                sessionManaged = muleTx != null && muleTx.isXA();
                                session = this.connector.getSession(event.getEndpoint());
                                if (event.getEndpoint().getTransactionConfig().isTransacted()) {
                                    transacted = true;
                                }
                            }
                            boolean useReplyToDestination = this.returnResponse(event, doSend) && !transacted;
                            boolean topic = this.connector.getTopicResolver().isTopic(event.getEndpoint(), true);
                            Destination dest = this.connector.getJmsSupport().createDestination(session, this.endpoint);
                            producer = this.connector.getJmsSupport().createProducer(session, dest, topic);
                            Object message = event.getMessage().getPayload();
                            if (!(message instanceof Message)) {
                                throw new DispatchException(JmsMessages.checkTransformer("JMS message", message.getClass(), this.connector.getName()), event, (OutboundEndpoint)this.endpoint);
                            }
                            msg = (Message)message;
                            MuleMessage eventMsg = event.getMessage();
                            replyTo = this.getReplyToDestination(msg, session, event, useReplyToDestination, topic);
                            if (replyTo != null) {
                                msg.setJMSReplyTo(replyTo);
                            }
                            this.processMessage(msg, event);
                            long ttl = eventMsg.getOutboundProperty("timeToLive", 0L);
                            int priority = eventMsg.getOutboundProperty("priority", 4);
                            boolean persistent = eventMsg.getOutboundProperty("persistentDelivery", this.connector.isPersistentDelivery());
                            if (this.connector.isHonorQosHeaders()) {
                                Object priorityProp = eventMsg.getInboundProperty("JMSPriority");
                                Object deliveryModeProp = eventMsg.getInboundProperty("JMSDeliveryMode");
                                if (priorityProp != null) {
                                    priority = NumberUtils.toInt(priorityProp);
                                }
                                if (deliveryModeProp != null) {
                                    boolean bl = persistent = NumberUtils.toInt(deliveryModeProp) == 2;
                                }
                            }
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Sending message of type " + ClassUtils.getSimpleName(msg.getClass())));
                                this.logger.debug((Object)("Sending JMS Message type " + msg.getJMSType() + "\n  JMSMessageID=" + msg.getJMSMessageID() + "\n  JMSCorrelationID=" + msg.getJMSCorrelationID() + "\n  JMSDeliveryMode=" + (persistent ? 2 : 1) + "\n  JMSPriority=" + priority + "\n  JMSReplyTo=" + msg.getJMSReplyTo()));
                            }
                            this.connector.getJmsSupport().send(producer, msg, persistent, priority, ttl, topic, this.endpoint);
                            if (!useReplyToDestination || replyTo == null) break block51;
                            consumer = this.createReplyToConsumer(msg, event, session, replyTo, topic);
                            if (!topic) break block52;
                            Latch l = new Latch();
                            ReplyToListener listener = new ReplyToListener(l);
                            consumer.setMessageListener((MessageListener)listener);
                            this.connector.getJmsSupport().send(producer, msg, persistent, priority, ttl, topic, this.endpoint);
                            int timeout = event.getTimeout();
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug((Object)("Waiting for return event for: " + timeout + " ms on " + replyTo));
                            }
                            l.await(timeout, TimeUnit.MILLISECONDS);
                            consumer.setMessageListener(null);
                            listener.release();
                            result2 = listener.getMessage();
                            if (result2 != null) break block53;
                            this.logger.debug((Object)"No message was returned via replyTo destination");
                            muleMessage = this.createNullMuleMessage();
                            Object var27_29 = null;
                            this.connector.closeQuietly(producer);
                            this.connector.closeQuietly(consumer);
                        }
                        catch (Throwable throwable) {
                            block55: {
                                Object var27_34 = null;
                                this.connector.closeQuietly(producer);
                                this.connector.closeQuietly(consumer);
                                if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                                    if (replyTo instanceof TemporaryQueue) {
                                        this.connector.closeQuietly((TemporaryQueue)replyTo);
                                    } else {
                                        this.connector.closeQuietly((TemporaryTopic)replyTo);
                                    }
                                }
                                if (!sessionManaged && transacted) {
                                    this.handleMultiTx(session);
                                }
                                if (session == null || cached || transacted) break block55;
                                this.connector.closeQuietly(session);
                            }
                            throw throwable;
                        }
                        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                            if (replyTo instanceof TemporaryQueue) {
                                this.connector.closeQuietly((TemporaryQueue)replyTo);
                            } else {
                                this.connector.closeQuietly((TemporaryTopic)replyTo);
                            }
                        }
                        if (!sessionManaged && transacted) {
                            this.handleMultiTx(session);
                        }
                        if (session != null && !cached && !transacted) {
                            this.connector.closeQuietly(session);
                        }
                        return muleMessage;
                    }
                    MuleMessage muleMessage = this.createMessageWithJmsMessagePayload(result2);
                    Object var27_30 = null;
                    this.connector.closeQuietly(producer);
                    this.connector.closeQuietly(consumer);
                    if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                        if (replyTo instanceof TemporaryQueue) {
                            this.connector.closeQuietly((TemporaryQueue)replyTo);
                        } else {
                            this.connector.closeQuietly((TemporaryTopic)replyTo);
                        }
                    }
                    if (!sessionManaged && transacted) {
                        this.handleMultiTx(session);
                    }
                    if (session != null && !cached && !transacted) {
                        this.connector.closeQuietly(session);
                    }
                    return muleMessage;
                }
                int timeout = event.getTimeout();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Waiting for return event for: " + timeout + " ms on " + replyTo));
                }
                if ((result = consumer.receive((long)timeout)) != null) break block54;
                this.logger.debug((Object)("No message was returned via replyTo destination " + replyTo));
                MuleMessage muleMessage = this.createNullMuleMessage();
                Object var27_31 = null;
                this.connector.closeQuietly(producer);
                this.connector.closeQuietly(consumer);
                if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                    if (replyTo instanceof TemporaryQueue) {
                        this.connector.closeQuietly((TemporaryQueue)replyTo);
                    } else {
                        this.connector.closeQuietly((TemporaryTopic)replyTo);
                    }
                }
                if (!sessionManaged && transacted) {
                    this.handleMultiTx(session);
                }
                if (session != null && !cached && !transacted) {
                    this.connector.closeQuietly(session);
                }
                return muleMessage;
            }
            MuleMessage muleMessage = this.createMessageWithJmsMessagePayload(result);
            Object var27_32 = null;
            this.connector.closeQuietly(producer);
            this.connector.closeQuietly(consumer);
            if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
                if (replyTo instanceof TemporaryQueue) {
                    this.connector.closeQuietly((TemporaryQueue)replyTo);
                } else {
                    this.connector.closeQuietly((TemporaryTopic)replyTo);
                }
            }
            if (!sessionManaged && transacted) {
                this.handleMultiTx(session);
            }
            if (session != null && !cached && !transacted) {
                this.connector.closeQuietly(session);
            }
            return muleMessage;
        }
        MuleMessage muleMessage = this.returnOriginalMessageAsReply ? this.createMuleMessage(msg) : null;
        Object var27_33 = null;
        this.connector.closeQuietly(producer);
        this.connector.closeQuietly(consumer);
        if (replyTo != null && (replyTo instanceof TemporaryQueue || replyTo instanceof TemporaryTopic)) {
            if (replyTo instanceof TemporaryQueue) {
                this.connector.closeQuietly((TemporaryQueue)replyTo);
            } else {
                this.connector.closeQuietly((TemporaryTopic)replyTo);
            }
        }
        if (!sessionManaged && transacted) {
            this.handleMultiTx(session);
        }
        if (session != null && !cached && !transacted) {
            this.connector.closeQuietly(session);
        }
        return muleMessage;
    }

    protected MuleMessage createMessageWithJmsMessagePayload(Message jmsMessage) throws Exception {
        MuleMessage muleMessage = this.createMuleMessage(jmsMessage);
        Object payload = JmsMessageUtils.toObject(jmsMessage, this.connector.getSpecification(), this.endpoint.getEncoding());
        muleMessage.setPayload(payload);
        return muleMessage;
    }

    protected void preTransformMessage(MuleMessage message) throws Exception {
    }

    protected void handleMultiTx(Session session) throws Exception {
        this.logger.debug((Object)"Multi-transaction support is not available in Mule Community Edition.");
    }

    protected MuleMessage doSend(MuleEvent event) throws Exception {
        return this.dispatchMessage(event, true);
    }

    protected void doDispose() {
    }

    protected void processMessage(Message msg, MuleEvent event) throws JMSException {
    }

    protected boolean isHandleReplyTo(Message msg, MuleEvent event) throws JMSException {
        return this.connector.supportsProperty("JMSReplyTo");
    }

    protected MessageConsumer createReplyToConsumer(Message currentMessage, MuleEvent event, Session session, Destination replyTo, boolean topic) throws JMSException {
        String selector = null;
        if (!(replyTo instanceof TemporaryQueue) && !(replyTo instanceof TemporaryTopic)) {
            String jmsCorrelationId = currentMessage.getJMSCorrelationID();
            if (jmsCorrelationId == null) {
                jmsCorrelationId = currentMessage.getJMSMessageID();
            }
            selector = "JMSCorrelationID='" + jmsCorrelationId + "'";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("ReplyTo Selector is: " + selector));
            }
        }
        if (topic) {
            String durableName;
            String tempDurable = (String)event.getEndpoint().getProperties().get("durable");
            boolean durable = this.connector.isDurable();
            if (tempDurable != null) {
                durable = Boolean.valueOf(tempDurable);
            }
            if ((durableName = (String)event.getEndpoint().getProperties().get("durableName")) == null && durable && topic) {
                durableName = "mule." + this.connector.getName() + "." + event.getEndpoint().getEndpointURI().getAddress();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Jms Connector for this receiver is durable but no durable name has been specified. Defaulting to: " + durableName));
                }
            }
        }
        return this.connector.getJmsSupport().createConsumer(session, replyTo, selector, this.connector.isNoLocal(), null, topic, this.endpoint);
    }

    protected Destination getReplyToDestination(Message message, Session session, MuleEvent event, boolean remoteSync, boolean topic) throws JMSException, EndpointException, InitialisationException {
        Destination replyTo = null;
        if (this.isHandleReplyTo(message, event)) {
            Object tempReplyTo = event.getMessage().getOutboundProperty("JMSReplyTo");
            if (tempReplyTo == null && (tempReplyTo = event.getMessage().getOutboundProperty("MULE_REPLYTO")) != null) {
                int i = tempReplyTo.toString().indexOf("://");
                if (i > -1) {
                    tempReplyTo = tempReplyTo.toString().substring(i + 3);
                } else {
                    EndpointBuilder epb = event.getMuleContext().getRegistry().lookupEndpointBuilder(tempReplyTo.toString());
                    if (epb != null) {
                        tempReplyTo = epb.buildOutboundEndpoint().getEndpointURI().getAddress();
                    }
                }
            }
            if (tempReplyTo != null) {
                if (tempReplyTo instanceof Destination) {
                    replyTo = (Destination)tempReplyTo;
                } else {
                    boolean replyToTopic = false;
                    String reply = tempReplyTo.toString();
                    int i = reply.indexOf(":");
                    if (i > -1) {
                        String qtype = reply.substring(0, i);
                        replyToTopic = "topic".equalsIgnoreCase(qtype);
                        reply = reply.substring(i + 1);
                    }
                    replyTo = this.connector.getJmsSupport().createDestination(session, reply, replyToTopic, this.endpoint);
                }
            }
            if (remoteSync && replyTo == null && !this.disableTemporaryDestinations) {
                replyTo = this.connector.getJmsSupport().createTemporaryDestination(session, topic);
            }
        }
        return replyTo;
    }

    protected void applyOutboundTransformers(MuleEvent event) throws MuleException {
        try {
            this.preTransformMessage(event.getMessage());
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.failedToInvoke("preTransformMessage"), (Throwable)e);
        }
        super.applyOutboundTransformers(event);
    }

    protected class ReplyToListener
    implements MessageListener {
        private final Latch latch;
        private volatile Message message;
        private final WaitableBoolean released = new WaitableBoolean(false);

        public ReplyToListener(Latch latch) {
            this.latch = latch;
        }

        public Message getMessage() {
            return this.message;
        }

        public void release() {
            this.released.set(true);
        }

        public void onMessage(Message message) {
            this.message = message;
            this.latch.countDown();
            try {
                this.released.whenTrue(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

