/*
 * $Id: ExceptionHandlingMule2167TestCase.java 19873 2010-10-08 23:54:59Z dzapata $
 * --------------------------------------------------------------------------------------
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.transport.email.issues;

import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.DynamicPortTestCase;
import org.mule.tck.FunctionalTestCase;

public class ExceptionHandlingMule2167TestCase extends DynamicPortTestCase
{

    public static final String MESSAGE = "a message";
    public static final long WAIT_MS = 3000L;

    protected String getConfigResources()
    {
        return "exception-handling-mule-2167-test.xml";
    }

    public void testDefaultConfig() throws Exception
    {
        MuleClient client = new MuleClient(muleContext);
        client.dispatch("vm://in-default", MESSAGE, null);
        MuleMessage message = client.request("vm://out-default", WAIT_MS);
        assertNotNull("null message", message);
        assertNotNull("null payload", message.getPayload());
        assertEquals(MESSAGE, message.getPayloadAsString());
    }

    @Override
    protected int getNumPortsToFind()
    {
        return 1;
    }

}
