/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.management.agent;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.mule.AbstractAgent;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.module.management.agent.FixedHostRmiClientSocketFactory;
import org.mule.module.management.agent.JdmkAgent;
import org.mule.module.management.agent.JmxAgent;
import org.mule.module.management.agent.JmxServerNotificationAgent;
import org.mule.module.management.agent.Log4jAgent;
import org.mule.module.management.agent.Mx4jAgent;
import org.mule.module.management.agent.RmiRegistryAgent;
import org.mule.module.management.agent.YourKitProfilerAgent;
import org.mule.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJmxSupportAgent
extends AbstractAgent {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_PORT = "1099";
    private boolean loadLog4jAgent = true;
    private boolean loadJdmkAgent = false;
    private boolean loadMx4jAgent = false;
    private boolean loadProfilerAgent = false;
    private String port;
    private String host;
    private Map<String, String> credentials = new HashMap<String, String>();

    public DefaultJmxSupportAgent() {
        super("jmx-default-config");
    }

    @Override
    public String getDescription() {
        return "Default Jmx Support Agent";
    }

    @Override
    public void start() throws MuleException {
    }

    @Override
    public void stop() throws MuleException {
    }

    @Override
    public void dispose() {
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            MuleContextAware agent = this.createRmiAgent();
            MuleRegistry registry = this.muleContext.getRegistry();
            if (!this.isAgentRegistered((Agent)((Object)agent))) {
                registry.registerAgent((Agent)((Object)agent));
            }
            agent = this.createJmxAgent();
            if (registry.lookupObject(JmxAgent.class) == null) {
                registry.registerAgent((Agent)((Object)agent));
            }
            if (this.loadLog4jAgent && !this.isAgentRegistered((Agent)((Object)(agent = this.createLog4jAgent())))) {
                registry.registerAgent((Agent)((Object)agent));
            }
            if (!this.isAgentRegistered((Agent)((Object)(agent = this.createJmxNotificationAgent())))) {
                registry.registerAgent((Agent)((Object)agent));
            }
            if (this.loadJdmkAgent && !this.isAgentRegistered((Agent)((Object)(agent = this.createJdmkAgent())))) {
                registry.registerAgent((Agent)((Object)agent));
            }
            if (this.loadMx4jAgent && !this.isAgentRegistered((Agent)((Object)(agent = this.createMx4jAgent())))) {
                registry.registerAgent((Agent)((Object)agent));
            }
            if (this.loadProfilerAgent && !this.isAgentRegistered((Agent)((Object)(agent = this.createProfilerAgent())))) {
                registry.registerAgent((Agent)((Object)agent));
            }
            registry.unregisterAgent(this.name);
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public JmxAgent createJmxAgent() {
        JmxAgent agent;
        try {
            agent = this.muleContext.getRegistry().lookupObject(JmxAgent.class);
            if (agent == null) {
                agent = new JmxAgent();
            }
        }
        catch (RegistrationException e) {
            throw new RuntimeException(e);
        }
        String remotingUri = null;
        if (StringUtils.isBlank((String)this.host) && StringUtils.isBlank((String)this.port)) {
            remotingUri = "service:jmx:rmi:///jndi/rmi://localhost:1099/server";
        } else if (StringUtils.isNotBlank((String)this.host)) {
            Map<String, Object> props = agent.getConnectorServerProperties();
            HashMap<String, Object> mergedProps = new HashMap<String, Object>(props.size() + 1);
            mergedProps.putAll(props);
            FixedHostRmiClientSocketFactory factory = new FixedHostRmiClientSocketFactory(this.host);
            mergedProps.put("jmx.remote.rmi.client.socket.factory", factory);
            agent.setConnectorServerProperties(mergedProps);
        }
        if (StringUtils.isBlank((String)remotingUri)) {
            remotingUri = MessageFormat.format("service:jmx:rmi:///jndi/rmi://{0}:{1}/server", StringUtils.defaultString((String)this.host, (String)DEFAULT_HOST), StringUtils.defaultString((String)this.port, (String)DEFAULT_PORT));
        }
        if (this.credentials != null && !this.credentials.isEmpty()) {
            agent.setCredentials(this.credentials);
        }
        agent.setConnectorServerUrl(remotingUri);
        return agent;
    }

    protected Log4jAgent createLog4jAgent() {
        return new Log4jAgent();
    }

    protected RmiRegistryAgent createRmiAgent() {
        RmiRegistryAgent agent = new RmiRegistryAgent();
        agent.setHost(StringUtils.defaultString((String)this.host, (String)DEFAULT_HOST));
        agent.setPort(StringUtils.defaultString((String)this.port, (String)DEFAULT_PORT));
        return agent;
    }

    protected JmxServerNotificationAgent createJmxNotificationAgent() {
        return new JmxServerNotificationAgent();
    }

    protected Mx4jAgent createMx4jAgent() {
        return new Mx4jAgent();
    }

    protected JdmkAgent createJdmkAgent() {
        return new JdmkAgent();
    }

    protected YourKitProfilerAgent createProfilerAgent() {
        return new YourKitProfilerAgent();
    }

    protected boolean isAgentRegistered(Agent agent) {
        return this.muleContext.getRegistry().lookupAgent(agent.getName()) != null;
    }

    public boolean isLoadLog4jAgent() {
        return this.loadLog4jAgent;
    }

    public void setLoadLog4jAgent(boolean loadLog4jAgent) {
        this.loadLog4jAgent = loadLog4jAgent;
    }

    public boolean isLoadJdmkAgent() {
        return this.loadJdmkAgent;
    }

    public void setLoadJdmkAgent(boolean loadJdmkAgent) {
        this.loadJdmkAgent = loadJdmkAgent;
    }

    public boolean isLoadMx4jAgent() {
        return this.loadMx4jAgent;
    }

    public void setLoadMx4jAgent(boolean loadMx4jAgent) {
        this.loadMx4jAgent = loadMx4jAgent;
    }

    public boolean isLoadProfilerAgent() {
        return this.loadProfilerAgent;
    }

    public void setLoadProfilerAgent(boolean loadProfilerAgent) {
        this.loadProfilerAgent = loadProfilerAgent;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setCredentials(Map<String, String> credentials) {
        this.credentials = credentials;
    }
}

