/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.basicauth;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.ui.AuthenticationDetailsSource;
import org.acegisecurity.ui.AuthenticationDetailsSourceImpl;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class BasicProcessingFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$ui$basicauth$BasicProcessingFilter == null ? (class$org$acegisecurity$ui$basicauth$BasicProcessingFilter = BasicProcessingFilter.class$("org.acegisecurity.ui.basicauth.BasicProcessingFilter")) : class$org$acegisecurity$ui$basicauth$BasicProcessingFilter));
    private AuthenticationDetailsSource authenticationDetailsSource = new AuthenticationDetailsSourceImpl();
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationManager authenticationManager;
    private RememberMeServices rememberMeServices;
    private boolean ignoreFailure = false;
    static /* synthetic */ Class class$org$acegisecurity$ui$basicauth$BasicProcessingFilter;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"An AuthenticationEntryPoint is required");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String header = httpRequest.getHeader("Authorization");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authorization header: " + header));
        }
        if (header != null && header.startsWith("Basic ")) {
            String base64Token = header.substring(6);
            String token = new String(Base64.decodeBase64((byte[])base64Token.getBytes()));
            String username = "";
            String password = "";
            int delim = token.indexOf(":");
            if (delim != -1) {
                username = token.substring(0, delim);
                password = token.substring(delim + 1);
            }
            if (this.authenticationIsRequired(username)) {
                Authentication authResult;
                UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken(username, password);
                authRequest.setDetails(this.authenticationDetailsSource.buildDetails((HttpServletRequest)request));
                try {
                    authResult = this.authenticationManager.authenticate(authRequest);
                }
                catch (AuthenticationException failed) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Authentication request for user: " + username + " failed: " + failed.toString()));
                    }
                    SecurityContextHolder.getContext().setAuthentication(null);
                    if (this.rememberMeServices != null) {
                        this.rememberMeServices.loginFail(httpRequest, httpResponse);
                    }
                    if (this.ignoreFailure) {
                        chain.doFilter(request, response);
                    } else {
                        this.authenticationEntryPoint.commence(request, response, failed);
                    }
                    return;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Authentication success: " + authResult.toString()));
                }
                SecurityContextHolder.getContext().setAuthentication(authResult);
                if (this.rememberMeServices != null) {
                    this.rememberMeServices.loginSuccess(httpRequest, httpResponse, authResult);
                }
            }
        }
        chain.doFilter(request, response);
    }

    private boolean authenticationIsRequired(String username) {
        Authentication existingAuth = SecurityContextHolder.getContext().getAuthentication();
        if (existingAuth == null || !existingAuth.isAuthenticated()) {
            return true;
        }
        if (existingAuth instanceof UsernamePasswordAuthenticationToken && !existingAuth.getName().equals(username)) {
            return true;
        }
        return existingAuth instanceof AnonymousAuthenticationToken;
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setIgnoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

