/*
 * Decompiled with CFR 0.152.
 */
package org.mule.endpoint.outbound;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.MessageExchangePattern;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.lifecycle.LifecycleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.api.transport.MessageDispatcher;
import org.mule.api.transport.MessageDispatcherFactory;
import org.mule.endpoint.AbstractMessageProcessorTestCase;
import org.mule.endpoint.EndpointURIEndpointBuilder;
import org.mule.tck.security.TestSecurityFilter;
import org.mule.tck.testmodels.mule.TestMessageDispatcher;
import org.mule.tck.testmodels.mule.TestMessageDispatcherFactory;
import org.mule.transformer.simple.OutboundAppendTransformer;
import org.mule.transformer.simple.ResponseAppendTransformer;
import org.mule.util.concurrent.Latch;

public class OutboundEndpointTestCase
extends AbstractMessageProcessorTestCase {
    protected FakeMessageDispatcher dispacher;
    protected MuleEvent testOutboundEvent;

    public void testDefaultFlowSync() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageSentSame(true);
        OutboundEndpointTestCase.assertNotSame((Object)responseMessage, (Object)result.getMessage());
        this.assertMessageEqualEncodingPropertyAdded(responseMessage, result.getMessage());
    }

    public void testDefaultFlowAsync() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.dispacher.latch.await(5000L, TimeUnit.MILLISECONDS);
        this.assertMessageSentSame(false);
        OutboundEndpointTestCase.assertNull((Object)result);
    }

    public void testSecurityFilterAccept() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (EndpointSecurityFilter)new TestSecurityFilter(true), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageSentSame(true);
        OutboundEndpointTestCase.assertNotSame((Object)responseMessage, (Object)result.getMessage());
        this.assertMessageEqualEncodingPropertyAdded(responseMessage, result.getMessage());
    }

    public void testSecurityFilterNotAccept() throws Exception {
        AbstractMessageProcessorTestCase.TestSecurityNotificationListener securityNotificationListener = new AbstractMessageProcessorTestCase.TestSecurityNotificationListener();
        muleContext.registerListener((ServerNotificationListener)securityNotificationListener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, (EndpointSecurityFilter)new TestSecurityFilter(false), null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        RequestContext.setEvent((MuleEvent)this.testOutboundEvent);
        MuleEvent result = endpoint.process(this.testOutboundEvent);
        this.assertMessageNotSent();
        OutboundEndpointTestCase.assertNotNull((Object)result);
        OutboundEndpointTestCase.assertEquals((String)"unauthorized!!", (String)result.getMessage().getPayloadAsString());
        OutboundEndpointTestCase.assertNotNull((Object)result.getMessage().getExceptionPayload());
        OutboundEndpointTestCase.assertTrue((boolean)(result.getMessage().getExceptionPayload().getException() instanceof TestSecurityFilter.StaticMessageUnauthorisedException));
        OutboundEndpointTestCase.assertTrue((boolean)securityNotificationListener.latch.await(5000L, TimeUnit.MILLISECONDS));
        OutboundEndpointTestCase.assertEquals((int)401, (int)securityNotificationListener.securityNotification.getAction());
        OutboundEndpointTestCase.assertEquals((String)securityNotificationListener.securityNotification.getResourceIdentifier(), (String)TestSecurityFilter.StaticMessageUnauthorisedException.class.getName());
    }

    public void testSendNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(outboundEvent);
        OutboundEndpointTestCase.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        OutboundEndpointTestCase.assertEquals((int)803, (int)listener.messageNotification.getAction());
        OutboundEndpointTestCase.assertEquals((String)endpoint.getEndpointURI().getUri().toString(), (String)listener.messageNotification.getEndpoint());
        OutboundEndpointTestCase.assertTrue((boolean)(listener.messageNotification.getSource() instanceof MuleMessage));
        OutboundEndpointTestCase.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)((MuleMessage)listener.messageNotification.getSource()).getPayload());
    }

    public void testDispatchNotfication() throws Exception {
        AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener listener = new AbstractMessageProcessorTestCase.TestEndpointMessageNotificationListener();
        muleContext.registerListener((ServerNotificationListener)listener);
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.ONE_WAY, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.process(outboundEvent);
        OutboundEndpointTestCase.assertTrue((boolean)listener.latch.await(5000L, TimeUnit.MILLISECONDS));
        OutboundEndpointTestCase.assertEquals((int)802, (int)listener.messageNotification.getAction());
        OutboundEndpointTestCase.assertEquals((String)endpoint.getEndpointURI().getUri().toString(), (String)listener.messageNotification.getEndpoint());
        OutboundEndpointTestCase.assertTrue((boolean)(listener.messageNotification.getSource() instanceof MuleMessage));
        OutboundEndpointTestCase.assertEquals((Object)outboundEvent.getMessage().getPayload(), (Object)((MuleMessage)listener.messageNotification.getSource()).getPayload());
    }

    public void testTransformers() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, (Transformer)new OutboundAppendTransformer(), (Transformer)new ResponseAppendTransformer(), MessageExchangePattern.REQUEST_RESPONSE, null);
        MuleEvent outboundEvent = this.createTestOutboundEvent(endpoint);
        MuleEvent result = endpoint.process(outboundEvent);
        this.assertMessageSent(true);
        OutboundEndpointTestCase.assertEquals((String)("Test Message" + OutboundAppendTransformer.APPEND_STRING), (String)this.dispacher.sensedSendEvent.getMessageAsString());
        OutboundEndpointTestCase.assertNotNull((Object)result);
        OutboundEndpointTestCase.assertEquals((String)(RESPONSE_MESSAGE + ResponseAppendTransformer.APPEND_STRING), (String)result.getMessageAsString());
    }

    public void testConnectorNotStarted() throws Exception {
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        endpoint.getConnector().stop();
        try {
            endpoint.process(this.testOutboundEvent);
            OutboundEndpointTestCase.fail((String)"Exception expected");
        }
        catch (LifecycleException lifecycleException) {
            // empty catch block
        }
    }

    public void testTimeoutSetOnEvent() throws Exception {
        int testTimeout = 999;
        OutboundEndpoint endpoint = this.createOutboundEndpoint(null, null, null, null, MessageExchangePattern.REQUEST_RESPONSE, null);
        this.testOutboundEvent = this.createTestOutboundEvent(endpoint);
        this.testOutboundEvent.getMessage().setOutboundProperty("MULE_EVENT_TIMEOUT", (Object)testTimeout);
        endpoint.process(this.testOutboundEvent);
        OutboundEndpointTestCase.assertEquals((int)testTimeout, (int)this.dispacher.sensedSendEvent.getTimeout());
    }

    public void testObjectAwareInjection() throws Exception {
        EndpointURIEndpointBuilder endpointBuilder = new EndpointURIEndpointBuilder("test://myTestUri", muleContext);
        endpointBuilder.addMessageProcessor((MessageProcessor)new AbstractMessageProcessorTestCase.ObjectAwareProcessor());
        OutboundEndpoint endpoint = endpointBuilder.buildOutboundEndpoint();
        endpoint.process(this.createTestOutboundEvent(endpoint));
        AbstractMessageProcessorTestCase.ObjectAwareProcessor objectAware = (AbstractMessageProcessorTestCase.ObjectAwareProcessor)endpoint.getMessageProcessors().get(0);
        OutboundEndpointTestCase.assertEquals((Object)muleContext, (Object)objectAware.context);
        OutboundEndpointTestCase.assertEquals((Object)endpoint, (Object)objectAware.endpoint);
    }

    public void testTransaction() {
    }

    public void testExceptionHandling() {
    }

    protected MuleEvent assertMessageSent(boolean sync) throws MuleException {
        MuleEvent event;
        if (sync) {
            OutboundEndpointTestCase.assertNull((Object)this.dispacher.sensedDispatchEvent);
            OutboundEndpointTestCase.assertNotNull((Object)this.dispacher.sensedSendEvent);
            event = this.dispacher.sensedSendEvent;
        } else {
            OutboundEndpointTestCase.assertNull((Object)this.dispacher.sensedSendEvent);
            OutboundEndpointTestCase.assertNotNull((Object)this.dispacher.sensedDispatchEvent);
            event = this.dispacher.sensedDispatchEvent;
        }
        OutboundEndpointTestCase.assertNotNull((Object)event.getMessage());
        return event;
    }

    protected MuleEvent assertMessageSentSame(boolean sync) throws MuleException {
        MuleEvent event = this.assertMessageSent(sync);
        if (sync) {
            OutboundEndpointTestCase.assertEquals((Object)this.testOutboundEvent, (Object)event);
        }
        OutboundEndpointTestCase.assertEquals((String)"Test Message", (String)event.getMessageAsString());
        OutboundEndpointTestCase.assertEquals((Object)"value1", (Object)event.getMessage().getOutboundProperty("prop1"));
        return event;
    }

    protected void assertMessageNotSent() throws MuleException {
        OutboundEndpointTestCase.assertNull((Object)this.dispacher.sensedSendEvent);
        OutboundEndpointTestCase.assertNull((Object)this.dispacher.sensedDispatchEvent);
    }

    protected void assertMessageEqualEncodingPropertyAdded(MuleMessage expect, MuleMessage actual) {
        OutboundEndpointTestCase.assertEquals((Object)expect.getPayload(), (Object)actual.getPayload());
        OutboundEndpointTestCase.assertEquals((String)expect.getEncoding(), (String)actual.getEncoding());
        OutboundEndpointTestCase.assertEquals((String)expect.getUniqueId(), (String)actual.getUniqueId());
        OutboundEndpointTestCase.assertEquals((Object)expect.getExceptionPayload(), (Object)actual.getExceptionPayload());
        OutboundEndpointTestCase.assertEquals((Object)muleContext.getConfiguration().getDefaultEncoding(), (Object)actual.getOutboundProperty("MULE_ENCODING"));
    }

    protected OutboundEndpoint createOutboundEndpoint(String uri, Filter filter, EndpointSecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        OutboundEndpoint endpoint = this.createTestOutboundEndpoint(uri, filter, securityFilter, in, response, exchangePattern, txConfig);
        this.dispacher = new FakeMessageDispatcher(endpoint);
        Connector connector = endpoint.getConnector();
        connector.setDispatcherFactory((MessageDispatcherFactory)new TestMessageDispatcherFactory(){

            public MessageDispatcher create(OutboundEndpoint ep) throws MuleException {
                return OutboundEndpointTestCase.this.dispacher;
            }
        });
        return endpoint;
    }

    protected OutboundEndpoint createOutboundEndpoint(Filter filter, EndpointSecurityFilter securityFilter, Transformer in, Transformer response, MessageExchangePattern exchangePattern, TransactionConfig txConfig) throws Exception {
        return this.createOutboundEndpoint("test://test", filter, securityFilter, in, response, exchangePattern, txConfig);
    }

    static class FakeMessageDispatcher
    extends TestMessageDispatcher {
        Latch latch = new Latch();
        MuleEvent sensedSendEvent;
        MuleEvent sensedDispatchEvent;

        public FakeMessageDispatcher(OutboundEndpoint endpoint) {
            super(endpoint);
        }

        protected MuleMessage doSend(MuleEvent event) throws Exception {
            this.sensedSendEvent = event;
            this.latch.countDown();
            return responseMessage;
        }

        protected void doDispatch(MuleEvent event) throws Exception {
            this.sensedDispatchEvent = event;
            this.latch.countDown();
        }
    }
}

